/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.metric;

import java.util.Map;
import org.apache.ctakes.ytex.kernel.metric.BaseSimilarityMetric;
import org.apache.ctakes.ytex.kernel.metric.ConceptSimilarityService;
import org.apache.ctakes.ytex.kernel.metric.SimilarityInfo;

public class IntrinsicPathMetric
extends BaseSimilarityMetric {
    Double maxIC;

    public IntrinsicPathMetric(ConceptSimilarityService simSvc, Double maxIC) {
        super(simSvc);
        this.maxIC = maxIC;
    }

    @Override
    public double similarity(String concept1, String concept2, Map<String, Double> conceptFilter, SimilarityInfo simInfo) {
        if (this.maxIC == null) {
            return 0.0;
        }
        double lcsIC = this.initLcsIC(concept1, concept2, conceptFilter, simInfo, true);
        if (lcsIC == 0.0) {
            return 0.0;
        }
        double ic1 = this.simSvc.getIC(concept1, true);
        double ic2 = this.simSvc.getIC(concept2, true);
        return 1.0 / (ic1 + ic2 - 2.0 * lcsIC + 1.0);
    }
}

