/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.model;

import java.io.Serializable;
import org.apache.ctakes.ytex.dao.DBUtil;
import org.apache.ctakes.ytex.kernel.model.ClassifierEvaluation;

public class ClassifierEvaluationIRStat
implements Serializable {
    private static final long serialVersionUID = 1L;
    ClassifierEvaluation classifierEvaluation;
    int classifierEvaluationIRStatId;
    double f1;
    int fn;
    int fp;
    String irClass;
    int irClassId;
    double npv;
    double ppv;
    double sensitivity;
    double specificity;
    int tn;
    int tp;
    String type = DBUtil.getEmptyString();

    public ClassifierEvaluationIRStat() {
    }

    public ClassifierEvaluationIRStat(ClassifierEvaluation classifierEvaluation, String type, String irClass, Integer irClassId, int tp, int tn, int fp, int fn) {
        this.classifierEvaluation = classifierEvaluation;
        this.type = DBUtil.nullToEmptyString(type);
        this.irClass = irClass;
        this.irClassId = irClassId;
        this.tp = tp;
        this.tn = tn;
        this.fp = fp;
        this.fn = fn;
        this.ppv = tp + fp > 0 ? (double)tp / (double)(tp + fp) : 0.0;
        this.npv = tn + fn > 0 ? (double)tn / (double)(tn + fn) : 0.0;
        this.sensitivity = tp + fn > 0 ? (double)tp / (double)(tp + fn) : 0.0;
        this.specificity = tn + fp > 0 ? (double)tn / (double)(tn + fp) : 0.0;
        this.f1 = this.ppv + this.sensitivity > 0.0 ? 2.0 * this.ppv * this.sensitivity / (this.ppv + this.sensitivity) : 0.0;
    }

    public ClassifierEvaluation getClassifierEvaluation() {
        return this.classifierEvaluation;
    }

    public int getClassifierEvaluationIRStatId() {
        return this.classifierEvaluationIRStatId;
    }

    public double getF1() {
        return this.f1;
    }

    public int getFn() {
        return this.fn;
    }

    public int getFp() {
        return this.fp;
    }

    public String getIrClass() {
        return this.irClass;
    }

    public int getIrClassId() {
        return this.irClassId;
    }

    public double getNpv() {
        return this.npv;
    }

    public double getPpv() {
        return this.ppv;
    }

    public double getSensitivity() {
        return this.sensitivity;
    }

    public double getSpecificity() {
        return this.specificity;
    }

    public int getTn() {
        return this.tn;
    }

    public int getTp() {
        return this.tp;
    }

    public String getType() {
        return this.type;
    }

    public void setClassifierEvaluation(ClassifierEvaluation classifierEvaluation) {
        this.classifierEvaluation = classifierEvaluation;
    }

    public void setClassifierEvaluationIRStatId(int classifierEvaluationIRStatId) {
        this.classifierEvaluationIRStatId = classifierEvaluationIRStatId;
    }

    public void setF1(double f1) {
        this.f1 = f1;
    }

    public void setFn(int fn) {
        this.fn = fn;
    }

    public void setFp(int fp) {
        this.fp = fp;
    }

    public void setIrClass(String irClass) {
        this.irClass = irClass;
    }

    public void setIrClassId(int ir_classId) {
        this.irClassId = ir_classId;
    }

    public void setNpv(double npv) {
        this.npv = npv;
    }

    public void setPpv(double ppv) {
        this.ppv = ppv;
    }

    public void setSensitivity(double sensitivity) {
        this.sensitivity = sensitivity;
    }

    public void setSpecificity(double specificity) {
        this.specificity = specificity;
    }

    public void setTn(int tn) {
        this.tn = tn;
    }

    public void setTp(int tp) {
        this.tp = tp;
    }

    public void setType(String type) {
        this.type = type;
    }
}

