/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.ctakes.ytex.kernel.model.FeatureEvaluation;

public class FeatureRank
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double evaluation;
    private FeatureEvaluation featureEval;
    private String featureName;
    private int rank;
    private int featureRankId;

    public static List<FeatureRank> sortFeatureRankList(List<FeatureRank> featureRankList, Comparator<FeatureRank> comp) {
        Collections.sort(featureRankList, comp);
        for (int i = 0; i < featureRankList.size(); ++i) {
            featureRankList.get(i).setRank(i + 1);
        }
        return featureRankList;
    }

    public int getFeatureRankId() {
        return this.featureRankId;
    }

    public void setFeatureRankId(int featureRankId) {
        this.featureRankId = featureRankId;
    }

    public FeatureRank() {
    }

    public FeatureRank(String featureName, double evaluation) {
        this.featureName = featureName;
        this.evaluation = evaluation;
    }

    public FeatureRank(FeatureEvaluation featureEval, String featureName, double evaluation) {
        this.featureEval = featureEval;
        this.featureName = featureName;
        this.evaluation = evaluation;
    }

    public FeatureRank(FeatureEvaluation featureEval, String featureName, double evaluation, int rank) {
        this.featureEval = featureEval;
        this.featureName = featureName;
        this.evaluation = evaluation;
        this.rank = rank;
    }

    public double getEvaluation() {
        return this.evaluation;
    }

    public FeatureEvaluation getFeatureEval() {
        return this.featureEval;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public int getRank() {
        return this.rank;
    }

    public void setEvaluation(double evaluation) {
        this.evaluation = evaluation;
    }

    public void setFeatureEval(FeatureEvaluation featureEval) {
        this.featureEval = featureEval;
    }

    public void setFeatureName(String featureName) {
        this.featureName = featureName;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public String toString() {
        return "FeatureRank [featureName=" + this.featureName + ", evaluation=" + this.evaluation + ", rank=" + this.rank + "]";
    }

    public static class FeatureRankDesc
    implements Comparator<FeatureRank> {
        @Override
        public int compare(FeatureRank o1, FeatureRank o2) {
            if (o1.getEvaluation() > o2.getEvaluation()) {
                return -1;
            }
            if (o1.getEvaluation() == o2.getEvaluation()) {
                return o1.getFeatureName().compareTo(o2.getFeatureName());
            }
            return 1;
        }
    }

    public static class FeatureRankAsc
    implements Comparator<FeatureRank> {
        @Override
        public int compare(FeatureRank o1, FeatureRank o2) {
            if (o1.getEvaluation() > o2.getEvaluation()) {
                return 1;
            }
            if (o1.getEvaluation() == o2.getEvaluation()) {
                return o1.getFeatureName().compareTo(o2.getFeatureName());
            }
            return -1;
        }
    }
}

