/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.weka;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.SortedMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.kernel.FileUtil;
import org.apache.ctakes.ytex.kernel.KernelContextHolder;
import org.apache.ctakes.ytex.kernel.KernelUtil;
import org.apache.ctakes.ytex.kernel.SparseData;
import org.apache.ctakes.ytex.kernel.SparseDataExporter;
import org.apache.ctakes.ytex.kernel.dao.ClassifierEvaluationDao;
import org.apache.ctakes.ytex.kernel.model.CrossValidationFold;
import org.apache.ctakes.ytex.kernel.model.FeatureEvaluation;
import org.apache.ctakes.ytex.kernel.model.FeatureRank;
import org.apache.ctakes.ytex.weka.WekaAttributeEvaluator;
import org.apache.ctakes.ytex.weka.WekaFormatterFactory;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.AttributeSelection;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;

public class WekaAttributeEvaluatorImpl
implements WekaAttributeEvaluator {
    private static final Log log = LogFactory.getLog(WekaAttributeEvaluatorImpl.class);
    private ASEvaluation asEvaluation;
    private AttributeSelection attributeSelection;
    private ClassifierEvaluationDao classifierEvaluationDao;
    private KernelUtil kernelUtil;
    private SparseDataExporter sparseDataExporter;

    public static void main(String[] args) throws Exception {
        Options options = new Options();
        OptionBuilder.withArgName((String)"property file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"load parameters from property file.  If queries defiend as for SparseDataExporter, use them to load the instances");
        options.addOption(OptionBuilder.create((String)"prop"));
        OptionBuilder.withArgName((String)"train_data.arff");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use specified weka arff file to load instances for evaluation.");
        options.addOption(OptionBuilder.create((String)"arff"));
        try {
            GnuParser parser = new GnuParser();
            CommandLine line = parser.parse(options, args);
            Properties props = FileUtil.loadProperties(line.getOptionValue("prop"), true);
            String corpusName = props.getProperty("org.apache.ctakes.ytex.corpusName");
            String splitName = props.getProperty("org.apache.ctakes.ytex.splitName");
            String featureSetName = props.getProperty("org.apache.ctakes.ytex.featureSetName");
            WekaAttributeEvaluator wekaEval = (WekaAttributeEvaluator)KernelContextHolder.getApplicationContext().getBean(WekaAttributeEvaluator.class);
            if (line.hasOption("arff")) {
                wekaEval.evaluateAttributesFromFile(corpusName, splitName, featureSetName, line.getOptionValue("arff"));
            } else {
                wekaEval.evaluateAttributesFromProps(corpusName, splitName, featureSetName, props);
            }
        }
        catch (ParseException pe) {
            WekaAttributeEvaluatorImpl.printHelp(options);
        }
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java " + WekaAttributeEvaluatorImpl.class.getName() + " evaluate attributes using a weka AttributeEvaluator", options);
    }

    public void evaluateAttributes(String corpusName, String featureSetName, String splitName, Instances inst, String label, Integer run, Integer fold) throws Exception {
        AttributeSelection ae = this.getAttributeSelection();
        ae.SelectAttributes(inst);
        double[][] rankedAttributes = ae.rankedAttributes();
        FeatureEvaluation fe = this.initializeFeatureEvaluation(corpusName, featureSetName, splitName, label, run, fold);
        ArrayList<FeatureRank> featureRanks = new ArrayList<FeatureRank>(rankedAttributes.length);
        for (int i = 0; i < rankedAttributes.length; ++i) {
            int index = (int)rankedAttributes[i][0];
            double eval = rankedAttributes[i][1];
            FeatureRank r = new FeatureRank();
            r.setFeatureEval(fe);
            r.setFeatureName(inst.attribute(index).name());
            r.setRank(i + 1);
            r.setEvaluation(eval);
            featureRanks.add(r);
        }
        this.classifierEvaluationDao.deleteFeatureEvaluation(corpusName, featureSetName, label, fe.getEvaluationType(), fe.getCrossValidationFoldId(), fe.getParam1(), fe.getParam2());
        this.classifierEvaluationDao.saveFeatureEvaluation(fe, featureRanks);
    }

    @Override
    public void evaluateAttributesFromFile(String corpusName, String featureSetName, String splitName, String file) throws Exception {
        ConverterUtils.DataSource ds = new ConverterUtils.DataSource(file);
        Instances inst = ds.getDataSet();
        String label = FileUtil.parseLabelFromFileName(inst.relationName());
        Integer run = FileUtil.parseRunFromFileName(inst.relationName());
        Integer fold = FileUtil.parseFoldFromFileName(inst.relationName());
        this.evaluateAttributes(corpusName, featureSetName, splitName, inst, label, run, fold);
    }

    @Override
    public void evaluateAttributesFromProps(String corpusName, String splitName, String featureSetName, Properties props) throws Exception {
        this.sparseDataExporter.exportData(props, new WekaAttributeEvaluatorFormatter(corpusName, featureSetName, splitName), null);
    }

    public ASEvaluation getAsEvaluation() {
        return this.asEvaluation;
    }

    public AttributeSelection getAttributeSelection() {
        return this.attributeSelection;
    }

    public ClassifierEvaluationDao getClassifierEvaluationDao() {
        return this.classifierEvaluationDao;
    }

    public KernelUtil getKernelUtil() {
        return this.kernelUtil;
    }

    public SparseDataExporter getSparseDataExporter() {
        return this.sparseDataExporter;
    }

    public FeatureEvaluation initializeFeatureEvaluation(String corpusName, String featureSetName, String splitName, String label, Integer run, Integer fold) {
        FeatureEvaluation fe = new FeatureEvaluation();
        fe.setCorpusName(corpusName);
        fe.setFeatureSetName(featureSetName);
        fe.setEvaluationType(this.getAsEvaluation().getClass().getSimpleName());
        fe.setLabel(label);
        if (run != null && fold != null) {
            CrossValidationFold cvFold = this.classifierEvaluationDao.getCrossValidationFold(corpusName, splitName, label, run, fold);
            if (cvFold != null) {
                fe.setCrossValidationFoldId(cvFold.getCrossValidationFoldId());
            } else {
                log.warn((Object)("could not obtain cv_fold_id. label=" + label + ", run=" + run + ", fold=" + fold));
            }
        }
        return fe;
    }

    public void setAsEvaluation(ASEvaluation asEvaluation) {
        this.asEvaluation = asEvaluation;
    }

    public void setAttributeSelection(AttributeSelection attributeSelection) {
        this.attributeSelection = attributeSelection;
    }

    public void setClassifierEvaluationDao(ClassifierEvaluationDao classifierEvaluationDao) {
        this.classifierEvaluationDao = classifierEvaluationDao;
    }

    public void setKernelUtil(KernelUtil kernelUtil) {
        this.kernelUtil = kernelUtil;
    }

    public void setSparseDataExporter(SparseDataExporter sparseDataExporter) {
        this.sparseDataExporter = sparseDataExporter;
    }

    public class WekaAttributeEvaluatorFormatter
    extends WekaFormatterFactory.WekaFormatter {
        String corpusName;
        String featureSetName;
        String splitName;

        public WekaAttributeEvaluatorFormatter(String corpusName, String featureSetName, String splitName) {
            super(WekaAttributeEvaluatorImpl.this.getKernelUtil());
            this.featureSetName = featureSetName;
            this.corpusName = corpusName;
            this.splitName = splitName;
        }

        @Override
        public void exportFold(SparseData sparseData, SortedMap<Long, String> instanceClasses, boolean train, String label, Integer run, Integer fold) throws IOException {
            if (train) {
                Instances inst = this.initializeInstances(sparseData, instanceClasses, train, label, run, fold);
                try {
                    WekaAttributeEvaluatorImpl.this.evaluateAttributes(this.corpusName, this.featureSetName, this.splitName, inst, label, run, fold);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        }
    }
}

