/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae;

import com.google.common.collect.Maps;
import java.util.HashMap;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.timeml.type.Anchor;
import org.cleartk.timeml.type.DocumentCreationTime;
import org.cleartk.timeml.type.Event;
import org.cleartk.timeml.type.TemporalLink;

@PipeBitInfo(name="DocTimeRel ClearTK Annotator", description="Annotates event relativity to document creation time.", dependencies={PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION, PipeBitInfo.TypeProduct.EVENT})
public class ClearTKDocTimeRelAnnotator
extends JCasAnnotator_ImplBase {
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        DocumentCreationTime dct = (DocumentCreationTime)JCasUtil.selectSingle((JCas)jCas, DocumentCreationTime.class);
        HashMap docTimeRels = Maps.newHashMap();
        for (TemporalLink tlink : JCasUtil.select((JCas)jCas, TemporalLink.class)) {
            Anchor source = tlink.getSource();
            Anchor target = tlink.getTarget();
            if (!(source instanceof Event) || !target.equals((Object)dct)) continue;
            for (EventMention event : JCasUtil.selectCovered((JCas)jCas, EventMention.class, (AnnotationFS)source)) {
                docTimeRels.put(event, tlink.getRelationType());
            }
        }
        for (EventMention eventMention : JCasUtil.select((JCas)jCas, EventMention.class)) {
            if (!eventMention.getClass().equals(EventMention.class)) continue;
            String docTimeRel = (String)docTimeRels.get(eventMention);
            if (docTimeRel == null || "INCLUDES".equals(docTimeRel)) {
                docTimeRel = "OVERLAP";
            }
            eventMention.getEvent().getProperties().setDocTimeRel(docTimeRel);
        }
    }

    public static AnalysisEngineDescription getAnnotatorDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(ClearTKDocTimeRelAnnotator.class, (Object[])new Object[0]);
    }
}

