/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.temporal.ae.TemporalEntityAnnotator_ImplBase;
import org.apache.ctakes.temporal.ae.feature.TimeWordTypeExtractor;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.TopTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.DataWriter;
import org.cleartk.ml.Feature;
import org.cleartk.ml.Instance;
import org.cleartk.ml.feature.extractor.CleartkExtractor;
import org.cleartk.ml.feature.extractor.CombinedExtractor1;
import org.cleartk.ml.feature.extractor.CoveredTextExtractor;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.feature.extractor.TypePathExtractor;
import org.cleartk.ml.feature.function.CharacterCategoryPatternFunction;
import org.cleartk.timeml.util.TimeWordsExtractor;

@PipeBitInfo(name="Constituency Timex Filter", description="Creates Timex annotations.", dependencies={PipeBitInfo.TypeProduct.SECTION, PipeBitInfo.TypeProduct.BASE_TOKEN, PipeBitInfo.TypeProduct.TIMEX})
public class ConstituencyBasedTimeAnnotator
extends TemporalEntityAnnotator_ImplBase {
    private static final String NON_MENTION = "NON_TIME_MENTION";
    private static final String MENTION = "TIME_MENTION";
    private static Logger logger = Logger.getLogger(ConstituencyBasedTimeAnnotator.class);
    private static final int SPAN_LIMIT = 12;
    public static final String PARAM_TIMEX_VIEW = "TimexView";
    @ConfigurationParameter(name="TimexView", mandatory=false, description="View to write timexes to (used for ensemble methods)")
    protected String timexView = "_InitialView";
    protected List<FeatureExtractor1> featureExtractors;
    protected FeatureExtractor1 wordTypeExtractor;
    private static final String LOOKUP_PATH = "/org/apache/ctakes/temporal/time_word_types.txt";
    private Map<String, String> wordTypes;

    public static AnalysisEngineDescription createDataWriterDescription(Class<? extends DataWriter<String>> dataWriterClass, File outputDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(ConstituencyBasedTimeAnnotator.class, (Object[])new Object[]{"isTraining", true, "dataWriterClassName", dataWriterClass, "outputDirectory", outputDirectory});
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String modelPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(ConstituencyBasedTimeAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", modelPath});
    }

    public static AnalysisEngineDescription createEnsembleDescription(String modelPath, String viewName) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(ConstituencyBasedTimeAnnotator.class, (Object[])new Object[]{"isTraining", false, PARAM_TIMEX_VIEW, viewName, "classifierJarPath", modelPath});
    }

    public static AnalysisEngineDescription createAnnotatorDescription(File modelDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(ConstituencyBasedTimeAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", new File(modelDirectory, "model.jar")});
    }

    public static AnalysisEngineDescription createEnsembleDescription(File modelDirectory, String viewName) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(ConstituencyBasedTimeAnnotator.class, (Object[])new Object[]{"isTraining", false, PARAM_TIMEX_VIEW, viewName, "classifierJarPath", new File(modelDirectory, "model.jar")});
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        CombinedExtractor1 charExtractors = new CombinedExtractor1((FeatureExtractor1)CharacterCategoryPatternFunction.createExtractor((CharacterCategoryPatternFunction.PatternType)CharacterCategoryPatternFunction.PatternType.REPEATS_MERGED), (FeatureExtractor1)CharacterCategoryPatternFunction.createExtractor((CharacterCategoryPatternFunction.PatternType)CharacterCategoryPatternFunction.PatternType.ONE_PER_CHAR));
        this.wordTypes = Maps.newHashMap();
        URL url = TimeWordsExtractor.class.getResource(LOOKUP_PATH);
        try {
            for (String line : Resources.readLines((URL)url, (Charset)Charsets.US_ASCII)) {
                String[] typeAndWord = line.split("\\s+");
                if (typeAndWord.length != 2) {
                    throw new IllegalArgumentException("Expected '<type> <word>', found: " + line);
                }
                this.wordTypes.put(typeAndWord[1], typeAndWord[0]);
            }
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        CombinedExtractor1 allExtractors = new CombinedExtractor1((FeatureExtractor1)new CoveredTextExtractor(), (FeatureExtractor1)charExtractors, (FeatureExtractor1)new TypePathExtractor(BaseToken.class, "partOfSpeech"));
        this.featureExtractors = new ArrayList<FeatureExtractor1>();
        this.featureExtractors.add((FeatureExtractor1)new CleartkExtractor(BaseToken.class, (FeatureExtractor1)allExtractors, new CleartkExtractor.Context[]{new CleartkExtractor.Bag(new CleartkExtractor.Context[]{new CleartkExtractor.Covered()})}));
        this.wordTypeExtractor = new CleartkExtractor(BaseToken.class, new TimeWordTypeExtractor(), new CleartkExtractor.Context[]{new CleartkExtractor.Bag(new CleartkExtractor.Context[]{new CleartkExtractor.Covered()})});
    }

    @Override
    public void process(JCas jCas, Segment segment) throws AnalysisEngineProcessException {
        HashSet<TimeMention> mentions = new HashSet<TimeMention>(JCasUtil.selectCovered(TimeMention.class, (AnnotationFS)segment));
        for (TopTreebankNode root : JCasUtil.selectCovered(TopTreebankNode.class, (AnnotationFS)segment)) {
            this.recursivelyProcessNode(jCas, root.getChildren(0), mentions, 0.0);
        }
    }

    private double recursivelyProcessNode(JCas jCas, TreebankNode node, Set<TimeMention> mentions, double parentScore) throws AnalysisEngineProcessException {
        double score = 0.0;
        parentScore = 0.0;
        ArrayList<Feature> features = new ArrayList<Feature>();
        String category = NON_MENTION;
        if (node.getParent().getParent() == null) {
            features.add(new Feature((Object)"IS_ROOT"));
        }
        features.add(new Feature("NODE_LABEL", (Object)node.getNodeType()));
        features.add(new Feature("PARENT_LABEL", (Object)node.getParent().getNodeType()));
        List coveredTokens = JCasUtil.selectCovered(BaseToken.class, (AnnotationFS)node);
        int numTokens = coveredTokens.size();
        if (node.getLeaf()) {
            features.add(new Feature((Object)"IS_LEAF"));
            features.addAll(this.wordTypeExtractor.extract(jCas, (Annotation)node));
        } else {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < node.getChildren().size(); ++i) {
                buffer.append(node.getChildren(i).getNodeType());
                buffer.append("_");
                features.add(new Feature("CHILD_BAG", (Object)node.getChildren(i).getNodeType()));
            }
            features.add(new Feature("PRODUCTION", (Object)buffer.toString()));
        }
        for (FeatureExtractor1 extractor : this.featureExtractors) {
            features.addAll(extractor.extract(jCas, (Annotation)node));
        }
        if (this.isTraining()) {
            List goldMentions = JCasUtil.selectCovered(TimeMention.class, (AnnotationFS)node);
            for (TimeMention mention : goldMentions) {
                if (mention.getBegin() != node.getBegin() || mention.getEnd() != node.getEnd()) continue;
                category = MENTION;
                score = 1.0;
                mentions.remove(mention);
                if (!node.getCoveredText().contains("postoperative")) continue;
                System.out.println("*** Positive Example: ***");
                System.out.println("*** Parent: " + node.getParent().getCoveredText());
                ConstituencyBasedTimeAnnotator.printFeatures(node, features);
            }
            if (numTokens < 12) {
                this.dataWriter.write(new Instance((Object)category, features));
            }
        } else {
            Map outcomes = this.classifier.score(features);
            score = (Double)outcomes.get(MENTION);
            category = (String)this.classifier.classify(features);
            if (category.equals(MENTION)) {
                JCas timexCas;
                TimeMention mention;
                try {
                    timexCas = jCas.getView(this.timexView);
                }
                catch (CASException e) {
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
                mention = new TimeMention(timexCas, node.getBegin(), node.getEnd());
                mention.setConfidence((float)score);
                mention.addToIndexes();
            } else {
                score = 1.0 - score;
            }
        }
        if (node.getLeaf() || MENTION.equals(category)) {
            return score;
        }
        double highestScore = 0.5;
        TreebankNode highestScoringChild = null;
        for (int i = 0; i < node.getChildren().size(); ++i) {
            TreebankNode child = node.getChildren(i);
            double childScore = this.recursivelyProcessNode(jCas, child, mentions, Math.max(score, parentScore));
            if (!(childScore > highestScore)) continue;
            highestScoringChild = child;
            highestScore = childScore;
        }
        if (!this.isTraining() && MENTION.equals(category)) {
            logger.info((Object)String.format("\nFound mention (%s) with score %f\n\tParent (%s) : %f\n\tBest child (%s) : %f\n", node.getCoveredText(), score, node.getParent().getCoveredText(), parentScore, highestScoringChild == null ? "(none)" : highestScoringChild.getCoveredText(), highestScore));
        }
        return score;
    }

    private static void printFeatures(TreebankNode node, List<Feature> features) {
        System.out.println(node.getCoveredText());
        for (Feature feat : features) {
            System.out.printf("%s => %s\n", feat.getName(), feat.getValue());
        }
    }
}

