/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.temporal.ae.feature.ClosestVerbExtractor;
import org.apache.ctakes.temporal.ae.feature.DateAndMeasurementExtractor;
import org.apache.ctakes.temporal.ae.feature.EventPositionFeatureExtractor;
import org.apache.ctakes.temporal.ae.feature.EventPropertyExtractor;
import org.apache.ctakes.temporal.ae.feature.NearbyVerbTenseXExtractor;
import org.apache.ctakes.temporal.ae.feature.TimeXExtractor;
import org.apache.ctakes.temporal.ae.feature.UmlsSingleFeatureExtractor;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.CleartkAnnotator;
import org.cleartk.ml.DataWriter;
import org.cleartk.ml.Feature;
import org.cleartk.ml.Instance;
import org.cleartk.ml.feature.extractor.CleartkExtractor;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.CombinedExtractor1;
import org.cleartk.ml.feature.extractor.CoveredTextExtractor;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.feature.extractor.TypePathExtractor;

@PipeBitInfo(name="Admission Time Annotator", description="Adds Temporal Relations for Events with respect to the time of Patient Admission.", dependencies={PipeBitInfo.TypeProduct.SECTION, PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.TIMEX, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION}, products={PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
public class EventAdmissionTimeAnnotator
extends CleartkAnnotator<String> {
    private CleartkExtractor<EventMention, BaseToken> contextExtractor;
    private NearbyVerbTenseXExtractor verbTensePatternExtractor;
    private EventPositionFeatureExtractor eventPositionExtractor;
    private ClosestVerbExtractor closestVerbExtractor;
    private TimeXExtractor timeXExtractor;
    private EventPropertyExtractor genericExtractor;
    private DateAndMeasurementExtractor dateExtractor;
    private UmlsSingleFeatureExtractor umlsExtractor;

    public static AnalysisEngineDescription createDataWriterDescription(Class<? extends DataWriter<String>> dataWriterClass, File outputDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(EventAdmissionTimeAnnotator.class, (Object[])new Object[]{"isTraining", true, "dataWriterClassName", dataWriterClass, "outputDirectory", outputDirectory});
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String modelPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(EventAdmissionTimeAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", modelPath});
    }

    public static AnalysisEngineDescription createAnnotatorDescription(File modelDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(EventAdmissionTimeAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", new File(modelDirectory, "model.jar")});
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        CombinedExtractor1 baseExtractor = new CombinedExtractor1((FeatureExtractor1)new CoveredTextExtractor(), (FeatureExtractor1)new TypePathExtractor(BaseToken.class, "partOfSpeech"));
        this.contextExtractor = new CleartkExtractor(BaseToken.class, (FeatureExtractor1)baseExtractor, new CleartkExtractor.Context[]{new CleartkExtractor.Preceding(3), new CleartkExtractor.Covered(), new CleartkExtractor.Following(3)});
        this.verbTensePatternExtractor = new NearbyVerbTenseXExtractor();
        this.eventPositionExtractor = new EventPositionFeatureExtractor();
        this.closestVerbExtractor = new ClosestVerbExtractor();
        this.timeXExtractor = new TimeXExtractor();
        this.genericExtractor = new EventPropertyExtractor();
        this.dateExtractor = new DateAndMeasurementExtractor();
        this.umlsExtractor = new UmlsSingleFeatureExtractor();
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        TimeMention admissionTime = null;
        for (TimeMention time : JCasUtil.selectCovered((JCas)jCas, TimeMention.class, (int)15, (int)30)) {
            if (!time.getTimeClass().equals("DATE")) continue;
            admissionTime = time;
            break;
        }
        ArrayList courses = Lists.newArrayList();
        Collection segments = JCasUtil.select((JCas)jCas, Segment.class);
        for (Object seg : segments) {
            if (!seg.getId().equals("course") || JCasUtil.selectCovered((JCas)jCas, Sentence.class, (AnnotationFS)seg).size() <= 0) continue;
            courses.add(seg);
        }
        if (admissionTime != null) {
            HashMap<List<Annotation>, TemporalTextRelation> dischargeTimeRelationLookup = new HashMap<List<Annotation>, TemporalTextRelation>();
            if (this.isTraining()) {
                dischargeTimeRelationLookup = new HashMap();
                for (TemporalTextRelation relation : JCasUtil.select((JCas)jCas, TemporalTextRelation.class)) {
                    Annotation arg1 = relation.getArg1().getArgument();
                    Annotation arg2 = relation.getArg2().getArgument();
                    if (arg1 instanceof TimeMention && arg2 instanceof EventMention) {
                        if (arg1 != admissionTime) continue;
                        dischargeTimeRelationLookup.put(Arrays.asList(arg1, arg2), relation);
                        continue;
                    }
                    if (!(arg1 instanceof EventMention) || !(arg2 instanceof TimeMention) || arg2 != admissionTime) continue;
                    dischargeTimeRelationLookup.put(Arrays.asList(arg1, arg2), relation);
                }
            }
            Map coveringMap = JCasUtil.indexCovering((JCas)jCas, EventMention.class, EventMention.class);
            for (EventMention eventMention : JCasUtil.select((JCas)jCas, EventMention.class)) {
                if (!eventMention.getClass().equals(EventMention.class) || EventAdmissionTimeAnnotator.isDischarge(eventMention) || EventAdmissionTimeAnnotator.isAdmission(eventMention) || EventAdmissionTimeAnnotator.inCourseSection(eventMention, courses)) continue;
                List<Feature> features = this.extractFeatures(jCas, eventMention);
                if (this.isTraining()) {
                    TemporalTextRelation relation = (TemporalTextRelation)dischargeTimeRelationLookup.get(Arrays.asList(eventMention, admissionTime));
                    String category = null;
                    if (relation != null) {
                        category = relation.getCategory();
                    } else {
                        relation = (TemporalTextRelation)dischargeTimeRelationLookup.get(Arrays.asList(admissionTime, eventMention));
                        if (relation != null) {
                            if (relation.getCategory().equals("OVERLAP")) {
                                category = relation.getCategory();
                            } else if (relation.getCategory().equals("BEFORE")) {
                                category = "AFTER";
                            } else if (relation.getCategory().equals("AFTER")) {
                                category = "BEFORE";
                            }
                        }
                    }
                    if (category == null) continue;
                    this.dataWriter.write(new Instance((Object)category, features));
                    continue;
                }
                String outcome = (String)this.classifier.classify(features);
                if (outcome != null) {
                    RelationArgument relArg1 = new RelationArgument(jCas);
                    relArg1.setArgument((Annotation)eventMention);
                    relArg1.setRole("Argument");
                    relArg1.addToIndexes();
                    RelationArgument relArg2 = new RelationArgument(jCas);
                    relArg2.setArgument((Annotation)admissionTime);
                    relArg2.setRole("Related_to");
                    relArg2.addToIndexes();
                    TemporalTextRelation relation = new TemporalTextRelation(jCas);
                    relation.setArg1(relArg1);
                    relation.setArg2(relArg2);
                    relation.setCategory(outcome);
                    relation.addToIndexes();
                    continue;
                }
                System.out.println("cannot classify " + eventMention.getCoveredText() + " and " + admissionTime.getCoveredText());
            }
        }
    }

    private static boolean inCourseSection(EventMention event, List<Segment> courses) {
        for (Segment course : courses) {
            if (course.getBegin() > event.getBegin() || course.getEnd() < event.getEnd()) continue;
            return true;
        }
        return false;
    }

    private static boolean isAdmission(EventMention event) {
        return event.getEnd() <= 15 && event.getCoveredText().equalsIgnoreCase("admission");
    }

    private static boolean isDischarge(EventMention event) {
        return event.getEnd() <= 40 && event.getCoveredText().equalsIgnoreCase("discharge");
    }

    private List<Feature> extractFeatures(JCas jCas, EventMention eventMention) throws CleartkExtractorException {
        List features = this.contextExtractor.extract(jCas, (Annotation)eventMention);
        features.addAll(this.verbTensePatternExtractor.extract(jCas, (Annotation)eventMention));
        features.addAll(this.eventPositionExtractor.extract(jCas, (Annotation)eventMention));
        features.addAll(this.closestVerbExtractor.extract(jCas, (Annotation)eventMention));
        features.addAll(this.timeXExtractor.extract(jCas, (Annotation)eventMention));
        features.addAll(this.genericExtractor.extract(jCas, (Annotation)eventMention));
        features.addAll(this.dateExtractor.extract(jCas, (Annotation)eventMention));
        features.addAll(this.umlsExtractor.extract(jCas, (Annotation)eventMention));
        return features;
    }
}

