/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.relationextractor.ae.features.PartOfSpeechFeaturesExtractor;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.temporal.ae.TemporalRelationExtractorAnnotator;
import org.apache.ctakes.temporal.ae.feature.DependencyPathFeaturesExtractor;
import org.apache.ctakes.temporal.ae.feature.EventArgumentPropertyExtractor;
import org.apache.ctakes.temporal.ae.feature.OverlappedHeadFeaturesExtractor;
import org.apache.ctakes.temporal.ae.feature.RelationSyntacticETEmbeddingFeatureExtractor;
import org.apache.ctakes.temporal.ae.feature.UmlsFeatureExtractor;
import org.apache.ctakes.temporal.ae.feature.UnexpandedTokenFeaturesExtractor;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.DataWriter;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;

@PipeBitInfo(name="E-E TLinker", description="Creates Event - Event TLinks.", dependencies={PipeBitInfo.TypeProduct.SECTION, PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.EVENT}, products={PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
public class EventEventRelationAnnotator
extends TemporalRelationExtractorAnnotator {
    private RelationSyntacticETEmbeddingFeatureExtractor embedingExtractor;

    public static AnalysisEngineDescription createDataWriterDescription(Class<? extends DataWriter<String>> dataWriterClass, File outputDirectory, double probabilityOfKeepingANegativeExample) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(EventEventRelationAnnotator.class, (Object[])new Object[]{"isTraining", true, "dataWriterClassName", dataWriterClass, "outputDirectory", outputDirectory, "ProbabilityOfKeepingANegativeExample", Float.valueOf((float)probabilityOfKeepingANegativeExample)});
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String modelPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(EventEventRelationAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", modelPath});
    }

    public static AnalysisEngineDescription createAnnotatorDescription(File modelDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(EventEventRelationAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", new File(modelDirectory, "model.jar")});
    }

    @Override
    protected List<RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation>> getFeatureExtractors() {
        String vectorFile = "org/apache/ctakes/temporal/gloveresult_3";
        try {
            this.embedingExtractor = new RelationSyntacticETEmbeddingFeatureExtractor("org/apache/ctakes/temporal/gloveresult_3");
        }
        catch (CleartkExtractorException e) {
            System.err.println("cannot find file: org/apache/ctakes/temporal/gloveresult_3");
            e.printStackTrace();
        }
        return Lists.newArrayList((Object[])new RelationFeaturesExtractor[]{new UnexpandedTokenFeaturesExtractor(), this.embedingExtractor, new PartOfSpeechFeaturesExtractor(), new EventArgumentPropertyExtractor(), new UmlsFeatureExtractor(), new DependencyPathFeaturesExtractor(), new OverlappedHeadFeaturesExtractor()});
    }

    @Override
    protected Class<? extends Annotation> getCoveringClass() {
        return Sentence.class;
    }

    @Override
    protected List<TemporalRelationExtractorAnnotator.IdentifiedAnnotationPair> getCandidateRelationArgumentPairs(JCas jCas, Annotation sentence) {
        ArrayList pairs = Lists.newArrayList();
        ArrayList events = new ArrayList(JCasUtil.selectCovered((JCas)jCas, EventMention.class, (AnnotationFS)sentence));
        ArrayList realEvents = Lists.newArrayList();
        for (EventMention event : events) {
            if (!event.getClass().equals(EventMention.class)) continue;
            realEvents.add(event);
        }
        events = realEvents;
        int eventNum = events.size();
        for (int i = 0; i < eventNum - 1; ++i) {
            for (int j = i + 1; j < eventNum; ++j) {
                EventMention eventA = (EventMention)events.get(i);
                EventMention eventB = (EventMention)events.get(j);
                boolean eventAMedical = false;
                for (EventMention aEve : JCasUtil.selectCovering((JCas)jCas, EventMention.class, (AnnotationFS)eventA)) {
                    if (aEve.getClass().equals(EventMention.class)) continue;
                    eventAMedical = true;
                    break;
                }
                boolean eventBMedical = false;
                for (EventMention bEve : JCasUtil.selectCovering((JCas)jCas, EventMention.class, (AnnotationFS)eventB)) {
                    if (bEve.getClass().equals(EventMention.class)) continue;
                    eventBMedical = true;
                    break;
                }
                pairs.add(new TemporalRelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)eventA, (IdentifiedAnnotation)eventB));
            }
        }
        return pairs;
    }

    private static boolean noAdditionalEventsInBetween(JCas jCas, EventMention eventA, EventMention eventB) {
        ArrayList events = new ArrayList(JCasUtil.selectBetween((JCas)jCas, EventMention.class, (AnnotationFS)eventA, (AnnotationFS)eventB));
        ArrayList realEvents = Lists.newArrayList();
        for (EventMention event : events) {
            if (!event.getClass().equals(EventMention.class)) continue;
            realEvents.add(event);
        }
        events = realEvents;
        return events == null || events.size() == 0;
    }

    private static boolean hasOverlap(Annotation event1, Annotation event2) {
        if (event1.getEnd() >= event2.getBegin() && event1.getEnd() <= event2.getEnd()) {
            return true;
        }
        return event2.getEnd() >= event1.getBegin() && event2.getEnd() <= event1.getEnd();
    }

    @Override
    protected void createRelation(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2, String predictedCategory, double confidence) {
        RelationArgument relArg1 = new RelationArgument(jCas);
        relArg1.setArgument((Annotation)arg1);
        relArg1.setRole("Arg1");
        relArg1.addToIndexes();
        RelationArgument relArg2 = new RelationArgument(jCas);
        relArg2.setArgument((Annotation)arg2);
        relArg2.setRole("Arg2");
        relArg2.addToIndexes();
        TemporalTextRelation relation = new TemporalTextRelation(jCas);
        relation.setArg1(relArg1);
        relation.setArg2(relArg2);
        relation.setCategory(predictedCategory);
        relation.setConfidence(confidence);
        relation.addToIndexes();
    }

    @Override
    protected String getRelationCategory(Map<List<Annotation>, BinaryTextRelation> relationLookup, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) {
        BinaryTextRelation relation = relationLookup.get(Arrays.asList(arg1, arg2));
        String category = null;
        if (relation != null && relation instanceof TemporalTextRelation) {
            category = relation.getCategory();
        } else {
            relation = relationLookup.get(Arrays.asList(arg2, arg1));
            if (relation != null && relation instanceof TemporalTextRelation) {
                category = relation.getCategory().equals("OVERLAP") ? relation.getCategory() : relation.getCategory() + "-1";
            }
        }
        if (category == null && this.coin.nextDouble() <= this.probabilityOfKeepingANegativeExample) {
            category = "-NONE-";
        }
        return category;
    }
}

