/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.relationextractor.ae.RelationExtractorAnnotator;
import org.apache.ctakes.relationextractor.ae.features.PartOfSpeechFeaturesExtractor;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.temporal.ae.feature.DependencyPathFeaturesExtractor;
import org.apache.ctakes.temporal.ae.feature.EventArgumentPropertyExtractor;
import org.apache.ctakes.temporal.ae.feature.OverlappedHeadFeaturesExtractor;
import org.apache.ctakes.temporal.ae.feature.UmlsFeatureExtractor;
import org.apache.ctakes.temporal.ae.feature.UnexpandedTokenFeaturesExtractor;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.DataWriter;

@PipeBitInfo(name="E-E Gold TLinker", description="Creates Event - Event TLinks from the Gold View.", dependencies={PipeBitInfo.TypeProduct.SECTION, PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.EVENT}, products={PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
public class EventEventRelationGoldContainerAnnotator
extends RelationExtractorAnnotator {
    public static AnalysisEngineDescription createDataWriterDescription(Class<? extends DataWriter<String>> dataWriterClass, File outputDirectory, double probabilityOfKeepingANegativeExample) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(EventEventRelationGoldContainerAnnotator.class, (Object[])new Object[]{"isTraining", true, "dataWriterClassName", dataWriterClass, "outputDirectory", outputDirectory, "ProbabilityOfKeepingANegativeExample", Float.valueOf((float)probabilityOfKeepingANegativeExample)});
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String modelPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(EventEventRelationGoldContainerAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", modelPath});
    }

    public static AnalysisEngineDescription createAnnotatorDescription(File modelDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(EventEventRelationGoldContainerAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", new File(modelDirectory, "model.jar")});
    }

    protected List<RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation>> getFeatureExtractors() {
        return Lists.newArrayList((Object[])new RelationFeaturesExtractor[]{new UnexpandedTokenFeaturesExtractor(), new PartOfSpeechFeaturesExtractor(), new EventArgumentPropertyExtractor(), new UmlsFeatureExtractor(), new DependencyPathFeaturesExtractor(), new OverlappedHeadFeaturesExtractor()});
    }

    protected Class<? extends Annotation> getCoveringClass() {
        return Sentence.class;
    }

    protected List<RelationExtractorAnnotator.IdentifiedAnnotationPair> getCandidateRelationArgumentPairs(JCas jCas, Annotation sentence) {
        JCas goldView = null;
        try {
            goldView = jCas.getView("GoldView");
        }
        catch (CASException e) {
            new AnalysisEngineProcessException((Throwable)e).printStackTrace();
        }
        ArrayList pairs = Lists.newArrayList();
        ArrayList events = new ArrayList(JCasUtil.selectCovered((JCas)jCas, EventMention.class, (AnnotationFS)sentence));
        ArrayList realEvents = Lists.newArrayList();
        for (EventMention event : events) {
            if (!event.getClass().equals(EventMention.class)) continue;
            realEvents.add(event);
        }
        events = realEvents;
        int eventNum = events.size();
        if (eventNum == 0) {
            return pairs;
        }
        HashSet<EventMention> containers = new HashSet<EventMention>();
        for (TemporalTextRelation relation : JCasUtil.select((JCas)goldView, TemporalTextRelation.class)) {
            EventMention container;
            Annotation arg1 = relation.getArg1().getArgument();
            Annotation arg2 = relation.getArg2().getArgument();
            String type = relation.getCategory();
            if (!EventEventRelationGoldContainerAnnotator.withinSentence(arg1, sentence) || !EventEventRelationGoldContainerAnnotator.withinSentence(arg2, sentence) || !(arg1 instanceof EventMention) || !(arg2 instanceof EventMention)) continue;
            if (type.equals("CONTAINS")) {
                container = EventEventRelationGoldContainerAnnotator.findEvent(arg1, events);
                if (container == null) continue;
                containers.add(container);
                events.remove(container);
                continue;
            }
            if (!type.equals("CONTAINS-1") || (container = EventEventRelationGoldContainerAnnotator.findEvent(arg2, events)) == null) continue;
            containers.add(container);
            events.remove(container);
        }
        int containerNum = containers.size();
        if (containerNum == 0) {
            return pairs;
        }
        for (EventMention currentEvent : events) {
            if (containerNum == 1) {
                for (EventMention container : containers) {
                    pairs.add(new RelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)container, (IdentifiedAnnotation)currentEvent));
                }
                continue;
            }
            for (EventMention container : containers) {
                boolean noContainerInBetween = true;
                for (EventMention inbetweenPotentialContainer : JCasUtil.selectBetween((JCas)jCas, EventMention.class, (AnnotationFS)container, (AnnotationFS)currentEvent)) {
                    if (!containers.contains(inbetweenPotentialContainer)) continue;
                    noContainerInBetween = false;
                    break;
                }
                if (!noContainerInBetween) continue;
                pairs.add(new RelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)container, (IdentifiedAnnotation)currentEvent));
            }
        }
        return pairs;
    }

    private static EventMention findEvent(Annotation arg, List<EventMention> events) {
        for (EventMention event : events) {
            if (arg.getBegin() != event.getBegin() || arg.getEnd() != event.getEnd()) continue;
            return event;
        }
        return null;
    }

    private static boolean withinSentence(Annotation arg, Annotation sentence) {
        return arg.getBegin() >= sentence.getBegin() && arg.getEnd() <= sentence.getEnd();
    }

    protected void createRelation(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2, String predictedCategory) {
        RelationArgument relArg1 = new RelationArgument(jCas);
        relArg1.setArgument((Annotation)arg1);
        relArg1.setRole("Arg1");
        relArg1.addToIndexes();
        RelationArgument relArg2 = new RelationArgument(jCas);
        relArg2.setArgument((Annotation)arg2);
        relArg2.setRole("Arg2");
        relArg2.addToIndexes();
        TemporalTextRelation relation = new TemporalTextRelation(jCas);
        relation.setArg1(relArg1);
        relation.setArg2(relArg2);
        relation.setCategory(predictedCategory);
        relation.addToIndexes();
    }

    protected String getRelationCategory(Map<List<Annotation>, BinaryTextRelation> relationLookup, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) {
        BinaryTextRelation relation = relationLookup.get(Arrays.asList(arg1, arg2));
        String category = null;
        if (relation != null && relation instanceof TemporalTextRelation) {
            category = relation.getCategory();
        } else {
            relation = relationLookup.get(Arrays.asList(arg2, arg1));
            if (relation != null && relation instanceof TemporalTextRelation) {
                category = relation.getCategory().equals("OVERLAP") ? relation.getCategory() : relation.getCategory() + "-1";
            }
        }
        if (category == null && this.coin.nextDouble() <= this.probabilityOfKeepingANegativeExample) {
            category = "-NONE-";
        }
        return category;
    }
}

