/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.core.util.ListFactory;
import org.apache.ctakes.temporal.ae.THYMEAnaforaXMLReader;
import org.apache.ctakes.typesystem.type.refsem.Event;
import org.apache.ctakes.typesystem.type.refsem.EventProperties;
import org.apache.ctakes.typesystem.type.relation.AspectualTextRelation;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.CollectionTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.util.ViewUriUtil;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class THYMEQAAnaforaXMLReader
extends THYMEAnaforaXMLReader {
    private static Logger LOGGER = Logger.getLogger(THYMEQAAnaforaXMLReader.class);

    public static AnalysisEngineDescription getDescription(File anaforaDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(THYMEQAAnaforaXMLReader.class, (Object[])new Object[]{"anaforaSuffixes", new String[]{".THYME_QA.timi4508.completed.xml", ".THYME_QA.gusa3085.completed.xml", ".THYME_QA.bethard.completed.xml", ".THYME_QA.dligach.completed.xml"}, "anaforaDirectory", anaforaDirectory});
    }

    @Override
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        File textFile = new File(ViewUriUtil.getURI((JCas)jCas));
        LOGGER.info((Object)("processing " + textFile));
        File corefFile = new File(textFile.getPath() + ".Coreference.gold.completed.xml");
        ArrayList possibleXMLFiles = Lists.newArrayList();
        for (String anaforaXMLSuffix : this.anaforaXMLSuffixes) {
            if (this.anaforaDirectory == null) {
                possibleXMLFiles.add(new File(textFile + anaforaXMLSuffix));
                continue;
            }
            possibleXMLFiles.add(new File(textFile.getPath() + anaforaXMLSuffix));
        }
        File xmlFile = null;
        for (File possibleXMLFile : possibleXMLFiles) {
            if (!possibleXMLFile.exists()) continue;
            xmlFile = possibleXMLFile;
            break;
        }
        if (this.anaforaXMLSuffixes.length > 0 && xmlFile == null) {
            throw new IllegalArgumentException("no Anafora XML file found from " + possibleXMLFiles);
        }
        if (xmlFile != null) {
            THYMEQAAnaforaXMLReader.processXmlFile(jCas, xmlFile);
        }
        if (corefFile.exists()) {
            THYMEQAAnaforaXMLReader.processXmlFile(jCas, corefFile);
        }
    }

    private static void processXmlFile(JCas jCas, File xmlFile) throws AnalysisEngineProcessException {
        Element dataElem;
        try {
            dataElem = new SAXBuilder().build(xmlFile.toURI().toURL()).getRootElement();
        }
        catch (MalformedURLException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (JDOMException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        int curEventId = 1;
        int curTimexId = 1;
        int curRelId = 1;
        int docLen = jCas.getDocumentText().length();
        HashMap questionRelations = Maps.newHashMap();
        for (Element annotationsElem : dataElem.getChildren("annotations")) {
            String id;
            HashMap idToAnnotation = Maps.newHashMap();
            for (Element entityElem : annotationsElem.getChildren("entity")) {
                TimeMention annotation;
                id = THYMEQAAnaforaXMLReader.removeSingleChildText(entityElem, "id", null);
                Element spanElem = THYMEQAAnaforaXMLReader.removeSingleChild(entityElem, "span", id);
                String type = THYMEQAAnaforaXMLReader.removeSingleChildText(entityElem, "type", id);
                Element propertiesElem = THYMEQAAnaforaXMLReader.removeSingleChild(entityElem, "properties", id);
                int begin = Integer.MAX_VALUE;
                int end = Integer.MIN_VALUE;
                for (String spanString : spanElem.getText().split(";")) {
                    String[] beginEndStrings = spanString.split(",");
                    if (beginEndStrings.length != 2) {
                        THYMEQAAnaforaXMLReader.error("span not of the format 'number,number'", id);
                    }
                    int spanBegin = Integer.parseInt(beginEndStrings[0]);
                    int spanEnd = Integer.parseInt(beginEndStrings[1]);
                    if (spanBegin < begin) {
                        begin = spanBegin;
                    }
                    if (spanEnd <= end) continue;
                    end = spanEnd;
                }
                if (begin < 0 || end >= docLen) {
                    THYMEQAAnaforaXMLReader.error("Illegal begin or end boundary", id);
                    continue;
                }
                if (type.equals("EVENT")) {
                    String docTimeRel = THYMEQAAnaforaXMLReader.removeSingleChildText(propertiesElem, "DocTimeRel", id);
                    if (docTimeRel == null) {
                        THYMEQAAnaforaXMLReader.error("no docTimeRel, assuming OVERLAP", id);
                        docTimeRel = "OVERLAP";
                    }
                    String polarity = THYMEQAAnaforaXMLReader.removeSingleChildText(propertiesElem, "Polarity", id);
                    EventMention eventMention = new EventMention(jCas, begin, end);
                    Event event = new Event(jCas);
                    EventProperties eventProperties = new EventProperties(jCas);
                    eventProperties.setDocTimeRel(docTimeRel);
                    if (polarity.equals("POS")) {
                        eventProperties.setPolarity(1);
                    } else if (polarity.equals("NEG")) {
                        eventProperties.setPolarity(-1);
                    } else {
                        THYMEQAAnaforaXMLReader.error("polarity that was not POS or NEG", id);
                    }
                    eventProperties.addToIndexes();
                    event.setConfidence(1.0);
                    event.setDiscoveryTechnique(2);
                    event.setProperties(eventProperties);
                    event.setMentions(new FSArray(jCas, 1));
                    event.setMentions(0, (IdentifiedAnnotation)eventMention);
                    event.addToIndexes();
                    eventMention.setId(curEventId++);
                    eventMention.setConfidence(1.0f);
                    eventMention.setDiscoveryTechnique(2);
                    eventMention.setEvent(event);
                    eventMention.addToIndexes();
                    annotation = eventMention;
                } else if (type.equals("TIMEX3")) {
                    String timeClass = THYMEQAAnaforaXMLReader.removeSingleChildText(propertiesElem, "Class", id);
                    TimeMention timeMention = new TimeMention(jCas, begin, end);
                    timeMention.setId(curTimexId++);
                    timeMention.setTimeClass(timeClass);
                    timeMention.addToIndexes();
                    annotation = timeMention;
                } else {
                    throw new UnsupportedOperationException("unsupported entity type: " + type);
                }
                idToAnnotation.put(id, annotation);
                THYMEQAAnaforaXMLReader.removeSingleChild(entityElem, "parentsType", id);
                if (propertiesElem.getChildren().isEmpty() && entityElem.getChildren().isEmpty()) continue;
                ArrayList children = Lists.newArrayList();
                for (Element child : propertiesElem.getChildren()) {
                    children.add(child.getName());
                }
                for (Element child : entityElem.getChildren()) {
                    children.add(child.getName());
                }
                THYMEQAAnaforaXMLReader.error("unprocessed children " + children, id);
            }
            for (Element relationElem : annotationsElem.getChildren("relation")) {
                TemporalTextRelation relation;
                String targetID;
                String sourceID;
                id = THYMEQAAnaforaXMLReader.removeSingleChildText(relationElem, "id", null);
                String type = THYMEQAAnaforaXMLReader.removeSingleChildText(relationElem, "type", id);
                Element propertiesElem = THYMEQAAnaforaXMLReader.removeSingleChild(relationElem, "properties", id);
                if (type.equals("TLINK")) {
                    sourceID = THYMEQAAnaforaXMLReader.removeSingleChildText(propertiesElem, "Source", id);
                    targetID = THYMEQAAnaforaXMLReader.removeSingleChildText(propertiesElem, "Target", id);
                    String tlinkType = THYMEQAAnaforaXMLReader.removeSingleChildText(propertiesElem, "Type", id);
                    relation = new TemporalTextRelation(jCas);
                    relation.setId(curRelId++);
                    THYMEQAAnaforaXMLReader.addRelation(jCas, (BinaryTextRelation)relation, sourceID, targetID, tlinkType, idToAnnotation, id);
                } else if (type.equals("ALINK")) {
                    sourceID = THYMEQAAnaforaXMLReader.removeSingleChildText(propertiesElem, "Source", id);
                    targetID = THYMEQAAnaforaXMLReader.removeSingleChildText(propertiesElem, "Target", id);
                    String alinkType = THYMEQAAnaforaXMLReader.removeSingleChildText(propertiesElem, "Type", id);
                    relation = new AspectualTextRelation(jCas);
                    THYMEQAAnaforaXMLReader.addRelation(jCas, (BinaryTextRelation)relation, sourceID, targetID, alinkType, idToAnnotation, id);
                } else if (type.equals("Question")) {
                    String questionText = THYMEQAAnaforaXMLReader.removeSingleChildText(propertiesElem, "Question", id);
                    Iterator confidence = THYMEQAAnaforaXMLReader.removeSingleChildText(propertiesElem, "Confidence", id);
                    String difficulty = THYMEQAAnaforaXMLReader.removeSingleChildText(propertiesElem, "Difficulty", id);
                    String questionDescription = questionText + " - Confidence: " + (String)((Object)confidence) + " - Difficulty: " + difficulty;
                    List answers = propertiesElem.getChildren("Answer");
                    ArrayList<String> ids = new ArrayList<String>();
                    for (Element answer : answers) {
                        ids.add(answer.getText());
                    }
                    propertiesElem.removeChildren("Answer");
                    questionRelations.put(questionDescription, ids);
                } else {
                    throw new UnsupportedOperationException("unsupported relation type: " + type);
                }
                THYMEQAAnaforaXMLReader.removeSingleChild(relationElem, "parentsType", id);
                if (propertiesElem.getChildren().isEmpty() && relationElem.getChildren().isEmpty()) continue;
                ArrayList children = Lists.newArrayList();
                for (Element child : propertiesElem.getChildren()) {
                    children.add(child.getName());
                }
                for (Element child : relationElem.getChildren()) {
                    children.add(child.getName());
                }
                THYMEQAAnaforaXMLReader.error("unprocessed children " + children, id);
            }
            for (String question : questionRelations.keySet()) {
                CollectionTextRelation qaRel = new CollectionTextRelation(jCas);
                qaRel.setCategory(question);
                ArrayList<TOP> answerList = new ArrayList<TOP>();
                for (String id2 : (List)questionRelations.get(question)) {
                    TOP answer = (TOP)idToAnnotation.get(id2);
                    answerList.add(answer);
                }
                qaRel.setMembers(ListFactory.buildList((JCas)jCas, answerList));
                qaRel.addToIndexes();
            }
        }
    }

    private static Element getSingleChild(Element elem, String elemName, String causeID) {
        List children = elem.getChildren(elemName);
        if (children.size() != 1) {
            THYMEQAAnaforaXMLReader.error(String.format("not exactly one '%s' child", elemName), causeID);
        }
        return children.size() > 0 ? (Element)children.get(0) : null;
    }

    private static Element removeSingleChild(Element elem, String elemName, String causeID) {
        Element child = THYMEQAAnaforaXMLReader.getSingleChild(elem, elemName, causeID);
        elem.removeChildren(elemName);
        return child;
    }

    private static String removeSingleChildText(Element elem, String elemName, String causeID) {
        Element child = THYMEQAAnaforaXMLReader.getSingleChild(elem, elemName, causeID);
        String text = child.getText();
        if (text.isEmpty()) {
            THYMEQAAnaforaXMLReader.error(String.format("an empty '%s' child", elemName), causeID);
            text = null;
        }
        elem.removeChildren(elemName);
        return text;
    }

    private static void addRelation(JCas jCas, BinaryTextRelation relation, String sourceID, String targetID, String category, Map<String, Annotation> idToAnnotation, String causeID) {
        if (sourceID != null && targetID != null) {
            Annotation source = THYMEQAAnaforaXMLReader.getArgument(sourceID, idToAnnotation, causeID);
            Annotation target = THYMEQAAnaforaXMLReader.getArgument(targetID, idToAnnotation, causeID);
            if (source != null && target != null) {
                RelationArgument sourceArg = new RelationArgument(jCas);
                sourceArg.setArgument(source);
                sourceArg.addToIndexes();
                RelationArgument targetArg = new RelationArgument(jCas);
                targetArg.setArgument(target);
                targetArg.addToIndexes();
                relation.setCategory(category);
                relation.setArg1(sourceArg);
                relation.setArg2(targetArg);
                relation.addToIndexes();
            }
        }
    }

    private static Annotation getArgument(String id, Map<String, Annotation> idToAnnotation, String causeID) {
        Annotation annotation = idToAnnotation.get(id);
        if (annotation == null) {
            THYMEQAAnaforaXMLReader.error("no annotation with id " + id, causeID);
        }
        return annotation;
    }

    private static void error(String found, String id) {
        LOGGER.error((Object)String.format("found %s in annotation with ID %s", found, id));
    }
}

