/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;

public class ConjunctionRelationFeaturesExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    private String name = "ConjunctionFeature";

    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        int end;
        ArrayList<Feature> feats = new ArrayList<Feature>();
        int begin = arg1.getEnd();
        if (begin > (end = arg2.getBegin())) {
            begin = arg2.getEnd();
            end = arg1.getBegin();
        }
        if (begin >= end) {
            return feats;
        }
        List betweenTokens = JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (int)begin, (int)end);
        ArrayList<EventMention> eventsInBetween = JCasUtil.selectCovered((JCas)jCas, EventMention.class, (int)begin, (int)end);
        ArrayList<EventMention> realEvents = new ArrayList<EventMention>();
        for (EventMention event : eventsInBetween) {
            if (!event.getClass().equals(EventMention.class)) continue;
            realEvents.add(event);
        }
        eventsInBetween = realEvents;
        if (eventsInBetween.size() == 0) {
            for (BaseToken token : betweenTokens) {
                String pos = token.getPartOfSpeech();
                if (pos == null || !pos.startsWith("CC") && !pos.equals(",") && !pos.startsWith("IN")) continue;
                feats.add(new Feature(this.name, (Object)"Contain_Conjunction_inBetween"));
                feats.add(new Feature(this.name, (Object)pos));
            }
        }
        return feats;
    }
}

