/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class EventPositionFeatureExtractor
implements FeatureExtractor1 {
    private String name = "EventPosition";

    public List<Feature> extract(JCas view, Annotation annotation) throws CleartkExtractorException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        Collection sentences = JCasUtil.select((JCas)view, Sentence.class);
        ArrayList sentList = Lists.newArrayList();
        sentList.addAll(sentences);
        int sentSize = sentList.size();
        if (sentSize >= 5) {
            Feature feature;
            if (EventPositionFeatureExtractor.containEvent((Annotation)sentList.get(0), (Annotation)sentList.get(4), annotation)) {
                feature = new Feature(this.name, (Object)"Within_Top_5_sentences");
                features.add(feature);
            }
            if (EventPositionFeatureExtractor.containEvent((Annotation)sentList.get(sentSize - 5), (Annotation)sentList.get(sentSize - 1), annotation)) {
                feature = new Feature(this.name, (Object)"Within_Last_5_sentences");
                features.add(feature);
            }
        }
        Collection events = JCasUtil.select((JCas)view, EventMention.class);
        ArrayList eventList = Lists.newArrayList();
        for (EventMention event : events) {
            if (!event.getClass().equals(EventMention.class)) continue;
            eventList.add(event);
        }
        int eventSize = eventList.size();
        if (eventSize >= 5) {
            Feature feature;
            if (EventPositionFeatureExtractor.containEvent((Annotation)eventList.get(0), (Annotation)eventList.get(4), annotation)) {
                feature = new Feature(this.name, (Object)"Within_Top_5_events");
                features.add(feature);
            }
            if (EventPositionFeatureExtractor.containEvent((Annotation)eventList.get(eventSize - 5), (Annotation)eventList.get(eventSize - 1), annotation)) {
                feature = new Feature(this.name, (Object)"Within_Last_5_events");
                features.add(feature);
            }
        }
        Map coveringMap = JCasUtil.indexCovering((JCas)view, EventMention.class, Segment.class);
        EventMention targetTokenAnnotation = (EventMention)annotation;
        Collection segList = (Collection)coveringMap.get(targetTokenAnnotation);
        for (Segment seg : segList) {
            Feature feature;
            String segname = seg.getId();
            if (segname.equals("SIMPLE_SEGMENT")) continue;
            ArrayList<EventMention> segEvents = JCasUtil.selectCovered((JCas)view, EventMention.class, (AnnotationFS)seg);
            ArrayList<EventMention> realEvents = new ArrayList<EventMention>();
            for (EventMention event : segEvents) {
                if (!event.getClass().equals(EventMention.class)) continue;
                realEvents.add(event);
            }
            segEvents = realEvents;
            int segEventSize = segEvents.size();
            if (segEventSize < 3) continue;
            if (EventPositionFeatureExtractor.containEvent((Annotation)segEvents.get(0), (Annotation)segEvents.get(2), annotation)) {
                feature = new Feature(this.name, (Object)("Within_Top_3_events_of" + segname));
                features.add(feature);
            }
            if (!EventPositionFeatureExtractor.containEvent((Annotation)segEvents.get(segEventSize - 3), (Annotation)segEvents.get(segEventSize - 1), annotation)) continue;
            feature = new Feature(this.name, (Object)("Within_Last_3_events_of" + segname));
            features.add(feature);
        }
        return features;
    }

    private static boolean containEvent(Annotation arg1, Annotation arg2, Annotation target) {
        return target.getBegin() >= arg1.getBegin() && target.getEnd() <= arg2.getEnd();
    }
}

