/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.syntax.PunctuationToken;
import org.apache.ctakes.typesystem.type.syntax.WordToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;

public class NumberOfEventTimeBetweenCandidatesExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        int end;
        ArrayList<Feature> feats = new ArrayList<Feature>();
        int begin = arg1.getEnd();
        if (begin > (end = arg2.getBegin())) {
            begin = arg2.getEnd();
            end = arg1.getBegin();
        }
        if (begin > end) {
            return feats;
        }
        int eventsInBetween = 0;
        int timesInBetween = 0;
        int wordsInBetween = 0;
        int puncsInBetween = 0;
        List events = JCasUtil.selectCovered((JCas)jCas, EventMention.class, (int)begin, (int)end);
        List times = JCasUtil.selectCovered((JCas)jCas, TimeMention.class, (int)begin, (int)end);
        List words = JCasUtil.selectCovered((JCas)jCas, WordToken.class, (int)begin, (int)end);
        List punc = JCasUtil.selectCovered((JCas)jCas, PunctuationToken.class, (int)begin, (int)end);
        eventsInBetween = events == null ? 0 : events.size();
        timesInBetween = times == null ? 0 : times.size();
        int n = wordsInBetween = words == null ? 0 : words.size();
        if (wordsInBetween > 20) {
            wordsInBetween = 20;
        }
        int n2 = puncsInBetween = punc == null ? 0 : punc.size();
        if (puncsInBetween > 5) {
            puncsInBetween = 5;
        }
        feats.add(new Feature("NumOfEvents_InBetween", (Object)eventsInBetween));
        feats.add(new Feature("NumOfTimes_InBetween", (Object)timesInBetween));
        feats.add(new Feature("NumOfEventsAndTimes_InBetween", (Object)(timesInBetween + eventsInBetween)));
        feats.add(new Feature("NumOfWords_InBetween", (Object)wordsInBetween));
        feats.add(new Feature("NumOfPunctuation_InBetween", (Object)puncsInBetween));
        return feats;
    }
}

