/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.FractionAnnotation;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.MeasurementAnnotation;
import org.apache.ctakes.typesystem.type.textsem.RangeAnnotation;
import org.apache.ctakes.typesystem.type.textsem.RomanNumeralAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;

public class SpecialAnnotationRelationExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    public List<Feature> extract(JCas jcas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        EventMention eventA = null;
        EventMention eventB = null;
        if (arg1 instanceof EventMention) {
            eventA = (EventMention)arg1;
        } else if (arg2 instanceof EventMention) {
            eventB = (EventMention)arg2;
        } else {
            return feats;
        }
        Map coveringMap = JCasUtil.indexCovering((JCas)jcas, EventMention.class, Sentence.class);
        Sentence sentenceA = SpecialAnnotationRelationExtractor.getCoveringSentence(eventA, coveringMap);
        Sentence sentenceB = SpecialAnnotationRelationExtractor.getCoveringSentence(eventB, coveringMap);
        ArrayList rangeInA = new ArrayList();
        ArrayList fracInA = new ArrayList();
        ArrayList romanInA = new ArrayList();
        ArrayList measureInA = new ArrayList();
        if (sentenceA != null) {
            rangeInA.addAll(JCasUtil.selectCovered((JCas)jcas, RangeAnnotation.class, (AnnotationFS)sentenceA));
            if (!rangeInA.isEmpty()) {
                feats.add(new Feature("arg1_has_nearby_", (Object)"RangeAnnotation"));
            }
            fracInA.addAll(JCasUtil.selectCovered((JCas)jcas, FractionAnnotation.class, (AnnotationFS)sentenceA));
            if (!fracInA.isEmpty()) {
                feats.add(new Feature("arg1_has_nearby_", (Object)"FractionAnnotation"));
            }
            romanInA.addAll(JCasUtil.selectCovered((JCas)jcas, RomanNumeralAnnotation.class, (AnnotationFS)sentenceA));
            if (!romanInA.isEmpty()) {
                feats.add(new Feature("arg1_has_nearby_", (Object)"RomanNumeralAnnotation"));
            }
            measureInA.addAll(JCasUtil.selectCovered((JCas)jcas, MeasurementAnnotation.class, (AnnotationFS)sentenceA));
            if (!measureInA.isEmpty()) {
                feats.add(new Feature("arg1_has_nearby_", (Object)"MeasurementAnnotation"));
            }
        }
        ArrayList rangeInB = new ArrayList();
        ArrayList fracInB = new ArrayList();
        ArrayList romanInB = new ArrayList();
        ArrayList measureInB = new ArrayList();
        if (sentenceB != null) {
            rangeInB.addAll(JCasUtil.selectCovered((JCas)jcas, RangeAnnotation.class, (AnnotationFS)sentenceB));
            if (!rangeInB.isEmpty()) {
                feats.add(new Feature("arg2_has_nearby_", (Object)"RangeAnnotation"));
            }
            fracInB.addAll(JCasUtil.selectCovered((JCas)jcas, FractionAnnotation.class, (AnnotationFS)sentenceB));
            if (!fracInB.isEmpty()) {
                feats.add(new Feature("arg2_has_nearby_", (Object)"FractionAnnotation"));
            }
            romanInB.addAll(JCasUtil.selectCovered((JCas)jcas, RomanNumeralAnnotation.class, (AnnotationFS)sentenceB));
            if (!romanInB.isEmpty()) {
                feats.add(new Feature("arg2_has_nearby_", (Object)"RomanNumeralAnnotation"));
            }
            measureInB.addAll(JCasUtil.selectCovered((JCas)jcas, MeasurementAnnotation.class, (AnnotationFS)sentenceB));
            if (!measureInB.isEmpty()) {
                feats.add(new Feature("arg2_has_nearby_", (Object)"MeasurementAnnotation"));
            }
        }
        if (sentenceA != null && sentenceB != null && sentenceA != sentenceB) {
            block0: for (RangeAnnotation rangeA : rangeInA) {
                for (RangeAnnotation rangeB : rangeInB) {
                    if (!rangeA.getCoveredText().equalsIgnoreCase(rangeB.getCoveredText())) continue;
                    feats.add(new Feature("shareCommonRange_", (Object)rangeB.getCoveredText().toLowerCase()));
                    break block0;
                }
            }
            block2: for (FractionAnnotation fracA : fracInA) {
                for (FractionAnnotation fracB : fracInB) {
                    if (!fracA.getCoveredText().equalsIgnoreCase(fracB.getCoveredText())) continue;
                    feats.add(new Feature("shareCommonFraction_", (Object)fracB.getCoveredText().toLowerCase()));
                    break block2;
                }
            }
            block4: for (RomanNumeralAnnotation numA : romanInA) {
                for (RomanNumeralAnnotation numB : romanInB) {
                    if (!numA.getCoveredText().equalsIgnoreCase(numB.getCoveredText())) continue;
                    feats.add(new Feature("shareCommonFraction_", (Object)numB.getCoveredText().toLowerCase()));
                    break block4;
                }
            }
            block6: for (MeasurementAnnotation meaA : measureInA) {
                for (MeasurementAnnotation meaB : measureInB) {
                    if (!meaA.getCoveredText().equalsIgnoreCase(meaB.getCoveredText())) continue;
                    feats.add(new Feature("shareCommonFraction_", (Object)meaB.getCoveredText().toLowerCase()));
                    break block6;
                }
            }
        }
        return feats;
    }

    private static Sentence getCoveringSentence(EventMention event, Map<EventMention, Collection<Sentence>> coveringMap) {
        ArrayList<Sentence> sentList = new ArrayList<Sentence>();
        if (event != null) {
            sentList.addAll(coveringMap.get(event));
            if (!sentList.isEmpty()) {
                return (Sentence)sentList.get(0);
            }
        }
        return null;
    }
}

