/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.syntax.WordToken;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;

public class TimeXPropertyRelationFeaturesExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    private String name = "TimeXProperty";

    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        ArrayList features = Lists.newArrayList();
        ArrayList times = Lists.newArrayList();
        if (arg1 instanceof TimeMention) {
            times.add((TimeMention)arg1);
        }
        if (arg2 instanceof TimeMention) {
            times.add((TimeMention)arg2);
        }
        Map coveringMap = JCasUtil.indexCovering((JCas)jCas, TimeMention.class, Sentence.class);
        for (TimeMention time : times) {
            Collection sentList = (Collection)coveringMap.get(time);
            String timeclass = time.getTimeClass();
            if (timeclass != null) {
                features.add(new Feature("TimeClass", (Object)timeclass));
            }
            ArrayList timewords = Lists.newArrayList();
            timewords.addAll(JCasUtil.selectCovered((JCas)jCas, WordToken.class, (AnnotationFS)time));
            if (timewords.size() == 1) {
                features.add(new Feature(this.name, (Object)"one_word"));
            }
            for (Sentence sent : sentList) {
                if (sent.getBegin() == time.getBegin() && time.getEnd() >= sent.getEnd() - 2) {
                    features.add(new Feature(this.name, (Object)"entire_sentence"));
                    continue;
                }
                if (sent.getBegin() == time.getBegin()) {
                    features.add(new Feature(this.name, (Object)"beginning_of_sentence"));
                    continue;
                }
                if (time.getEnd() < sent.getEnd() - 2) continue;
                features.add(new Feature(this.name, (Object)"end_of_sentence"));
            }
        }
        return features;
    }
}

