/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature.duration;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.temporal.duration.Utils;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;

public class DurationEventEventFeatureExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        String arg1text = Utils.normalizeEventText(jCas, (Annotation)arg1);
        String arg2text = Utils.normalizeEventText(jCas, (Annotation)arg2);
        Map textToDistribution = null;
        try {
            textToDistribution = (Map)Files.readLines((File)new File("/Users/dima/Boston/Thyme/Duration/Data/Combined/Distribution/all.txt"), (Charset)Charsets.UTF_8, (LineProcessor)new Utils.Callback());
        }
        catch (IOException e) {
            e.printStackTrace();
            return features;
        }
        Map arg1Distribution = (Map)textToDistribution.get(arg1text);
        if (arg1Distribution == null) {
            features.add(new Feature((Object)"arg1_no_duration_info"));
            return features;
        }
        Float expectedDuration1 = Float.valueOf(Utils.expectedDuration(arg1Distribution));
        Map arg2Distribution = (Map)textToDistribution.get(arg2text);
        if (arg2Distribution == null) {
            features.add(new Feature((Object)"arg2_no_duration_info"));
            return features;
        }
        Float expectedDuration2 = Float.valueOf(Utils.expectedDuration(arg2Distribution));
        features.add(new Feature("expected_duration_difference", (Object)Float.valueOf(expectedDuration1.floatValue() - expectedDuration2.floatValue())));
        return features;
    }
}

