/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature.duration;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.temporal.duration.Utils;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;

public class DurationEventTimeFeatureExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        String eventText = Utils.normalizeEventText(jCas, (Annotation)arg1);
        String timeText = arg2.getCoveredText().toLowerCase();
        File durationLookup = new File("/Users/dima/Boston/Thyme/Duration/Data/Combined/Distribution/all.txt");
        Map textToDistribution = null;
        try {
            textToDistribution = (Map)Files.readLines((File)durationLookup, (Charset)Charsets.UTF_8, (LineProcessor)new Utils.Callback());
        }
        catch (IOException e) {
            e.printStackTrace();
            return features;
        }
        Map eventDistribution = (Map)textToDistribution.get(eventText);
        HashSet<String> timeUnits = Utils.getTimeUnits(timeText);
        String timeUnit = timeUnits.iterator().next();
        float cumulativeProbability = 0.0f;
        for (String bin : Utils.bins) {
            if (bin.equals(timeUnit)) {
                cumulativeProbability += ((Float)eventDistribution.get(bin)).floatValue();
                break;
            }
            cumulativeProbability += ((Float)eventDistribution.get(bin)).floatValue();
        }
        features.add(new Feature("cumulative_probability", (Object)Float.valueOf(cumulativeProbability)));
        return features;
    }
}

