/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.data.analysis;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Ordering;
import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.ctakes.relationextractor.eval.XMIReader;
import org.apache.ctakes.typesystem.type.syntax.TerminalTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

public class EventPrinterPipeline {
    public static void main(String[] args) throws Exception {
        Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        List<File> trainFiles = Arrays.asList(options.getInputDirectory().listFiles());
        CollectionReader collectionReader = EventPrinterPipeline.getCollectionReader(trainFiles);
        AnalysisEngine annotationConsumer = AnalysisEngineFactory.createEngine(EventWriter.class, (Object[])new Object[]{"UmlsSemanticType", options.getUmlsSemanticType(), "EventOutputFile", options.getEventOutputFile()});
        SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngine[])new AnalysisEngine[]{annotationConsumer});
    }

    public static BufferedWriter getWriter(String filePath, boolean append) {
        BufferedWriter bufferedWriter = null;
        try {
            FileWriter fileWriter = new FileWriter(filePath, append);
            bufferedWriter = new BufferedWriter(fileWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bufferedWriter;
    }

    public static CollectionReader getCollectionReader(List<File> inputFiles) throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (File file : inputFiles) {
            if (file.isHidden()) continue;
            fileNames.add(file.getPath());
        }
        String[] paths = new String[fileNames.size()];
        fileNames.toArray(paths);
        return CollectionReaderFactory.createReader(XMIReader.class, (Object[])new Object[]{"files", paths});
    }

    public static String expandToNP(JCas jCas, IdentifiedAnnotation identifiedAnnotation) {
        HashMap<TreebankNode, Integer> treebankNodeSizes = new HashMap<TreebankNode, Integer>();
        for (TreebankNode treebankNode : JCasUtil.selectCovering((JCas)jCas, TreebankNode.class, (int)identifiedAnnotation.getBegin(), (int)identifiedAnnotation.getEnd())) {
            if (treebankNode instanceof TerminalTreebankNode && !treebankNode.getNodeType().startsWith("N")) {
                return identifiedAnnotation.getCoveredText();
            }
            if (!treebankNode.getNodeType().equals("NP")) continue;
            treebankNodeSizes.put(treebankNode, treebankNode.getCoveredText().length());
        }
        ArrayList sortedTreebankNodes = new ArrayList(treebankNodeSizes.keySet());
        Function getValue = Functions.forMap(treebankNodeSizes);
        Collections.sort(sortedTreebankNodes, Ordering.natural().onResultOf(getValue));
        if (sortedTreebankNodes.size() > 0) {
            return ((TreebankNode)sortedTreebankNodes.get(0)).getCoveredText();
        }
        return identifiedAnnotation.getCoveredText();
    }

    public static class EventWriter
    extends JCasAnnotator_ImplBase {
        @ConfigurationParameter(name="EventOutputFile", mandatory=true, description="path to the output file that will store the events")
        private String eventOutputFile;
        @ConfigurationParameter(name="UmlsSemanticType", mandatory=true, description="umls semantic type of interest")
        private int umlsSemanticType;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas systemView;
            JCas goldView;
            try {
                goldView = jCas.getView("GoldView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            try {
                systemView = jCas.getView("_InitialView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            BufferedWriter eventWriter = EventPrinterPipeline.getWriter(this.eventOutputFile, true);
            try {
                for (EventMention eventMention : JCasUtil.select((JCas)goldView, EventMention.class)) {
                    List coveringSystemEventMentions = JCasUtil.selectCovered((JCas)systemView, EventMention.class, (int)eventMention.getBegin(), (int)eventMention.getEnd());
                    for (EventMention systemEventMention : coveringSystemEventMentions) {
                        if (systemEventMention.getTypeID() != this.umlsSemanticType) continue;
                        String output = String.format("%s|%s\n", systemEventMention.getCoveredText().toLowerCase(), EventPrinterPipeline.expandToNP(systemView, (IdentifiedAnnotation)eventMention).toLowerCase());
                        try {
                            eventWriter.write(output);
                        }
                        catch (IOException e) {
                            throw new AnalysisEngineProcessException((Throwable)e);
                        }
                    }
                    continue;
                    return;
                }
            }
            finally {
                try {
                    eventWriter.close();
                }
                catch (IOException e) {
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
            }
        }
    }

    static interface Options {
        @Option(description="specify the path to the directory containing the xmi files")
        public File getInputDirectory();

        @Option(description="specify the UMLS semantic type (e.g. 5, i.e. procedure)")
        public int getUmlsSemanticType();

        @Option(description="specify the path to the output file")
        public File getEventOutputFile();
    }
}

