/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.data.analysis;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.ctakes.temporal.eval.CommandLine;
import org.apache.ctakes.temporal.eval.Evaluation_ImplBase;
import org.apache.ctakes.temporal.eval.THYMEData;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.util.ViewUriUtil;
import org.cleartk.util.ae.UriToDocumentTextAnnotator;
import org.cleartk.util.cr.UriCollectionReader;

public class PrintInconsistentAnnotations {
    public static void main(String[] args) throws Exception {
        Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        int windowSize = 50;
        List<Integer> patientSets = options.getPatients().getList();
        List<Integer> trainItems = THYMEData.getPatientSets(patientSets, THYMEData.TRAIN_REMAINDERS);
        List<File> files = THYMEData.getFilesFor(trainItems, options.getRawTextDirectory());
        CollectionReader reader = UriCollectionReader.getCollectionReaderFromFiles(files);
        AggregateBuilder aggregateBuilder = new AggregateBuilder();
        aggregateBuilder.add(UriToDocumentTextAnnotator.getDescription(), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(Evaluation_ImplBase.XMIReader.class, (Object[])new Object[]{"XMIDirectory", options.getXMIDirectory()}), new String[0]);
        int totalDocTimeRels = 0;
        int totalInconsistentDocTimeRels = 0;
        JCasIterator casIter = new JCasIterator(reader, new AnalysisEngine[]{aggregateBuilder.createAggregate()});
        while (casIter.hasNext()) {
            JCas jCas = (JCas)casIter.next();
            String text = jCas.getDocumentText();
            JCas goldView = jCas.getView("GoldView");
            HashMultimap containers = HashMultimap.create();
            for (TemporalTextRelation relation : JCasUtil.select((JCas)goldView, TemporalTextRelation.class)) {
                if (!relation.getCategory().equals("CONTAINS")) continue;
                Annotation arg1 = relation.getArg1().getArgument();
                Annotation arg2 = relation.getArg2().getArgument();
                if (!(arg2 instanceof EventMention)) continue;
                EventMention event = (EventMention)arg2;
                containers.put((Object)arg1, (Object)event);
            }
            for (Annotation container : containers.keySet()) {
                boolean inconsistentDocTimeRels;
                HashSet docTimeRels = Sets.newHashSet();
                for (EventMention event : containers.get((Object)container)) {
                    docTimeRels.add(event.getEvent().getProperties().getDocTimeRel());
                }
                totalDocTimeRels += docTimeRels.size();
                if (container instanceof EventMention) {
                    EventMention mention = (EventMention)container;
                    String containerDocTimeRel = mention.getEvent().getProperties().getDocTimeRel();
                    inconsistentDocTimeRels = false;
                    for (String docTimeRel : docTimeRels) {
                        if (docTimeRel.equals(containerDocTimeRel) || containerDocTimeRel.equals("BEFORE/OVERLAP") && (docTimeRel.equals("BEFORE") || docTimeRel.equals("OVERLAP"))) continue;
                        inconsistentDocTimeRels = true;
                        break;
                    }
                } else {
                    inconsistentDocTimeRels = docTimeRels.size() == 1 ? false : (docTimeRels.contains("BEFORE/OVERLAP") ? docTimeRels.size() == 1 && (docTimeRels.contains("BEFORE") || docTimeRels.contains("OVERLAP")) : true);
                }
                if (!inconsistentDocTimeRels) continue;
                totalInconsistentDocTimeRels += docTimeRels.size();
                ArrayList offsets = Lists.newArrayList();
                offsets.add(container.getBegin());
                offsets.add(container.getEnd());
                for (EventMention event : containers.get((Object)container)) {
                    offsets.add(event.getBegin());
                    offsets.add(event.getEnd());
                }
                Collections.sort(offsets);
                int begin = Math.max((Integer)offsets.get(0) - windowSize, 0);
                int end = Math.min((Integer)offsets.get(offsets.size() - 1) + windowSize, text.length());
                System.err.printf("Inconsistent DocTimeRels in %s, ...%s...\n", new File(ViewUriUtil.getURI((JCas)jCas)).getName(), text.substring(begin, end).replaceAll("([\r\n])[\r\n]+", "$1"));
                if (container instanceof EventMention) {
                    System.err.printf("Container: \"%s\" (docTimeRel=%s)\n", container.getCoveredText(), ((EventMention)container).getEvent().getProperties().getDocTimeRel());
                } else {
                    System.err.printf("Container: \"%s\"\n", container.getCoveredText());
                }
                Ordering byBegin = Ordering.natural().onResultOf((Function)new Function<EventMention, Integer>(){

                    public Integer apply(@Nullable EventMention event) {
                        return event.getBegin();
                    }
                });
                for (EventMention event : byBegin.sortedCopy((Iterable)containers.get((Object)container))) {
                    System.err.printf("* \"%s\" (docTimeRel=%s)\n", event.getCoveredText(), event.getEvent().getProperties().getDocTimeRel());
                }
                System.err.println();
            }
        }
        System.err.printf("Inconsistent DocTimeRels: %.1f%% (%d/%d)\n", 100.0 * (double)totalInconsistentDocTimeRels / (double)totalDocTimeRels, totalInconsistentDocTimeRels, totalDocTimeRels);
    }

    static interface Options {
        @Option(longName={"xmi"})
        public File getXMIDirectory();

        @Option(longName={"patients"})
        public CommandLine.IntegerRanges getPatients();

        @Option(longName={"text"})
        public File getRawTextDirectory();
    }
}

