/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.eval;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.temporal.ae.DocTimeRelAnnotator;
import org.apache.ctakes.temporal.eval.EvaluationOfEventTimeRelations;
import org.apache.ctakes.temporal.eval.Evaluation_ImplBase;
import org.apache.ctakes.typesystem.type.refsem.Event;
import org.apache.ctakes.typesystem.type.refsem.EventProperties;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.CasCopier;
import org.apache.uima.util.FileUtils;
import org.cleartk.eval.AnnotationStatistics;
import org.cleartk.ml.jar.JarClassifierBuilder;
import org.cleartk.ml.liblinear.LibLinearStringOutcomeDataWriter;
import org.cleartk.ml.tksvmlight.model.CompositeKernel;
import org.cleartk.util.ViewUriUtil;

public class EvaluationOfEventDocTimeRelDeepPhe
extends Evaluation_ImplBase<Map<String, AnnotationStatistics<String>>> {
    protected static boolean DEFAULT_BOTH_DIRECTIONS = false;
    protected static float DEFAULT_DOWNSAMPLE = 1.0f;
    protected static EvaluationOfEventTimeRelations.ParameterSettings allParams = new EvaluationOfEventTimeRelations.ParameterSettings(DEFAULT_BOTH_DIRECTIONS, DEFAULT_DOWNSAMPLE, "tk", 0.05, 1.0, "polynomial", CompositeKernel.ComboOperator.SUM, 0.1, 0.5);
    private static final String DOC_TIME_REL = "docTimeRel";
    private static final int DISCOVERTY_TYPE = 100;
    private EvaluationOfEventTimeRelations.ParameterSettings params;
    protected boolean useClosure;
    protected boolean useGoldAttributes;
    protected boolean skipTrain = false;
    public boolean skipWrite = false;
    protected boolean testOnTrain = false;
    private Map<String, Logger> loggers = Maps.newHashMap();

    public static void main(String[] args) throws Exception {
        TempRelOptions options = (TempRelOptions)CliFactory.parseArguments(TempRelOptions.class, (String[])args);
        List<Integer> trainItems = Arrays.asList(3, 11, 92, 93);
        List<Integer> testItems = Arrays.asList(2, 21);
        EvaluationOfEventTimeRelations.ParameterSettings params = allParams;
        try {
            File workingDir = new File("target/eval/event-properties");
            if (!workingDir.exists()) {
                workingDir.mkdirs();
            }
            if (options.getUseTmp()) {
                File tempModelDir = File.createTempFile("temporal", null, workingDir);
                tempModelDir.delete();
                tempModelDir.mkdir();
                workingDir = tempModelDir;
            }
            EvaluationOfEventDocTimeRelDeepPhe evaluation = new EvaluationOfEventDocTimeRelDeepPhe(workingDir, options.getRawTextDirectory(), options.getXMLDirectory(), options.getXMLFormat(), options.getSubcorpus(), options.getXMIDirectory(), options.getTreebankDirectory(), options.getClosure(), options.getPrintFormattedRelations(), options.getUseGoldAttributes(), params);
            List<Integer> training = trainItems;
            List<Integer> testing = testItems;
            evaluation.logClassificationErrors(workingDir, "deepPhe-event-property-errors");
            evaluation.skipTrain = options.getSkipTrain();
            evaluation.skipWrite = options.getSkipWrite();
            if (!evaluation.skipTrain) {
                evaluation.prepareXMIsFor(training);
            }
            evaluation.prepareXMIsFor(testing);
            Map stats = null;
            evaluation.testOnTrain = options.getTestOnTrain();
            stats = evaluation.testOnTrain ? (Map)evaluation.trainAndTest(trainItems, trainItems) : (Map)evaluation.trainAndTest(trainItems, testItems);
            String name = DOC_TIME_REL;
            System.err.println("====================");
            System.err.println(name);
            System.err.println("--------------------");
            System.err.println(stats.get(name));
            if (options.getUseTmp()) {
                FileUtils.deleteRecursive((File)workingDir);
            }
        }
        catch (ResourceInitializationException e) {
            System.err.println("Error with Initialization");
            e.printStackTrace();
        }
    }

    public EvaluationOfEventDocTimeRelDeepPhe(File baseDirectory, File rawTextDirectory, File xmlDirectory, Evaluation_ImplBase.XMLFormat xmlFormat, Evaluation_ImplBase.Subcorpus subcorpus, File xmiDirectory, File treebankDirectory, boolean useClosure, boolean printErrors, boolean useGoldAttributes, EvaluationOfEventTimeRelations.ParameterSettings params) {
        super(baseDirectory, rawTextDirectory, xmlDirectory, xmlFormat, subcorpus, xmiDirectory, treebankDirectory);
        this.useClosure = useClosure;
        this.printErrors = printErrors;
        this.params = params;
        this.useGoldAttributes = useGoldAttributes;
        this.loggers.put(DOC_TIME_REL, Logger.getLogger(String.format("%s.%s", ((Object)((Object)this)).getClass().getName(), DOC_TIME_REL)));
    }

    protected void train(CollectionReader collectionReader, File directory) throws Exception {
        String[] optArray;
        if (this.skipTrain) {
            return;
        }
        if (!this.skipWrite) {
            AggregateBuilder aggregateBuilder = this.getPreprocessorAggregateBuilder();
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(KeepEventMentionsCoveredByGoldMentions.class, (Object[])new Object[0]), new String[0]);
            aggregateBuilder.add(DocTimeRelAnnotator.createDataWriterDescription(LibLinearStringOutcomeDataWriter.class, new File(directory, DOC_TIME_REL)), new String[0]);
            SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngine[])new AnalysisEngine[]{aggregateBuilder.createAggregate()});
        }
        if (this.kernelParams == null) {
            ArrayList<String> svmOptions = new ArrayList<String>();
            svmOptions.add("-c");
            svmOptions.add("" + this.params.svmCost);
            svmOptions.add("-t");
            svmOptions.add("" + this.params.svmKernelIndex);
            svmOptions.add("-d");
            svmOptions.add("3");
            svmOptions.add("-g");
            svmOptions.add("" + this.params.svmGamma);
            if (this.params.svmKernelIndex == EvaluationOfEventTimeRelations.ParameterSettings.SVM_KERNELS.indexOf("tk")) {
                svmOptions.add("-S");
                svmOptions.add("" + this.params.secondKernelIndex);
                String comboFlag = this.params.comboOperator == CompositeKernel.ComboOperator.SUM ? "+" : (this.params.comboOperator == CompositeKernel.ComboOperator.PRODUCT ? "*" : (this.params.comboOperator == CompositeKernel.ComboOperator.TREE_ONLY ? "T" : "V"));
                svmOptions.add("-C");
                svmOptions.add(comboFlag);
                svmOptions.add("-L");
                svmOptions.add("" + this.params.lambda);
                svmOptions.add("-T");
                svmOptions.add("" + this.params.tkWeight);
                svmOptions.add("-N");
                svmOptions.add("3");
            }
            optArray = svmOptions.toArray(new String[0]);
        } else {
            optArray = this.kernelParams;
            for (int i = 0; i < optArray.length; i += 2) {
                optArray[i] = "-" + optArray[i];
            }
        }
        String[] weightArray = new String[]{"-c", optArray[1], "-s", "7", "-B", "0.25", "-e", "1.0"};
        JarClassifierBuilder.trainAndPackage((File)new File(directory, DOC_TIME_REL), (String[])weightArray);
    }

    protected Map<String, AnnotationStatistics<String>> test(CollectionReader collectionReader, File directory) throws Exception {
        this.useClosure = false;
        AggregateBuilder aggregateBuilder = this.getPreprocessorAggregateBuilder();
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(ReplaceCTakesMentionsWithGoldMentions.class, (Object[])new Object[0]), new String[0]);
        aggregateBuilder.add(DocTimeRelAnnotator.createAnnotatorDescription(new File(directory, DOC_TIME_REL)), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(CopyHeadEventDocTimeRel2GoldEvent.class, (Object[])new Object[0]), new String[0]);
        Function eventMentionToSpan = AnnotationStatistics.annotationToSpan();
        HashMap<String, Function<EventMention, String>> propertyGetters = new HashMap<String, Function<EventMention, String>>();
        propertyGetters.put(DOC_TIME_REL, EvaluationOfEventDocTimeRelDeepPhe.getPropertyGetter(DOC_TIME_REL));
        HashMap<String, AnnotationStatistics<String>> statsMap = new HashMap<String, AnnotationStatistics<String>>();
        statsMap.put(DOC_TIME_REL, new AnnotationStatistics());
        JCasIterator casIter = new JCasIterator(collectionReader, new AnalysisEngine[]{aggregateBuilder.createAggregate()});
        while (casIter.hasNext()) {
            JCas jCas = (JCas)casIter.next();
            JCas goldView = jCas.getView("GoldView");
            JCas systemView = jCas.getView("_InitialView");
            String text = goldView.getDocumentText();
            ArrayList goldEvents = new ArrayList(JCasUtil.select((JCas)goldView, EventMention.class));
            ArrayList systemEvents = new ArrayList(JCasUtil.select((JCas)systemView, EventMention.class));
            String name = DOC_TIME_REL;
            this.loggers.get(name).fine("Errors in : " + ViewUriUtil.getURI((JCas)jCas).toString());
            Function getProperty = (Function)propertyGetters.get(name);
            ((AnnotationStatistics)statsMap.get(name)).add(goldEvents, systemEvents, eventMentionToSpan, getProperty);
            for (int i = 0; i < goldEvents.size(); ++i) {
                String goldOutcome = (String)getProperty.apply(goldEvents.get(i));
                String systemOutcome = (String)getProperty.apply(systemEvents.get(i));
                EventMention event = (EventMention)goldEvents.get(i);
                int begin = event.getBegin();
                int end = event.getEnd();
                int windowBegin = Math.max(0, begin - 100);
                int windowEnd = Math.min(text.length(), end + 100);
                if (!goldOutcome.equals(systemOutcome)) {
                    this.loggers.get(name).fine(String.format("%s was %s but should be %s, in  ...%s[!%s!:%d-%d]%s...", name, systemOutcome, goldOutcome, text.substring(windowBegin, begin).replaceAll("[\r\n]", " "), text.substring(begin, end), begin, end, text.substring(end, windowEnd).replaceAll("[\r\n]", " ")));
                    continue;
                }
                this.loggers.get(name).fine(String.format("%s was correctly labeled as %s, in  ...%s[!%s!:%d-%d]%s...", name, goldOutcome, text.substring(windowBegin, begin).replaceAll("[\r\n]", " "), text.substring(begin, end), begin, end, text.substring(end, windowEnd).replaceAll("[\r\n]", " ")));
            }
        }
        return statsMap;
    }

    public void logClassificationErrors(File outputDir, String outputFilePrefix) throws IOException {
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        String name = DOC_TIME_REL;
        Logger logger = this.loggers.get(name);
        logger.setLevel(Level.FINE);
        File outputFile = new File(outputDir, String.format("%s.%s.log", outputFilePrefix, name));
        FileHandler handler = new FileHandler(outputFile.getPath());
        handler.setFormatter(new Formatter(){

            @Override
            public String format(LogRecord record) {
                return record.getMessage() + '\n';
            }
        });
        logger.addHandler(handler);
    }

    private static Function<EventMention, String> getPropertyGetter(final String propertyName) {
        return new Function<EventMention, String>(){

            public String apply(EventMention eventMention) {
                EventProperties eventProperties = eventMention.getEvent().getProperties();
                Feature feature = eventProperties.getType().getFeatureByBaseName(propertyName);
                return eventProperties.getFeatureValueAsString(feature);
            }
        };
    }

    @PipeBitInfo(name="DocTimeRel to Gold Copier", description="Copies an Event's DocTimeRel from the System view to the Gold view.", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.EVENT})
    public static class CopyHeadEventDocTimeRel2GoldEvent
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas systemView;
            try {
                systemView = jCas.getView("_InitialView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            Map coveredMap = JCasUtil.indexCovered((JCas)jCas, EventMention.class, EventMention.class);
            for (EventMention aEvent : JCasUtil.select((JCas)systemView, EventMention.class)) {
                Iterator iterator;
                if (aEvent.getDiscoveryTechnique() != 100 || !(iterator = ((Collection)coveredMap.get(aEvent)).iterator()).hasNext()) continue;
                EventMention coveredEvent = (EventMention)iterator.next();
                String covDocTimeRel = coveredEvent.getEvent().getProperties().getDocTimeRel();
                aEvent.getEvent().getProperties().setDocTimeRel(covDocTimeRel);
            }
            ArrayList cTakesMentions = new ArrayList();
            cTakesMentions.addAll(JCasUtil.select((JCas)systemView, EventMention.class));
            for (EventMention aEvent : cTakesMentions) {
                if (aEvent.getDiscoveryTechnique() == 100) continue;
                aEvent.removeFromIndexes();
            }
        }
    }

    public static class KeepEventMentionsCoveredByGoldMentions
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas systemView;
            JCas goldView;
            try {
                goldView = jCas.getView("GoldView");
                systemView = jCas.getView("_InitialView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            ArrayList goldMentions = new ArrayList();
            goldMentions.addAll(JCasUtil.select((JCas)goldView, EventMention.class));
            CasCopier copier = new CasCopier(goldView.getCas(), systemView.getCas());
            for (EventMention goldMention : goldMentions) {
                boolean findCoveredSystemEvent = false;
                for (EventMention sysEvent : JCasUtil.selectCovered((JCas)systemView, EventMention.class, (int)goldMention.getBegin(), (int)goldMention.getEnd())) {
                    String goldDocTimeRel = goldMention.getEvent().getProperties().getDocTimeRel();
                    sysEvent.setDiscoveryTechnique(100);
                    findCoveredSystemEvent = true;
                    if (sysEvent.getEvent() == null) {
                        Event event = new Event(systemView);
                        EventProperties props = new EventProperties(systemView);
                        props.setDocTimeRel(goldDocTimeRel);
                        event.setProperties(props);
                        sysEvent.setEvent(event);
                        continue;
                    }
                    sysEvent.getEvent().getProperties().setDocTimeRel(goldDocTimeRel);
                }
                if (findCoveredSystemEvent) continue;
                EventMention copy = (EventMention)copier.copyFs((FeatureStructure)goldMention);
                Feature sofaFeature = copy.getType().getFeatureByBaseName("sofa");
                copy.setFeatureValue(sofaFeature, (FeatureStructure)systemView.getSofa());
                copy.setDiscoveryTechnique(100);
                copy.addToIndexes();
            }
            ArrayList cTakesMentions = new ArrayList();
            cTakesMentions.addAll(JCasUtil.select((JCas)systemView, EventMention.class));
            for (EventMention aEvent : cTakesMentions) {
                if (aEvent.getDiscoveryTechnique() == 100) continue;
                aEvent.removeFromIndexes();
            }
        }
    }

    public static class ReplaceCTakesMentionsWithGoldMentions
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas systemView;
            JCas goldView;
            try {
                goldView = jCas.getView("GoldView");
                systemView = jCas.getView("_InitialView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            ArrayList goldMentions = new ArrayList();
            goldMentions.addAll(JCasUtil.select((JCas)goldView, EventMention.class));
            CasCopier copier = new CasCopier(goldView.getCas(), systemView.getCas());
            for (EventMention goldMention : goldMentions) {
                EventMention copy = (EventMention)copier.copyFs((FeatureStructure)goldMention);
                Feature sofaFeature = copy.getType().getFeatureByBaseName("sofa");
                copy.setFeatureValue(sofaFeature, (FeatureStructure)systemView.getSofa());
                copy.setDiscoveryTechnique(100);
                copy.addToIndexes();
            }
        }
    }

    @PipeBitInfo(name="Event Property Clearer", description="Clears all event properties.", role=PipeBitInfo.Role.SPECIAL)
    public static class ClearEventProperties
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            for (EventProperties eventProperties : JCasUtil.select((JCas)jCas, EventProperties.class)) {
                eventProperties.setAspect(null);
                eventProperties.setCategory(null);
                eventProperties.setContextualAspect(null);
                eventProperties.setContextualModality(null);
                eventProperties.setDegree(null);
                eventProperties.setDocTimeRel(null);
                eventProperties.setPermanence(null);
                eventProperties.setPolarity(0);
            }
        }
    }

    static interface TempRelOptions
    extends Evaluation_ImplBase.Options {
        @Option
        public boolean getPrintFormattedRelations();

        @Option
        public boolean getBaseline();

        @Option
        public boolean getClosure();

        @Option
        public boolean getUseTmp();

        @Option
        public boolean getUseGoldAttributes();

        @Override
        @Option
        public boolean getSkipTrain();

        @Option
        public boolean getSkipWrite();

        @Option
        public boolean getTestOnTrain();
    }
}

