/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.eval;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.ctakes.core.ae.CDASegmentAnnotator;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.relationextractor.eval.RelationExtractorEvaluation;
import org.apache.ctakes.temporal.ae.ConsecutiveSentencesEventEventRelationAnnotator;
import org.apache.ctakes.temporal.ae.ConsecutiveSentencesEventTimeRelationAnnotator;
import org.apache.ctakes.temporal.ae.DocTimeRelAnnotator;
import org.apache.ctakes.temporal.ae.EventAdmissionTimeAnnotator;
import org.apache.ctakes.temporal.ae.EventDischargeTimeAnnotator;
import org.apache.ctakes.temporal.ae.EventEventI2B2RelationAnnotator;
import org.apache.ctakes.temporal.ae.EventTimeI2B2RelationAnnotator;
import org.apache.ctakes.temporal.ae.TemporalRelationRuleAnnotator;
import org.apache.ctakes.temporal.ae.baselines.RecallBaselineEventTimeRelationAnnotator;
import org.apache.ctakes.temporal.eval.EvaluationOfEventEventThymeRelations;
import org.apache.ctakes.temporal.eval.EvaluationOfEventTimeRelations;
import org.apache.ctakes.temporal.eval.EvaluationOfTemporalRelations_ImplBase;
import org.apache.ctakes.temporal.eval.Evaluation_ImplBase;
import org.apache.ctakes.temporal.eval.I2B2Data;
import org.apache.ctakes.temporal.eval.THYMEData;
import org.apache.ctakes.temporal.utils.AnnotationIdCollection;
import org.apache.ctakes.temporal.utils.TLinkTypeArray2;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.FileUtils;
import org.cleartk.eval.AnnotationStatistics;
import org.cleartk.ml.jar.JarClassifierBuilder;
import org.cleartk.ml.libsvm.LibSvmStringOutcomeDataWriter;
import org.cleartk.ml.tksvmlight.model.CompositeKernel;
import org.cleartk.util.ViewUriUtil;

public class EvaluationOfI2B2TemporalRelations
extends EvaluationOfTemporalRelations_ImplBase {
    protected static EvaluationOfEventTimeRelations.ParameterSettings flatParams = new EvaluationOfEventTimeRelations.ParameterSettings(DEFAULT_BOTH_DIRECTIONS, DEFAULT_DOWNSAMPLE, "linear", 10.0, 1.0, "linear", CompositeKernel.ComboOperator.VECTOR_ONLY, DEFAULT_TK, DEFAULT_LAMBDA);
    protected static EvaluationOfEventTimeRelations.ParameterSettings allBagsParams = new EvaluationOfEventTimeRelations.ParameterSettings(DEFAULT_BOTH_DIRECTIONS, DEFAULT_DOWNSAMPLE, "tk", 100.0, 0.1, "radial basis function", CompositeKernel.ComboOperator.SUM, 0.5, 0.5);
    protected static EvaluationOfEventTimeRelations.ParameterSettings allParams = new EvaluationOfEventTimeRelations.ParameterSettings(DEFAULT_BOTH_DIRECTIONS, DEFAULT_DOWNSAMPLE, "tk", 10.0, 1.0, "polynomial", CompositeKernel.ComboOperator.SUM, 0.1, 0.5);
    protected static EvaluationOfEventTimeRelations.ParameterSettings ftParams = new EvaluationOfEventTimeRelations.ParameterSettings(DEFAULT_BOTH_DIRECTIONS, DEFAULT_DOWNSAMPLE, "tk", 1.0, 0.1, "radial basis function", CompositeKernel.ComboOperator.SUM, 0.5, 0.5);
    private static final String EVENT_TIME = "event_time";
    private static final String EVENT_EVENT = "event_event";
    private static final String EVENT_DISCHARGE = "event_dischargeTime";
    private static final String EVENT_ADMISSION = "event_admissionTime";
    private static final String TIME_DISCHARGE = "time_dischargeTime";
    private static final String TIME_ADMISSION = "time_admissionTime";
    private static final String TEMP_CROSSSENT = "temp_crossSentence";
    private static final String TEMPET_CROSSSENT = "eventTime_crossSentence";
    private boolean baseline;
    protected boolean useClosure;
    protected boolean useGoldAttributes;
    protected boolean skipTrain = false;

    public static void main(String[] args) throws Exception {
        TempRelOptions options = (TempRelOptions)CliFactory.parseArguments(TempRelOptions.class, (String[])args);
        List<Integer> trainItems = null;
        List<Integer> devItems = null;
        List<Integer> testItems = null;
        List<Integer> patientSets = options.getPatients().getList();
        if (options.getXMLFormat() == Evaluation_ImplBase.XMLFormat.I2B2) {
            trainItems = I2B2Data.getTrainPatientSets(options.getXMLDirectory());
            devItems = I2B2Data.getDevPatientSets(options.getXMLDirectory());
            testItems = I2B2Data.getTestPatientSets(options.getXMLDirectory());
        } else {
            trainItems = THYMEData.getPatientSets(patientSets, options.getTrainRemainders().getList());
            devItems = THYMEData.getPatientSets(patientSets, options.getDevRemainders().getList());
            testItems = THYMEData.getPatientSets(patientSets, options.getTestRemainders().getList());
        }
        EvaluationOfEventTimeRelations.ParameterSettings params = allParams;
        try {
            File workingDir = new File("target/eval/temporal-relations/");
            if (!workingDir.exists()) {
                workingDir.mkdirs();
            }
            if (options.getUseTmp()) {
                File tempModelDir = File.createTempFile("temporal", null, workingDir);
                tempModelDir.delete();
                tempModelDir.mkdir();
                workingDir = tempModelDir;
            }
            EvaluationOfI2B2TemporalRelations evaluation = new EvaluationOfI2B2TemporalRelations(workingDir, options.getRawTextDirectory(), options.getXMLDirectory(), options.getXMLFormat(), options.getSubcorpus(), options.getXMIDirectory(), options.getTreebankDirectory(), options.getClosure(), options.getPrintErrors(), options.getPrintFormattedRelations(), options.getBaseline(), options.getUseGoldAttributes(), options.getKernelParams(), params);
            evaluation.prepareXMIsFor(patientSets);
            if (options.getI2B2Output() != null) {
                evaluation.setI2B2Output(options.getI2B2Output() + "/temporal-relations/event-time");
            }
            List<Integer> training = trainItems;
            List<Integer> testing = null;
            if (options.getTest()) {
                training.addAll(devItems);
                testing = testItems;
            } else {
                testing = devItems;
            }
            evaluation.skipTrain = options.getSkipTrain();
            params.stats = (AnnotationStatistics)evaluation.trainAndTest(training, testing);
            System.err.println(params.stats);
            if (options.getUseTmp()) {
                FileUtils.deleteRecursive((File)workingDir);
            }
        }
        catch (ResourceInitializationException e) {
            System.err.println("Error with parameter settings: " + params);
            e.printStackTrace();
        }
    }

    public EvaluationOfI2B2TemporalRelations(File baseDirectory, File rawTextDirectory, File xmlDirectory, Evaluation_ImplBase.XMLFormat xmlFormat, Evaluation_ImplBase.Subcorpus subcorpus, File xmiDirectory, File treebankDirectory, boolean useClosure, boolean printErrors, boolean printRelations, boolean baseline, boolean useGoldAttributes, String kernelParams, EvaluationOfEventTimeRelations.ParameterSettings params) {
        super(baseDirectory, rawTextDirectory, xmlDirectory, xmlFormat, subcorpus, xmiDirectory, treebankDirectory, printErrors, printRelations, params);
        this.params = params;
        this.useClosure = useClosure;
        this.printErrors = printErrors;
        this.printRelations = printRelations;
        this.useGoldAttributes = useGoldAttributes;
        this.baseline = baseline;
        this.kernelParams = kernelParams == null ? null : kernelParams.split(" ");
    }

    protected void train(CollectionReader collectionReader, File directory) throws Exception {
        if (this.skipTrain) {
            return;
        }
        AggregateBuilder aggregateBuilder = this.getPreprocessorAggregateBuilder();
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(CDASegmentAnnotator.class, (Object[])new Object[]{"sections_file", "org/apache/ctakes/temporal/ae/section/ccda_sections.txt"}), new String[0]);
        aggregateBuilder.add(Evaluation_ImplBase.CopyFromGold.getDescription(EventMention.class, TimeMention.class, BinaryTextRelation.class), new String[0]);
        aggregateBuilder.add(DocTimeRelAnnotator.createAnnotatorDescription("/org/apache/ctakes/temporal/ae/doctimerel/model.jar"), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(RemoveNullArgumentRelations.class, (Object[])new Object[0]), new String[0]);
        if (!this.useGoldAttributes) {
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EvaluationOfTemporalRelations_ImplBase.RemoveGoldAttributes.class, (Object[])new Object[0]), new String[0]);
        }
        if (this.useClosure) {
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(AddClosure.class, (Object[])new Object[0]), new String[0]);
        }
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EvaluationOfEventTimeRelations.AddPotentialRelations.class, (Object[])new Object[0]), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EvaluationOfEventEventThymeRelations.AddEEPotentialRelations.class, (Object[])new Object[0]), new String[0]);
        aggregateBuilder.add(EventTimeI2B2RelationAnnotator.createDataWriterDescription(LibSvmStringOutcomeDataWriter.class, new File(directory, EVENT_TIME), this.params.probabilityOfKeepingANegativeExample), new String[0]);
        aggregateBuilder.add(EventEventI2B2RelationAnnotator.createDataWriterDescription(LibSvmStringOutcomeDataWriter.class, new File(directory, EVENT_EVENT), this.params.probabilityOfKeepingANegativeExample), new String[0]);
        aggregateBuilder.add(EventDischargeTimeAnnotator.createDataWriterDescription(LibSvmStringOutcomeDataWriter.class, new File(directory, EVENT_DISCHARGE)), new String[0]);
        aggregateBuilder.add(EventAdmissionTimeAnnotator.createDataWriterDescription(LibSvmStringOutcomeDataWriter.class, new File(directory, EVENT_ADMISSION)), new String[0]);
        aggregateBuilder.add(ConsecutiveSentencesEventEventRelationAnnotator.createDataWriterDescription(LibSvmStringOutcomeDataWriter.class, new File(directory, TEMP_CROSSSENT), this.params.probabilityOfKeepingANegativeExample), new String[0]);
        aggregateBuilder.add(ConsecutiveSentencesEventTimeRelationAnnotator.createDataWriterDescription(LibSvmStringOutcomeDataWriter.class, new File(directory, TEMPET_CROSSSENT), this.params.probabilityOfKeepingANegativeExample), new String[0]);
        SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngine[])new AnalysisEngine[]{aggregateBuilder.createAggregate()});
        if (this.kernelParams == null) {
            ArrayList<String> svmOptions = new ArrayList<String>();
            svmOptions.add("-c");
            svmOptions.add("" + this.params.svmCost);
            svmOptions.add("-t");
            svmOptions.add("" + this.params.svmKernelIndex);
            svmOptions.add("-d");
            svmOptions.add("3");
            svmOptions.add("-g");
            svmOptions.add("" + this.params.svmGamma);
            if (this.params.svmKernelIndex == EvaluationOfEventTimeRelations.ParameterSettings.SVM_KERNELS.indexOf("tk")) {
                svmOptions.add("-S");
                svmOptions.add("" + this.params.secondKernelIndex);
                String comboFlag = this.params.comboOperator == CompositeKernel.ComboOperator.SUM ? "+" : (this.params.comboOperator == CompositeKernel.ComboOperator.PRODUCT ? "*" : (this.params.comboOperator == CompositeKernel.ComboOperator.TREE_ONLY ? "T" : "V"));
                svmOptions.add("-C");
                svmOptions.add(comboFlag);
                svmOptions.add("-L");
                svmOptions.add("" + this.params.lambda);
                svmOptions.add("-T");
                svmOptions.add("" + this.params.tkWeight);
                svmOptions.add("-N");
                svmOptions.add("3");
            }
            String[] optArray = svmOptions.toArray(new String[0]);
        } else {
            String[] optArray = this.kernelParams;
            for (int i = 0; i < optArray.length; i += 2) {
                optArray[i] = "-" + optArray[i];
            }
        }
        JarClassifierBuilder.trainAndPackage((File)new File(directory, EVENT_TIME), (String[])new String[]{"-h", "0", "-c", "1000", "-w2", "0.5", "-w3", "5", "-w4", "8"});
        JarClassifierBuilder.trainAndPackage((File)new File(directory, EVENT_EVENT), (String[])new String[]{"-h", "0", "-c", "1000", "-w2", "0.5", "-w3", "4", "-w4", "3"});
        JarClassifierBuilder.trainAndPackage((File)new File(directory, EVENT_DISCHARGE), (String[])new String[]{"-h", "0", "-c", "1000"});
        JarClassifierBuilder.trainAndPackage((File)new File(directory, EVENT_ADMISSION), (String[])new String[]{"-h", "0", "-c", "1000"});
        JarClassifierBuilder.trainAndPackage((File)new File(directory, TEMP_CROSSSENT), (String[])new String[]{"-h", "0", "-c", "1000", "-w2", "3", "-w3", "0.1"});
        JarClassifierBuilder.trainAndPackage((File)new File(directory, TEMPET_CROSSSENT), (String[])new String[]{"-h", "0", "-c", "1000", "-w2", "58", "-w3", "63", "-w4", "75"});
    }

    protected AnnotationStatistics<String> test(CollectionReader collectionReader, File directory) throws Exception {
        AggregateBuilder aggregateBuilder = this.getPreprocessorAggregateBuilder();
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(CDASegmentAnnotator.class, (Object[])new Object[]{"sections_file", "org/apache/ctakes/temporal/ae/section/ccda_sections.txt"}), new String[0]);
        aggregateBuilder.add(Evaluation_ImplBase.CopyFromGold.getDescription(EventMention.class, TimeMention.class), new String[0]);
        aggregateBuilder.add(DocTimeRelAnnotator.createAnnotatorDescription("/org/apache/ctakes/temporal/ae/doctimerel/model.jar"), new String[0]);
        if (this.useClosure) {
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(AddClosure.class, (Object[])new Object[0]), new String[]{"_InitialView", "GoldView"});
        }
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(RemoveRelations.class, (Object[])new Object[0]), new String[0]);
        aggregateBuilder.add(EventAdmissionTimeAnnotator.createAnnotatorDescription(new File(directory, EVENT_ADMISSION)), new String[0]);
        aggregateBuilder.add(EventDischargeTimeAnnotator.createAnnotatorDescription(new File(directory, EVENT_DISCHARGE)), new String[0]);
        aggregateBuilder.add(this.baseline ? RecallBaselineEventTimeRelationAnnotator.createAnnotatorDescription(directory) : EventTimeI2B2RelationAnnotator.createEngineDescription(new File(directory, EVENT_TIME)), new String[0]);
        aggregateBuilder.add(EventEventI2B2RelationAnnotator.createAnnotatorDescription(new File(directory, EVENT_EVENT)), new String[0]);
        aggregateBuilder.add(ConsecutiveSentencesEventEventRelationAnnotator.createAnnotatorDescription(new File(directory, TEMP_CROSSSENT)), new String[0]);
        aggregateBuilder.add(ConsecutiveSentencesEventTimeRelationAnnotator.createAnnotatorDescription(new File(directory, TEMPET_CROSSSENT)), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(TemporalRelationRuleAnnotator.class, (Object[])new Object[0]), new String[0]);
        if (this.i2b2Output != null) {
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(Evaluation_ImplBase.WriteI2B2XML.class, (Object[])new Object[]{"PARAM_OUTPUT_DIR", this.i2b2Output}), new String[]{"TimexView", "_InitialView"});
        }
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(RemoveNullArgumentRelations.class, (Object[])new Object[0]), new String[0]);
        Function<BinaryTextRelation, RelationExtractorEvaluation.HashableArguments> getSpan = new Function<BinaryTextRelation, RelationExtractorEvaluation.HashableArguments>(){

            public RelationExtractorEvaluation.HashableArguments apply(BinaryTextRelation relation) {
                return new RelationExtractorEvaluation.HashableArguments(relation);
            }
        };
        Function getOutcome = AnnotationStatistics.annotationToFeatureValue((String)"category");
        AnnotationStatistics stats = new AnnotationStatistics();
        JCasIterator jcasIter = new JCasIterator(collectionReader, new AnalysisEngine[]{aggregateBuilder.createAggregate()});
        JCas jCas = null;
        while (jcasIter.hasNext()) {
            Object relation4;
            Object relation22;
            jCas = jcasIter.next();
            JCas goldView = jCas.getView("GoldView");
            JCas systemView = jCas.getView("_InitialView");
            ArrayList goldRelations = Lists.newArrayList();
            for (Object relation22 : Lists.newArrayList((Iterable)JCasUtil.select((JCas)goldView, BinaryTextRelation.class))) {
                if (relation22.getArg1().getArgument() == null || relation22.getArg2().getArgument() == null || relation22.getCategory() == null) continue;
                goldRelations.add(relation22);
            }
            ArrayList systemRelations = Lists.newArrayList();
            relation22 = Lists.newArrayList((Iterable)JCasUtil.select((JCas)systemView, BinaryTextRelation.class)).iterator();
            while (relation22.hasNext()) {
                BinaryTextRelation relation3 = (BinaryTextRelation)relation22.next();
                if (relation3.getArg1().getArgument() == null || relation3.getArg2().getArgument() == null || relation3.getCategory() == null) continue;
                systemRelations.add(relation3);
            }
            stats.add((Collection)goldRelations, (Collection)systemRelations, (Function)getSpan, getOutcome);
            if (this.printRelations) {
                URI uri = ViewUriUtil.getURI((JCas)jCas);
                String[] path = uri.getPath().split("/");
                EvaluationOfI2B2TemporalRelations.printRelationAnnotations((String)path[path.length - 1], systemRelations);
            }
            if (!this.printErrors) continue;
            HashMap goldMap = Maps.newHashMap();
            for (Object relation4 : goldRelations) {
                goldMap.put(new RelationExtractorEvaluation.HashableArguments((BinaryTextRelation)relation4), relation4);
            }
            HashMap systemMap = Maps.newHashMap();
            relation4 = systemRelations.iterator();
            while (relation4.hasNext()) {
                BinaryTextRelation relation5 = (BinaryTextRelation)relation4.next();
                systemMap.put(new RelationExtractorEvaluation.HashableArguments(relation5), relation5);
            }
            Sets.SetView all = Sets.union(goldMap.keySet(), systemMap.keySet());
            ArrayList sorted = Lists.newArrayList((Iterable)all);
            Collections.sort(sorted);
            for (RelationExtractorEvaluation.HashableArguments key : sorted) {
                BinaryTextRelation goldRelation = (BinaryTextRelation)goldMap.get(key);
                BinaryTextRelation systemRelation = (BinaryTextRelation)systemMap.get(key);
                if (goldRelation == null) {
                    System.out.println("System added: " + EvaluationOfI2B2TemporalRelations.formatRelation(systemRelation));
                    continue;
                }
                if (systemRelation == null) {
                    System.out.println("System dropped: " + EvaluationOfI2B2TemporalRelations.formatRelation(goldRelation));
                    continue;
                }
                if (!systemRelation.getCategory().equals(goldRelation.getCategory())) {
                    String label = systemRelation.getCategory();
                    System.out.printf("System labeled %s for %s\n", label, EvaluationOfI2B2TemporalRelations.formatRelation(goldRelation));
                    continue;
                }
                System.out.println("Nailed it! " + EvaluationOfI2B2TemporalRelations.formatRelation(systemRelation));
            }
        }
        return stats;
    }

    @PipeBitInfo(name="TLink Closure Engine", description="Performs closure on Temporal Relations", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
    public static class AddClosure
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            String fileName = ViewUriUtil.getURI((JCas)jCas).toString();
            HashMultimap annotationsToRelation = HashMultimap.create();
            for (BinaryTextRelation relation : JCasUtil.select((JCas)jCas, BinaryTextRelation.class)) {
                String relationType = relation.getCategory();
                if (!AddClosure.validTemporalType(relationType)) continue;
                Annotation arg1 = relation.getArg1().getArgument();
                Annotation arg2 = relation.getArg2().getArgument();
                if (arg1 == null || arg2 == null) {
                    System.out.println("Null argument at Doc: " + fileName);
                    continue;
                }
                annotationsToRelation.put(Arrays.asList(arg1, arg2), (Object)relation);
            }
            for (List span : Lists.newArrayList((Iterable)annotationsToRelation.keySet())) {
                Collection relations = annotationsToRelation.get((Object)span);
                if (relations.size() <= 1) continue;
                HashSet types = Sets.newHashSet();
                for (BinaryTextRelation relation : relations) {
                    types.add(relation.getCategory());
                }
                if (types.size() > 1) {
                    for (BinaryTextRelation relation : Lists.newArrayList((Iterable)relations)) {
                        annotationsToRelation.remove((Object)span, (Object)relation);
                        relation.getArg1().removeFromIndexes();
                        relation.getArg2().removeFromIndexes();
                        relation.removeFromIndexes();
                    }
                    continue;
                }
                if (types.size() != 1) continue;
                for (int i = 1; i < relations.size(); ++i) {
                    BinaryTextRelation relation;
                    relation = (BinaryTextRelation)relations.toArray()[i];
                    annotationsToRelation.remove((Object)span, (Object)relation);
                    relation.getArg1().removeFromIndexes();
                    relation.getArg2().removeFromIndexes();
                    relation.removeFromIndexes();
                }
            }
            ArrayList<BinaryTextRelation> temporalRelation = new ArrayList<BinaryTextRelation>(annotationsToRelation.values());
            if (!temporalRelation.isEmpty()) {
                TLinkTypeArray2 relationArray = new TLinkTypeArray2(temporalRelation, new AnnotationIdCollection(temporalRelation));
                int addedCount = 0;
                for (BinaryTextRelation relation : relationArray.getClosedTlinks(jCas)) {
                    Collection relations;
                    RelationArgument arg1 = relation.getArg1();
                    RelationArgument arg2 = relation.getArg2();
                    String relationType = relation.getCategory();
                    if (relationType.equals("CONTAINED-BY") || relationType.equals("AFTER") || !(relations = annotationsToRelation.get(Arrays.asList(arg1.getArgument(), arg2.getArgument()))).isEmpty()) continue;
                    arg1.addToIndexes();
                    arg2.addToIndexes();
                    relation.addToIndexes();
                    ++addedCount;
                }
                System.out.println("**************************************************************");
                System.out.println("Finally added closure relations: " + addedCount);
                System.out.println("**************************************************************");
            }
        }

        private static boolean validTemporalType(String relationType) {
            return relationType.equals("AFTER") || relationType.equals("OVERLAP") || relationType.equals("BEFORE");
        }
    }

    public static class FindLongDisRelations
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            try {
                JCas goldView = jCas.getView("GoldView");
                JCas systemView = jCas.getView("_InitialView");
                File outf = new File("target/eval/temporal-relations/RelationDistance.txt");
                File outI = new File("target/eval/temporal-relations/LongRelationInstances.txt");
                File outA = new File("target/eval/temporal-relations/AdjacentRelationInstances.txt");
                BufferedWriter output = new BufferedWriter(new FileWriter(outf, true));
                PrintWriter outIns = new PrintWriter(new BufferedWriter(new FileWriter(outI, true)));
                PrintWriter outAdj = new PrintWriter(new BufferedWriter(new FileWriter(outA, true)));
                HashSet temporalRelations = Sets.newHashSet();
                for (TemporalTextRelation relation : JCasUtil.select((JCas)goldView, TemporalTextRelation.class)) {
                    temporalRelations.add(relation);
                }
                for (BinaryTextRelation orelation : temporalRelations) {
                    Annotation argB;
                    int end;
                    Annotation argA = orelation.getArg1().getArgument();
                    int begin = argA == null ? 1000000 : argA.getEnd();
                    if (begin >= (end = (argB = orelation.getArg2().getArgument()) == null ? 0 : argB.getBegin())) continue;
                    int sentencesInBetween = 0;
                    List sentences = JCasUtil.selectCovered((JCas)systemView, Sentence.class, (int)begin, (int)end);
                    sentencesInBetween = sentences == null ? 0 : sentences.size();
                    boolean adjacentSent = false;
                    if (sentencesInBetween == 0) {
                        List follwingSentences = JCasUtil.selectFollowing((JCas)systemView, Sentence.class, (AnnotationFS)argA, (int)1);
                        if (follwingSentences != null && follwingSentences.size() >= 1) {
                            Sentence nextSent = (Sentence)follwingSentences.get(0);
                            if (nextSent.getBegin() > end) {
                                sentencesInBetween = -1;
                            } else {
                                adjacentSent = true;
                            }
                        } else {
                            List prededingSentences = JCasUtil.selectPreceding((JCas)systemView, Sentence.class, (AnnotationFS)argB, (int)1);
                            if (prededingSentences == null || prededingSentences.size() == 0) {
                                sentencesInBetween = -1;
                            } else {
                                Sentence preSent = (Sentence)prededingSentences.get(0);
                                if (preSent.getEnd() < begin) {
                                    sentencesInBetween = -1;
                                } else {
                                    adjacentSent = true;
                                }
                            }
                        }
                    }
                    String text = systemView.getDocumentText();
                    int windowBegin = Math.max(0, argA.getBegin() - 50);
                    int windowEnd = Math.min(text.length(), argB.getEnd() + 50);
                    if (adjacentSent) {
                        outAdj.println("++++++++++Adjacent X-sentence Relation in " + ViewUriUtil.getURI((JCas)jCas).toString() + "+++++++");
                        outAdj.println(text.substring(windowBegin, argA.getBegin()) + "[" + argA.getCoveredText() + "] " + text.substring(argA.getEnd(), argB.getBegin()) + " [" + argB.getCoveredText() + "]" + text.substring(argB.getEnd(), windowEnd));
                    }
                    output.append(sentencesInBetween + "\n");
                    if (sentencesInBetween <= 5) continue;
                    outIns.println("++++++++++Long Distance Relation in " + ViewUriUtil.getURI((JCas)jCas).toString() + "+++++++");
                    outIns.println(text.substring(windowBegin, argA.getBegin()) + "[" + argA.getCoveredText() + "] " + text.substring(argA.getEnd(), argB.getBegin()) + " [" + argB.getCoveredText() + "]" + text.substring(argB.getEnd(), windowEnd));
                }
                output.close();
                outIns.close();
                outAdj.close();
            }
            catch (IOException goldView) {
            }
            catch (CASException e) {
                e.printStackTrace();
            }
        }
    }

    @PipeBitInfo(name="Reverse Overlap TLinker", description="Adds Overlap temporal relations with arguments flipped.", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
    public static class AddFlippedOverlap
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            HashSet overlapRelations = Sets.newHashSet();
            HashMultimap overlaps = HashMultimap.create();
            for (BinaryTextRelation relation : JCasUtil.select((JCas)jCas, BinaryTextRelation.class)) {
                if (!relation.getCategory().equals("OVERLAP")) continue;
                overlapRelations.add(relation);
                Annotation arg1 = relation.getArg1().getArgument();
                Annotation arg2 = relation.getArg2().getArgument();
                overlaps.put((Object)arg1, (Object)arg2);
            }
            for (BinaryTextRelation orelation : overlapRelations) {
                Annotation argA = orelation.getArg1().getArgument();
                Annotation argB = orelation.getArg2().getArgument();
                if (overlaps.containsEntry((Object)argB, (Object)argA)) continue;
                RelationArgument arg1 = new RelationArgument(jCas);
                arg1.setArgument(argB);
                RelationArgument arg2 = new RelationArgument(jCas);
                arg2.setArgument(argA);
                BinaryTextRelation relation = new BinaryTextRelation(jCas);
                relation.setArg1(arg1);
                relation.setArg2(arg2);
                relation.setCategory("OVERLAP");
                arg1.addToIndexes();
                arg2.addToIndexes();
                relation.addToIndexes();
                overlaps.put((Object)argB, (Object)argA);
            }
        }
    }

    public static class RemoveRelations
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            for (BinaryTextRelation relation : Lists.newArrayList((Iterable)JCasUtil.select((JCas)jCas, BinaryTextRelation.class))) {
                relation.getArg1().removeFromIndexes();
                relation.getArg2().removeFromIndexes();
                relation.removeFromIndexes();
            }
        }
    }

    public static class RemoveNonTLINKRelations
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            for (BinaryTextRelation relation : Lists.newArrayList((Iterable)JCasUtil.select((JCas)jCas, BinaryTextRelation.class))) {
                if (relation instanceof TemporalTextRelation) continue;
                relation.getArg1().removeFromIndexes();
                relation.getArg2().removeFromIndexes();
                relation.removeFromIndexes();
            }
        }
    }

    public static class RemoveNullArgumentRelations
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            for (BinaryTextRelation relation : Lists.newArrayList((Iterable)JCasUtil.select((JCas)jCas, BinaryTextRelation.class))) {
                if (relation.getArg1() != null && relation.getArg2() != null) continue;
                relation.getArg1().removeFromIndexes();
                relation.getArg2().removeFromIndexes();
                relation.removeFromIndexes();
            }
        }
    }

    static interface TempRelOptions
    extends Evaluation_ImplBase.Options {
        @Option
        public boolean getPrintFormattedRelations();

        @Option
        public boolean getBaseline();

        @Option
        public boolean getClosure();

        @Option
        public boolean getUseTmp();

        @Option
        public boolean getUseGoldAttributes();

        @Override
        @Option
        public boolean getSkipTrain();
    }
}

