/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.nn.ae;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.temporal.ae.TemporalRelationExtractorAnnotator;
import org.apache.ctakes.temporal.nn.data.ArgContextProvider;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.CleartkAnnotator;
import org.cleartk.ml.Feature;
import org.cleartk.ml.Instance;
import org.cleartk.util.ViewUriUtil;

@PipeBitInfo(name="E-T Token TLinker", description="Creates Event - Time TLinks from Token type.", dependencies={PipeBitInfo.TypeProduct.SECTION, PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.EVENT, PipeBitInfo.TypeProduct.TIMEX}, products={PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
public class EventTimeTokenBasedAnnotator
extends CleartkAnnotator<String> {
    public static final String NO_RELATION_CATEGORY = "none";
    private static TimeMention coveringTimex;
    public static Map<String, Integer> timex_idx;
    public static OutputMode timexMode;
    private BufferedReader reader;
    private static FileWriter fstream;
    private static BufferedWriter out;

    public EventTimeTokenBasedAnnotator() {
        timexMode = OutputMode.IndexTags;
        if (timexMode == OutputMode.IndexTags) {
            timex_idx = new HashMap<String, Integer>();
        }
    }

    public Map<String, Integer> TimexIdxReader(InputStream in) throws IOException {
        this.reader = new BufferedReader(new InputStreamReader(in));
        HashMap<String, Integer> timex_index = new HashMap<String, Integer>();
        String line = null;
        while ((line = this.reader.readLine()) != null) {
            line = line.trim();
            int sep = line.lastIndexOf("|");
            String timex = line.substring(0, sep);
            Integer idx = Integer.parseInt(line.substring(sep + 1));
            timex_index.put(timex, idx);
        }
        this.reader.close();
        return timex_index;
    }

    public static void TimexIdxWriter() throws IOException {
        fstream = new FileWriter("target/eval/thyme/train_and_test/event-time/timex_idx.txt");
        out = new BufferedWriter(fstream);
        for (Map.Entry<String, Integer> pairs : timex_idx.entrySet()) {
            out.write(pairs.getKey() + "|" + pairs.getValue() + "\n");
        }
        out.close();
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        if (timexMode == OutputMode.IndexTags && !this.isTraining()) {
            String timexIdxMapFile = "target/eval/thyme/train_and_test/event-time/timex_idx.txt";
            try {
                timex_idx = this.TimexIdxReader(FileLocator.getAsStream((String)"target/eval/thyme/train_and_test/event-time/timex_idx.txt"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        HashMap<List<Annotation>, BinaryTextRelation> relationLookup = new HashMap<List<Annotation>, BinaryTextRelation>();
        if (this.isTraining()) {
            relationLookup = new HashMap();
            for (BinaryTextRelation relation : JCasUtil.select((JCas)jCas, BinaryTextRelation.class)) {
                Annotation arg2;
                Annotation arg1 = relation.getArg1().getArgument();
                List<Annotation> key = Arrays.asList(arg1, arg2 = relation.getArg2().getArgument());
                if (relationLookup.containsKey(key)) {
                    String reln = ((BinaryTextRelation)relationLookup.get(key)).getCategory();
                    System.err.println("Error in: " + ViewUriUtil.getURI((JCas)jCas).toString());
                    System.err.println("Error! This attempted relation " + relation.getCategory() + " already has a relation " + reln + " at this span: " + arg1.getCoveredText() + " -- " + arg2.getCoveredText());
                    continue;
                }
                relationLookup.put(key, relation);
            }
        }
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            List<TemporalRelationExtractorAnnotator.IdentifiedAnnotationPair> candidatePairs = this.getCandidateRelationArgumentPairs(jCas, (Annotation)sentence);
            for (TemporalRelationExtractorAnnotator.IdentifiedAnnotationPair pair : candidatePairs) {
                String[] tokens;
                IdentifiedAnnotation arg1 = pair.getArg1();
                IdentifiedAnnotation arg2 = pair.getArg2();
                String context = arg2.getBegin() < arg1.getBegin() ? (timexMode == OutputMode.TokenSeq ? ArgContextProvider.getTokenContext(jCas, sentence, (Annotation)arg2, "t", (Annotation)arg1, "e", 2) : EventTimeTokenBasedAnnotator.getTokenTimexContext(jCas, sentence, arg2, "t", arg1, "e", 2)) : (timexMode == OutputMode.TokenSeq ? ArgContextProvider.getTokenContext(jCas, sentence, (Annotation)arg1, "e", (Annotation)arg2, "t", 2) : EventTimeTokenBasedAnnotator.getTokenTimexContext(jCas, sentence, arg1, "e", arg2, "t", 2));
                ArrayList<Feature> features = new ArrayList<Feature>();
                for (String token : tokens = context.split(" ")) {
                    features.add(new Feature((Object)token.toLowerCase()));
                }
                if (this.isTraining()) {
                    String category = this.getRelationCategory(relationLookup, arg1, arg2);
                    category = category == null ? NO_RELATION_CATEGORY : category.toLowerCase();
                    this.dataWriter.write(new Instance((Object)category, features));
                    continue;
                }
                String predictedCategory = (String)this.classifier.classify(features);
                if (predictedCategory == null || predictedCategory.equals(NO_RELATION_CATEGORY)) continue;
                if (predictedCategory.endsWith("-1")) {
                    predictedCategory = predictedCategory.substring(0, predictedCategory.length() - 2);
                    if (arg1 instanceof TimeMention) {
                        IdentifiedAnnotation temp = arg1;
                        arg1 = arg2;
                        arg2 = temp;
                    }
                } else if (arg1 instanceof EventMention) {
                    IdentifiedAnnotation temp = arg1;
                    arg1 = arg2;
                    arg2 = temp;
                }
                this.createRelation(jCas, arg1, arg2, predictedCategory.toUpperCase(), 0.0);
            }
        }
        if (timexMode == OutputMode.IndexTags && !this.isTraining()) {
            try {
                EventTimeTokenBasedAnnotator.TimexIdxWriter();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getTokenTimexContext(JCas jCas, Sentence sentence, IdentifiedAnnotation arg1, String leftType, IdentifiedAnnotation arg2, String rightType, int contextSize) {
        String timeTag;
        List<String> tokens = new ArrayList<String>();
        List preTimex = JCasUtil.selectCovered((JCas)jCas, TimeMention.class, (int)sentence.getBegin(), (int)arg1.getBegin());
        List betweenTimex = JCasUtil.selectCovered((JCas)jCas, TimeMention.class, (int)arg1.getEnd(), (int)arg2.getBegin());
        List afterTimex = JCasUtil.selectCovered((JCas)jCas, TimeMention.class, (int)arg2.getEnd(), (int)sentence.getEnd());
        tokens = EventTimeTokenBasedAnnotator.addTimex2TokenSequence(jCas, tokens, JCasUtil.selectPreceding((JCas)jCas, BaseToken.class, (AnnotationFS)arg1, (int)contextSize), preTimex, sentence);
        tokens.add("<" + leftType + ">");
        if (arg1 instanceof TimeMention) {
            timeTag = EventTimeTokenBasedAnnotator.generateTimeTag(jCas, (TimeMention)arg1);
            tokens.add(timeTag);
        } else {
            tokens.add(arg1.getCoveredText());
        }
        tokens.add("</" + leftType + ">");
        tokens = EventTimeTokenBasedAnnotator.addTimex2TokenSequence(jCas, tokens, JCasUtil.selectBetween((JCas)jCas, BaseToken.class, (AnnotationFS)arg1, (AnnotationFS)arg2), betweenTimex, sentence);
        tokens.add("<" + rightType + ">");
        if (arg2 instanceof TimeMention) {
            timeTag = EventTimeTokenBasedAnnotator.generateTimeTag(jCas, (TimeMention)arg2);
            tokens.add(timeTag);
        } else {
            tokens.add(arg2.getCoveredText());
        }
        tokens.add("</" + rightType + ">");
        tokens = EventTimeTokenBasedAnnotator.addTimex2TokenSequence(jCas, tokens, JCasUtil.selectFollowing((JCas)jCas, BaseToken.class, (AnnotationFS)arg2, (int)contextSize), afterTimex, sentence);
        return String.join((CharSequence)" ", tokens).replaceAll("[\r\n]", " ");
    }

    private static String generateTimeTag(JCas jCas, TimeMention timex) {
        String timeTag = "<timex";
        if (timexMode == OutputMode.IndexTags) {
            timeTag = timeTag + "_";
            int idx = 0;
            String timeWord = timex.getCoveredText().toLowerCase().replaceAll("[\r\n]", " ");
            if (timex_idx.containsKey(timeWord)) {
                idx = timex_idx.get(timeWord);
            } else {
                idx = timex_idx.size();
                timex_idx.put(timeWord, idx);
            }
            timeTag = timeTag + idx + ">";
        } else if (timexMode == OutputMode.Timeclass) {
            timeTag = "<timex_" + timex.getTimeClass() + ">";
        } else if (timexMode == OutputMode.TimeclassPosSeq) {
            timeTag = "<timex_" + timex.getTimeClass();
            for (BaseToken token : JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)timex)) {
                timeTag = timeTag + "_" + token.getPartOfSpeech();
            }
            timeTag = timeTag + ">";
        } else if (timexMode == OutputMode.PosSeq) {
            timeTag = "<timex";
            for (BaseToken token : JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)timex)) {
                timeTag = timeTag + "_" + token.getPartOfSpeech();
            }
            timeTag = timeTag + ">";
        } else if (timexMode == OutputMode.SingleTag) {
            timeTag = timeTag + ">";
        } else if (timexMode == OutputMode.TokenTimeclass) {
            timeTag = timex.getCoveredText() + " <timex_" + timex.getTimeClass() + ">";
        } else if (timexMode == OutputMode.TokenTimeclassPosSeq) {
            timeTag = timex.getCoveredText() + " <timex_" + timex.getTimeClass();
            for (BaseToken token : JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)timex)) {
                timeTag = timeTag + "_" + token.getPartOfSpeech();
            }
            timeTag = timeTag + ">";
        } else if (timexMode == OutputMode.NoTag) {
            timeTag = "";
        }
        return timeTag;
    }

    private static List<String> addTimex2TokenSequence(JCas jCas, List<String> tokens, List<BaseToken> tokenSequences, List<TimeMention> listOfTimex, Sentence sent) {
        coveringTimex = null;
        for (BaseToken baseToken : tokenSequences) {
            if (baseToken.getEnd() > sent.getEnd() || sent.getBegin() > baseToken.getBegin()) continue;
            TimeMention currentTimex = EventTimeTokenBasedAnnotator.findCoveringTimex(baseToken, listOfTimex);
            if (currentTimex == null) {
                if (coveringTimex != null) {
                    coveringTimex = null;
                }
                tokens.add(baseToken.getCoveredText());
                continue;
            }
            if (currentTimex == coveringTimex) continue;
            String timeTag = EventTimeTokenBasedAnnotator.generateTimeTag(jCas, currentTimex);
            tokens.add(timeTag);
            coveringTimex = currentTimex;
        }
        return tokens;
    }

    private static TimeMention findCoveringTimex(BaseToken baseToken, List<TimeMention> timexs) {
        for (TimeMention timex : timexs) {
            if (timex.getBegin() > baseToken.getBegin() || timex.getEnd() < baseToken.getEnd()) continue;
            return timex;
        }
        return null;
    }

    private static String getEventProperty(EventMention mention) {
        String eventProp = mention.getCoveredText();
        if (mention.getEvent() == null || mention.getEvent().getProperties() == null) {
            return eventProp;
        }
        String contextualModality = mention.getEvent().getProperties().getContextualModality();
        if (contextualModality != null) {
            eventProp = eventProp + "_" + contextualModality;
        }
        return eventProp;
    }

    protected String getRelationCategory(Map<List<Annotation>, BinaryTextRelation> relationLookup, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) {
        BinaryTextRelation relation = relationLookup.get(Arrays.asList(arg1, arg2));
        String category = null;
        if (relation != null) {
            category = relation.getCategory();
            if (arg1 instanceof EventMention) {
                category = category + "-1";
            }
        } else {
            relation = relationLookup.get(Arrays.asList(arg2, arg1));
            if (relation != null) {
                category = relation.getCategory();
                if (arg2 instanceof EventMention) {
                    category = category + "-1";
                }
            }
        }
        return category;
    }

    protected void createRelation(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2, String predictedCategory, double confidence) {
        RelationArgument relArg1 = new RelationArgument(jCas);
        relArg1.setArgument((Annotation)arg1);
        relArg1.setRole("Arg1");
        relArg1.addToIndexes();
        RelationArgument relArg2 = new RelationArgument(jCas);
        relArg2.setArgument((Annotation)arg2);
        relArg2.setRole("Arg2");
        relArg2.addToIndexes();
        TemporalTextRelation relation = new TemporalTextRelation(jCas);
        relation.setArg1(relArg1);
        relation.setArg2(relArg2);
        relation.setCategory(predictedCategory);
        relation.setConfidence(confidence);
        relation.addToIndexes();
    }

    public List<TemporalRelationExtractorAnnotator.IdentifiedAnnotationPair> getCandidateRelationArgumentPairs(JCas jCas, Annotation sentence) {
        ArrayList pairs = Lists.newArrayList();
        for (EventMention event : JCasUtil.selectCovered((JCas)jCas, EventMention.class, (AnnotationFS)sentence)) {
            if (!event.getClass().equals(EventMention.class)) continue;
            for (TimeMention time : JCasUtil.selectCovered((JCas)jCas, TimeMention.class, (AnnotationFS)sentence)) {
                pairs.add(new TemporalRelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)event, (IdentifiedAnnotation)time));
            }
        }
        return pairs;
    }

    public static enum OutputMode {
        TokenSeq,
        TokenTimeclass,
        TokenTimeclassPosSeq,
        Timeclass,
        TimeclassPosSeq,
        PosSeq,
        SingleTag,
        IndexTags,
        NoTag;

    }
}

