/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.nn.data;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class ArgContextProvider {
    private static TimeMention coveringTimex;
    private static final String BTAG = "<B";
    private static final String OTAG = "<O>";
    private static final String ITAG = "<I";

    public static String getEventTimePositionContext(JCas jCas, Sentence sent, IdentifiedAnnotation time, IdentifiedAnnotation event) {
        ArrayList<String> tokens = new ArrayList<String>();
        for (BaseToken baseToken : JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)sent)) {
            tokens.add(baseToken.getCoveredText());
        }
        int currentPosition = 0;
        int timeFirstPosition = -1000;
        int timeLastPosition = -1000;
        int eventPosition = -1000;
        for (BaseToken token : JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)sent)) {
            if (time.getBegin() == token.getBegin()) {
                timeFirstPosition = currentPosition;
            }
            if (time.getEnd() == token.getEnd()) {
                timeLastPosition = currentPosition;
            }
            if (event.getBegin() == token.getBegin()) {
                eventPosition = currentPosition;
            }
            ++currentPosition;
        }
        if (eventPosition == -1000) {
            currentPosition = 0;
            for (BaseToken token : JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)sent)) {
                if (token.getCoveredText().contains(event.getCoveredText())) {
                    eventPosition = currentPosition;
                }
                ++currentPosition;
            }
        }
        if (eventPosition == -1000) {
            System.out.println("event not found: " + event.getCoveredText());
            System.out.println(sent.getCoveredText());
            System.out.println();
            eventPosition = 0;
        }
        if (timeFirstPosition == -1000 || timeLastPosition == -1000) {
            System.out.println("time not found: " + time.getCoveredText());
            System.out.println(sent.getCoveredText());
            System.out.println();
            timeFirstPosition = 0;
            timeLastPosition = 0;
        }
        ArrayList<String> positionsWrtToTime = new ArrayList<String>();
        ArrayList<String> positionsWrtToEvent = new ArrayList<String>();
        int tokensInSentence = JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)sent).size();
        for (int tokenIndex = 0; tokenIndex < tokensInSentence; ++tokenIndex) {
            if (tokenIndex < timeFirstPosition) {
                positionsWrtToTime.add(Integer.toString(tokenIndex - timeFirstPosition));
            } else if (tokenIndex >= timeFirstPosition && tokenIndex <= timeLastPosition) {
                positionsWrtToTime.add("0");
            } else {
                positionsWrtToTime.add(Integer.toString(tokenIndex - timeLastPosition));
            }
            positionsWrtToEvent.add(Integer.toString(tokenIndex - eventPosition));
        }
        String tokensAsString = String.join((CharSequence)" ", tokens).replaceAll("[\r\n]", " ");
        String distanceToTime = String.join((CharSequence)" ", positionsWrtToTime);
        String distanceToEvent = String.join((CharSequence)" ", positionsWrtToEvent);
        return tokensAsString + "|" + distanceToTime + "|" + distanceToEvent;
    }

    public static String getEventEventPositionContext(JCas jCas, Sentence sent, IdentifiedAnnotation event1, IdentifiedAnnotation event2) {
        ArrayList<String> tokens = new ArrayList<String>();
        for (BaseToken baseToken : JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)sent)) {
            tokens.add(baseToken.getCoveredText());
        }
        int currentPosition = 0;
        int event1Position = -1000;
        int event2Position = -1000;
        for (BaseToken token : JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)sent)) {
            if (event1.getBegin() == token.getBegin()) {
                event1Position = currentPosition;
            }
            if (event2.getBegin() == token.getBegin()) {
                event2Position = currentPosition;
            }
            ++currentPosition;
        }
        ArrayList<String> positionsWrtToEvent1 = new ArrayList<String>();
        ArrayList<String> positionsWrtToEvent2 = new ArrayList<String>();
        int tokensInSentence = JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)sent).size();
        for (int tokenIndex = 0; tokenIndex < tokensInSentence; ++tokenIndex) {
            positionsWrtToEvent1.add(Integer.toString(tokenIndex - event1Position));
            positionsWrtToEvent2.add(Integer.toString(tokenIndex - event2Position));
        }
        String tokensAsString = String.join((CharSequence)" ", tokens).replaceAll("[\r\n]", " ");
        String distanceToTime = String.join((CharSequence)" ", positionsWrtToEvent1);
        String distanceToEvent = String.join((CharSequence)" ", positionsWrtToEvent2);
        return tokensAsString + "|" + distanceToTime + "|" + distanceToEvent;
    }

    public static String getRegions(JCas jCas, Sentence sent, Annotation left, Annotation right, int contextSize) {
        ArrayList<String> leftTokens = new ArrayList<String>();
        for (BaseToken baseToken : JCasUtil.selectPreceding((JCas)jCas, BaseToken.class, (AnnotationFS)left, (int)contextSize)) {
            if (sent.getBegin() > baseToken.getBegin()) continue;
            leftTokens.add(baseToken.getCoveredText());
        }
        String leftAsString = String.join((CharSequence)" ", leftTokens).replaceAll("[\r\n]", " ");
        ArrayList<String> arg1Tokens = new ArrayList<String>();
        for (BaseToken baseToken : JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)left)) {
            arg1Tokens.add(baseToken.getCoveredText());
        }
        String arg1AsString = String.join((CharSequence)" ", arg1Tokens).replaceAll("[\r\n]", " ");
        ArrayList<String> betweenTokens = new ArrayList<String>();
        for (BaseToken baseToken : JCasUtil.selectBetween((JCas)jCas, BaseToken.class, (AnnotationFS)left, (AnnotationFS)right)) {
            betweenTokens.add(baseToken.getCoveredText());
        }
        String betweenAsString = String.join((CharSequence)" ", betweenTokens).replaceAll("[\r\n]", " ");
        ArrayList<String> arg2Tokens = new ArrayList<String>();
        for (BaseToken baseToken : JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)right)) {
            arg2Tokens.add(baseToken.getCoveredText());
        }
        String arg2AsString = String.join((CharSequence)" ", arg2Tokens).replaceAll("[\r\n]", " ");
        ArrayList<String> rightTokens = new ArrayList<String>();
        for (BaseToken baseToken : JCasUtil.selectFollowing((JCas)jCas, BaseToken.class, (AnnotationFS)right, (int)contextSize)) {
            if (baseToken.getEnd() > sent.getEnd()) continue;
            rightTokens.add(baseToken.getCoveredText());
        }
        String rightAsString = String.join((CharSequence)" ", rightTokens).replaceAll("[\r\n]", " ");
        return leftAsString + "|" + arg1AsString + "|" + betweenAsString + "|" + arg2AsString + "|" + rightAsString;
    }

    public static String getTokenContext(JCas jCas, Sentence sent, Annotation left, String leftType, Annotation right, String rightType, int contextSize) {
        ArrayList<String> tokens = new ArrayList<String>();
        for (BaseToken baseToken : JCasUtil.selectPreceding((JCas)jCas, BaseToken.class, (AnnotationFS)left, (int)contextSize)) {
            if (sent.getBegin() > baseToken.getBegin()) continue;
            tokens.add(baseToken.getCoveredText());
        }
        tokens.add("<" + leftType + ">");
        tokens.add(left.getCoveredText());
        tokens.add("</" + leftType + ">");
        for (BaseToken baseToken : JCasUtil.selectBetween((JCas)jCas, BaseToken.class, (AnnotationFS)left, (AnnotationFS)right)) {
            tokens.add(baseToken.getCoveredText());
        }
        tokens.add("<" + rightType + ">");
        tokens.add(right.getCoveredText());
        tokens.add("</" + rightType + ">");
        for (BaseToken baseToken : JCasUtil.selectFollowing((JCas)jCas, BaseToken.class, (AnnotationFS)right, (int)contextSize)) {
            if (baseToken.getEnd() > sent.getEnd()) continue;
            tokens.add(baseToken.getCoveredText());
        }
        return String.join((CharSequence)" ", tokens).replaceAll("[\r\n]", " ");
    }

    public static String getPosContext(JCas jCas, Sentence sent, Annotation left, String leftType, Annotation right, String rightType, int contextSize) {
        ArrayList<String> tokens = new ArrayList<String>();
        for (BaseToken baseToken : JCasUtil.selectPreceding((JCas)jCas, BaseToken.class, (AnnotationFS)left, (int)contextSize)) {
            if (sent.getBegin() > baseToken.getBegin()) continue;
            tokens.add(baseToken.getPartOfSpeech());
        }
        tokens.add("<" + leftType + ">");
        for (BaseToken baseToken : JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)left)) {
            tokens.add(baseToken.getPartOfSpeech());
        }
        tokens.add("</" + leftType + ">");
        for (BaseToken baseToken : JCasUtil.selectBetween((JCas)jCas, BaseToken.class, (AnnotationFS)left, (AnnotationFS)right)) {
            tokens.add(baseToken.getPartOfSpeech());
        }
        tokens.add("<" + rightType + ">");
        for (BaseToken baseToken : JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)right)) {
            tokens.add(baseToken.getPartOfSpeech());
        }
        tokens.add("</" + rightType + ">");
        for (BaseToken baseToken : JCasUtil.selectFollowing((JCas)jCas, BaseToken.class, (AnnotationFS)right, (int)contextSize)) {
            if (baseToken.getEnd() > sent.getEnd()) continue;
            tokens.add(baseToken.getPartOfSpeech());
        }
        return String.join((CharSequence)" ", tokens).replaceAll("[\r\n]", " ");
    }

    public static String getBIOContext(JCas jCas, Sentence sentence, IdentifiedAnnotation arg1, String leftType, IdentifiedAnnotation arg2, String rightType, int contextSize) {
        String timeTag;
        List<String> tokens = new ArrayList<String>();
        List preTimex = JCasUtil.selectCovered((JCas)jCas, TimeMention.class, (int)sentence.getBegin(), (int)arg1.getBegin());
        List betweenTimex = JCasUtil.selectCovered((JCas)jCas, TimeMention.class, (int)arg1.getEnd(), (int)arg2.getBegin());
        List afterTimex = JCasUtil.selectCovered((JCas)jCas, TimeMention.class, (int)arg2.getEnd(), (int)sentence.getEnd());
        tokens = ArgContextProvider.addTimex2TokenSequence(jCas, tokens, JCasUtil.selectPreceding((JCas)jCas, BaseToken.class, (AnnotationFS)arg1, (int)contextSize), preTimex, sentence);
        tokens.add(OTAG);
        if (arg1 instanceof TimeMention) {
            timeTag = ArgContextProvider.generateTimeTag(jCas, (TimeMention)arg1);
            tokens.add(timeTag);
        } else {
            tokens.add(OTAG);
        }
        tokens.add(OTAG);
        tokens = ArgContextProvider.addTimex2TokenSequence(jCas, tokens, JCasUtil.selectBetween((JCas)jCas, BaseToken.class, (AnnotationFS)arg1, (AnnotationFS)arg2), betweenTimex, sentence);
        tokens.add(OTAG);
        if (arg2 instanceof TimeMention) {
            timeTag = ArgContextProvider.generateTimeTag(jCas, (TimeMention)arg2);
            tokens.add(timeTag);
        } else {
            tokens.add(OTAG);
        }
        tokens.add(OTAG);
        tokens = ArgContextProvider.addTimex2TokenSequence(jCas, tokens, JCasUtil.selectFollowing((JCas)jCas, BaseToken.class, (AnnotationFS)arg2, (int)contextSize), afterTimex, sentence);
        return String.join((CharSequence)" ", tokens).replaceAll("[\r\n]", " ");
    }

    private static String generateTimeTag(JCas jCas, TimeMention timex) {
        List tokens = JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)timex);
        int numTokens = tokens.size();
        if (numTokens <= 0) {
            return "";
        }
        String timeTag = "<B_" + timex.getTimeClass() + ">";
        if (numTokens == 1) {
            return timeTag;
        }
        for (int i = 0; i < numTokens - 1; ++i) {
            timeTag = timeTag + " " + ITAG + "_" + timex.getTimeClass() + ">";
        }
        return timeTag;
    }

    private static List<String> addTimex2TokenSequence(JCas jCas, List<String> tokens, List<BaseToken> tokenSequences, List<TimeMention> listOfTimex, Sentence sent) {
        coveringTimex = null;
        for (BaseToken baseToken : tokenSequences) {
            if (baseToken.getEnd() > sent.getEnd() || sent.getBegin() > baseToken.getBegin()) continue;
            TimeMention currentTimex = ArgContextProvider.findCoveringTimex(baseToken, listOfTimex);
            if (currentTimex == null) {
                if (coveringTimex != null) {
                    coveringTimex = null;
                }
                tokens.add(OTAG);
                continue;
            }
            if (currentTimex == coveringTimex) continue;
            String timeTag = ArgContextProvider.generateTimeTag(jCas, currentTimex);
            tokens.add(timeTag);
            coveringTimex = currentTimex;
        }
        return tokens;
    }

    private static TimeMention findCoveringTimex(BaseToken baseToken, List<TimeMention> timexs) {
        for (TimeMention timex : timexs) {
            if (timex.getBegin() > baseToken.getBegin() || timex.getEnd() < baseToken.getEnd()) continue;
            return timex;
        }
        return null;
    }
}

