/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup2.dictionary;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ctakes.dictionary.lookup2.concept.ConceptFactory;
import org.apache.ctakes.dictionary.lookup2.consumer.TermConsumer;
import org.apache.ctakes.dictionary.lookup2.dictionary.RareWordDictionary;
import org.apache.ctakes.dictionary.lookup2.util.DefaultDictionarySpec;
import org.apache.ctakes.dictionary.lookup2.util.DictionarySpec;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorContextException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public final class DictionaryDescriptorParser {
    private static final Logger LOGGER = Logger.getLogger((String)"DictionaryDescriptorParser");
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final String DICTIONARIES_KEY = "dictionaries";
    private static final String CONCEPT_FACTORIES_KEY = "conceptFactories";
    private static final String PAIRS_KEY = "dictionaryConceptPairs";
    private static final String CONSUMER_KEY = "rareWordConsumer";
    private static final String NAME_KEY = "name";
    private static final String IMPLEMENTATION_KEY = "implementationName";
    private static final String PAIR_DICTIONARY_NAME = "dictionaryName";
    private static final String PAIR_CONCEPT_FACTORY_NAME = "conceptFactoryName";
    private static final String PROPERTIES_KEY = "properties";
    private static final int MAX_LIST_SIZE = Integer.MAX_VALUE;

    private DictionaryDescriptorParser() {
    }

    public static DictionarySpec parseDescriptor(InputStream descriptorFile, UimaContext uimaContext) throws AnnotatorContextException {
        Document doc;
        LOGGER.info((Object)"Parsing dictionary specifications: ");
        SAXBuilder saxBuilder = new SAXBuilder();
        try {
            doc = saxBuilder.build(descriptorFile);
        }
        catch (IOException | JDOMException jdomioE) {
            throw new AnnotatorContextException("Could not parse ", EMPTY_OBJECT_ARRAY, jdomioE);
        }
        Map<String, RareWordDictionary> dictionaries = DictionaryDescriptorParser.parseDictionaries(uimaContext, doc.getRootElement().getChild(DICTIONARIES_KEY));
        Map<String, ConceptFactory> conceptFactories = DictionaryDescriptorParser.parseConceptFactories(uimaContext, doc.getRootElement().getChild(CONCEPT_FACTORIES_KEY));
        Map<String, String> pairDictionaryNames = DictionaryDescriptorParser.parsePairingNames(doc.getRootElement().getChild(PAIRS_KEY), PAIR_DICTIONARY_NAME);
        Map<String, String> pairConceptFactoryNames = DictionaryDescriptorParser.parsePairingNames(doc.getRootElement().getChild(PAIRS_KEY), PAIR_CONCEPT_FACTORY_NAME);
        TermConsumer consumer = DictionaryDescriptorParser.parseConsumerXml(uimaContext, doc.getRootElement().getChild(CONSUMER_KEY));
        return new DefaultDictionarySpec(pairDictionaryNames, pairConceptFactoryNames, dictionaries, conceptFactories, consumer);
    }

    private static Map<String, RareWordDictionary> parseDictionaries(UimaContext uimaContext, Element dictionariesElement) throws AnnotatorContextException {
        HashMap<String, RareWordDictionary> dictionaries = new HashMap<String, RareWordDictionary>();
        List dictionaryElements = dictionariesElement.getChildren();
        for (Object dictionaryElement : dictionaryElements) {
            RareWordDictionary dictionary;
            if (!(dictionaryElement instanceof Element) || (dictionary = DictionaryDescriptorParser.parseDictionary(uimaContext, (Element)dictionaryElement)) == null) continue;
            dictionaries.put(dictionary.getName(), dictionary);
        }
        return dictionaries;
    }

    private static RareWordDictionary parseDictionary(UimaContext uimaContext, Element dictionaryElement) throws AnnotatorContextException {
        Constructor<?>[] constructors;
        Class<?> dictionaryClass;
        Object[] constructionArgs = new Class[]{String.class, UimaContext.class, Properties.class};
        String name = DictionaryDescriptorParser.getName("Dictionary Name", dictionaryElement);
        String className = dictionaryElement.getChildText(IMPLEMENTATION_KEY);
        Element propertiesElement = dictionaryElement.getChild(PROPERTIES_KEY);
        Properties properties = DictionaryDescriptorParser.parsePropertiesXml(propertiesElement);
        try {
            dictionaryClass = Class.forName(className);
        }
        catch (ClassNotFoundException cnfE) {
            throw new AnnotatorContextException("Unknown class " + className, EMPTY_OBJECT_ARRAY, (Throwable)cnfE);
        }
        if (!RareWordDictionary.class.isAssignableFrom(dictionaryClass)) {
            throw new AnnotatorContextException(className + " is not a Rare Word Dictionary", EMPTY_OBJECT_ARRAY);
        }
        for (Constructor<?> constructor : constructors = dictionaryClass.getConstructors()) {
            try {
                if (!Arrays.equals(constructionArgs, constructor.getParameterTypes())) continue;
                Object[] args = new Object[]{name, uimaContext, properties};
                return (RareWordDictionary)constructor.newInstance(args);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException iniaitE) {
                throw new AnnotatorContextException("Could not construct " + className, EMPTY_OBJECT_ARRAY, (Throwable)iniaitE);
            }
        }
        throw new AnnotatorContextException("No Constructor for " + className, EMPTY_OBJECT_ARRAY);
    }

    private static Map<String, ConceptFactory> parseConceptFactories(UimaContext uimaContext, Element conceptFactoriesElement) throws AnnotatorContextException {
        HashMap<String, ConceptFactory> conceptFactories = new HashMap<String, ConceptFactory>();
        List conceptFactoryElements = conceptFactoriesElement.getChildren();
        for (Object conceptFactoryElement : conceptFactoryElements) {
            ConceptFactory conceptFactory;
            if (!(conceptFactoryElement instanceof Element) || (conceptFactory = DictionaryDescriptorParser.parseConceptFactory(uimaContext, (Element)conceptFactoryElement)) == null) continue;
            conceptFactories.put(conceptFactory.getName(), conceptFactory);
        }
        return conceptFactories;
    }

    private static ConceptFactory parseConceptFactory(UimaContext uimaContext, Element conceptFactoryElement) throws AnnotatorContextException {
        Constructor<?>[] constructors;
        Class<?> conceptFactoryClass;
        Object[] constructionArgs = new Class[]{String.class, UimaContext.class, Properties.class};
        String name = DictionaryDescriptorParser.getName("Concept Factory Name", conceptFactoryElement);
        String className = conceptFactoryElement.getChildText(IMPLEMENTATION_KEY);
        Element propertiesElement = conceptFactoryElement.getChild(PROPERTIES_KEY);
        Properties properties = DictionaryDescriptorParser.parsePropertiesXml(propertiesElement);
        try {
            conceptFactoryClass = Class.forName(className);
        }
        catch (ClassNotFoundException cnfE) {
            throw new AnnotatorContextException("Unknown class " + className, EMPTY_OBJECT_ARRAY, (Throwable)cnfE);
        }
        if (!ConceptFactory.class.isAssignableFrom(conceptFactoryClass)) {
            throw new AnnotatorContextException(className + " is not a Concept Factory", EMPTY_OBJECT_ARRAY);
        }
        for (Constructor<?> constructor : constructors = conceptFactoryClass.getConstructors()) {
            try {
                if (!Arrays.equals(constructionArgs, constructor.getParameterTypes())) continue;
                Object[] args = new Object[]{name, uimaContext, properties};
                return (ConceptFactory)constructor.newInstance(args);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException iniaitE) {
                throw new AnnotatorContextException("Could not construct " + className, EMPTY_OBJECT_ARRAY, (Throwable)iniaitE);
            }
        }
        throw new AnnotatorContextException("No Constructor for " + className, EMPTY_OBJECT_ARRAY);
    }

    private static Map<String, String> parsePairingNames(Element pairingsElement, String pairingName) throws AnnotatorContextException {
        HashMap<String, String> pairConceptFactoryNames = new HashMap<String, String>();
        List pairingElements = pairingsElement.getChildren();
        for (Object pairingElement : pairingElements) {
            if (!(pairingElement instanceof Element)) continue;
            String pairName = DictionaryDescriptorParser.getName("Dictionary - Concept Factory Pairing", (Element)pairingElement);
            String conceptFactorName = ((Element)pairingElement).getChildText(pairingName);
            pairConceptFactoryNames.put(pairName, conceptFactorName);
        }
        return pairConceptFactoryNames;
    }

    private static String getName(String elementName, Element element) throws AnnotatorContextException {
        String name = element.getChildText(NAME_KEY);
        if (name == null || name.isEmpty()) {
            throw new AnnotatorContextException("Missing name for " + elementName, EMPTY_OBJECT_ARRAY);
        }
        return name;
    }

    private static TermConsumer parseConsumerXml(UimaContext uimaContext, Element lookupConsumerElement) throws AnnotatorContextException {
        Constructor<?>[] constructors;
        Class<?> consumerClass;
        Object[] constrArgsConsum = new Class[]{UimaContext.class, Properties.class, Integer.TYPE};
        Object[] constrArgsConsumB = new Class[]{UimaContext.class, Properties.class};
        String consumerClassName = lookupConsumerElement.getChildText(IMPLEMENTATION_KEY);
        Element consumerPropertiesElement = lookupConsumerElement.getChild(PROPERTIES_KEY);
        Properties consumerProperties = DictionaryDescriptorParser.parsePropertiesXml(consumerPropertiesElement);
        try {
            consumerClass = Class.forName(consumerClassName);
        }
        catch (ClassNotFoundException cnfE) {
            throw new AnnotatorContextException("Unknown class " + consumerClassName, EMPTY_OBJECT_ARRAY, (Throwable)cnfE);
        }
        if (!TermConsumer.class.isAssignableFrom(consumerClass)) {
            throw new AnnotatorContextException(consumerClassName + " is not a TermConsumer", EMPTY_OBJECT_ARRAY);
        }
        for (Constructor<?> constructor : constructors = consumerClass.getConstructors()) {
            try {
                if (Arrays.equals(constrArgsConsum, constructor.getParameterTypes())) {
                    Object[] args = new Object[]{uimaContext, consumerProperties, Integer.MAX_VALUE};
                    return (TermConsumer)constructor.newInstance(args);
                }
                if (!Arrays.equals(constrArgsConsumB, constructor.getParameterTypes())) continue;
                Object[] args = new Object[]{uimaContext, consumerProperties};
                return (TermConsumer)constructor.newInstance(args);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException multE) {
                throw new AnnotatorContextException("Could not construct " + consumerClassName, EMPTY_OBJECT_ARRAY, (Throwable)multE);
            }
        }
        throw new AnnotatorContextException("No Constructor for " + consumerClassName, EMPTY_OBJECT_ARRAY);
    }

    private static Properties parsePropertiesXml(Element propertiesElement) {
        Properties properties = new Properties();
        List propertyElements = propertiesElement.getChildren();
        for (Object value : propertyElements) {
            Element propertyElement = (Element)value;
            String key = propertyElement.getAttributeValue("key");
            String propertyValue = propertyElement.getAttributeValue("value");
            properties.put(key, propertyValue);
        }
        return properties;
    }
}

