/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup2.util;

import java.util.Collection;
import java.util.HashSet;

public final class TuiCodeUtil {
    private TuiCodeUtil() {
    }

    public static String getAsTui(Integer code) {
        StringBuilder sb = new StringBuilder(4);
        sb.append(code);
        return TuiCodeUtil.getAsTui(sb);
    }

    public static String getAsTui(String code) {
        if (code.length() == 4 && code.startsWith("T")) {
            return code;
        }
        StringBuilder sb = new StringBuilder(4);
        sb.append(code.replace("T", ""));
        return TuiCodeUtil.getAsTui(sb);
    }

    private static String getAsTui(StringBuilder sb) {
        while (sb.length() < 3) {
            sb.insert(0, '0');
        }
        sb.insert(0, 'T');
        return sb.toString();
    }

    public static Collection<String> getIntAsTuis(Collection<Integer> tuiCodes) {
        HashSet<String> tuis = new HashSet<String>(tuiCodes.size());
        for (Integer tuiCode : tuiCodes) {
            tuis.add(TuiCodeUtil.getAsTui(tuiCode));
        }
        return tuis;
    }

    public static Collection<String> getStringAsTuis(Collection<String> tuiNums) {
        HashSet<String> tuis = new HashSet<String>(tuiNums.size());
        for (String tuiNum : tuiNums) {
            tuis.add(TuiCodeUtil.getAsTui(tuiNum));
        }
        return tuis;
    }

    public static Integer getTuiCode(String tui) {
        String tuiText = TuiCodeUtil.getAsTui(tui);
        String tuiNum = tuiText.substring(1, tuiText.length());
        try {
            return Integer.parseInt(tuiNum);
        }
        catch (NumberFormatException nfE) {
            System.err.println("Could not create Tui Code for " + tui);
            return -1;
        }
    }
}

