/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.eval;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.collection.CollectionReader;

public abstract class Evaluation_ImplBase<ITEM_TYPE, STATS_TYPE> {
    protected File baseDirectory;

    public Evaluation_ImplBase(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public STATS_TYPE trainAndTest(List<ITEM_TYPE> trainItems, List<ITEM_TYPE> testItems) throws Exception {
        File subDirectory = new File(this.baseDirectory, "train_and_test");
        subDirectory.mkdirs();
        this.train(this.getCollectionReader(trainItems), subDirectory);
        return this.test(this.getCollectionReader(testItems), subDirectory);
    }

    public List<STATS_TYPE> crossValidation(List<ITEM_TYPE> items, int nFolds) throws Exception {
        if (nFolds > items.size()) {
            String message = "Cannot have %d folds with only %d items";
            throw new IllegalArgumentException(String.format(message, nFolds, items.size()));
        }
        ArrayList<STATS_TYPE> stats = new ArrayList<STATS_TYPE>();
        for (int fold = 0; fold < nFolds; ++fold) {
            File subDirectory = new File(this.baseDirectory, "fold_" + fold);
            subDirectory.mkdirs();
            List<ITEM_TYPE> trainItems = this.selectFoldTrainItems(items, nFolds, fold);
            List<ITEM_TYPE> testItems = this.selectFoldTestItems(items, nFolds, fold);
            this.train(this.getCollectionReader(trainItems), subDirectory);
            stats.add(this.test(this.getCollectionReader(testItems), subDirectory));
        }
        return stats;
    }

    protected List<ITEM_TYPE> selectFoldTrainItems(List<ITEM_TYPE> items, int nFolds, int fold) {
        ArrayList<ITEM_TYPE> trainItems = new ArrayList<ITEM_TYPE>();
        for (int i = 0; i < items.size(); ++i) {
            if (i % nFolds == fold) continue;
            trainItems.add(items.get(i));
        }
        return trainItems;
    }

    protected List<ITEM_TYPE> selectFoldTestItems(List<ITEM_TYPE> items, int nFolds, int fold) {
        ArrayList<ITEM_TYPE> testItems = new ArrayList<ITEM_TYPE>();
        for (int i = 0; i < items.size(); ++i) {
            if (i % nFolds != fold) continue;
            testItems.add(items.get(i));
        }
        return testItems;
    }

    protected abstract CollectionReader getCollectionReader(List<ITEM_TYPE> var1) throws Exception;

    protected abstract void train(CollectionReader var1, File var2) throws Exception;

    protected abstract STATS_TYPE test(CollectionReader var1, File var2) throws Exception;
}

