/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.uima.annotators;

import com.google.common.base.Strings;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.typesystem.type.refsem.OntologyConcept;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.ytex.kernel.metric.ConceptSimilarityService;
import org.apache.ctakes.ytex.kernel.wsd.WordSenseDisambiguator;
import org.apache.ctakes.ytex.uima.ApplicationContextHolder;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceInitializationException;

public class SenseDisambiguatorAnnotator
extends JCasAnnotator_ImplBase {
    int windowSize = 50;
    ConceptSimilarityService.SimilarityMetricEnum metric = ConceptSimilarityService.SimilarityMetricEnum.INTRINSIC_PATH;
    WordSenseDisambiguator wsd;
    boolean disabled = false;
    String conceptProperty = null;
    private static final Log log = LogFactory.getLog(SenseDisambiguatorAnnotator.class);

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        Properties props = ApplicationContextHolder.getYtexProperties();
        String conceptProperty = (String)aContext.getConfigParameterValue("conceptProperty");
        this.conceptProperty = !Strings.isNullOrEmpty((String)conceptProperty) ? conceptProperty : props.getProperty("ytex.conceptProperty");
        Integer nWindowSize = (Integer)aContext.getConfigParameterValue("windowSize");
        this.windowSize = nWindowSize != null && nWindowSize > 0 ? nWindowSize : Integer.parseInt(props.getProperty("ytex.sense.windowSize", "50"));
        String uMetric = (String)aContext.getConfigParameterValue("metric");
        this.metric = !Strings.isNullOrEmpty((String)uMetric) ? ConceptSimilarityService.SimilarityMetricEnum.valueOf((String)uMetric) : ConceptSimilarityService.SimilarityMetricEnum.valueOf((String)props.getProperty("ytex.sense.metric", "INTRINSIC_PATH"));
        this.wsd = (WordSenseDisambiguator)ApplicationContextHolder.getApplicationContext().getBean(WordSenseDisambiguator.class);
        ConceptSimilarityService simSvc = (ConceptSimilarityService)ApplicationContextHolder.getApplicationContext().getBean(ConceptSimilarityService.class);
        if (simSvc.getConceptGraph() == null) {
            log.warn((Object)"Concept Graph was not loaded - word sense disambiguation disabled");
            this.disabled = true;
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        if (this.disabled) {
            return;
        }
        FSIterator neIter = jcas.getAnnotationIndex(IdentifiedAnnotation.type).iterator();
        ArrayList<IdentifiedAnnotation> listNE = new ArrayList<IdentifiedAnnotation>();
        while (neIter.hasNext()) {
            listNE.add((IdentifiedAnnotation)((Object)neIter.next()));
        }
        this.disambiguate(jcas, listNE);
    }

    protected String getConceptId(FeatureStructure oc) throws AnalysisEngineProcessException {
        try {
            if (!Strings.isNullOrEmpty((String)this.conceptProperty)) {
                return BeanUtils.getProperty((Object)oc, (String)this.conceptProperty);
            }
            if (oc instanceof UmlsConcept) {
                return ((UmlsConcept)oc).getCui();
            }
            if (oc instanceof OntologyConcept) {
                return ((OntologyConcept)oc).getCode();
            }
            throw new IllegalArgumentException("don't know how to get concept id for: " + oc.getClass().getName());
        }
        catch (IllegalAccessException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    protected void disambiguate(JCas jcas, List<IdentifiedAnnotation> listNE) throws AnalysisEngineProcessException {
        ArrayList<IdentifiedAnnotation> listNonTrivialNE = new ArrayList<IdentifiedAnnotation>();
        ArrayList listConcept = new ArrayList();
        for (IdentifiedAnnotation ne : listNE) {
            FSArray concepts = ne.getOntologyConceptArr();
            if (concepts == null || concepts.size() <= 0) continue;
            listNonTrivialNE.add(ne);
            HashSet<String> conceptSenses = new HashSet<String>();
            listConcept.add(conceptSenses);
            for (int i = 0; i < concepts.size(); ++i) {
                String conceptId;
                if (concepts.get(i) == null || Strings.isNullOrEmpty((String)(conceptId = this.getConceptId(concepts.get(i))))) continue;
                conceptSenses.add(conceptId);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("listConcept: " + listConcept));
        }
        for (int i = 0; i < listConcept.size(); ++i) {
            Set conceptSenses = (Set)listConcept.get(i);
            if (conceptSenses.size() > 1) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("i: " + i + ", conceptSenses: " + conceptSenses));
                }
                HashMap scores = new HashMap();
                String concept = this.wsd.disambiguate(listConcept, i, null, this.windowSize, this.metric, scores, true);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("i: " + i + ", concept: " + concept));
                }
                IdentifiedAnnotation ne = (IdentifiedAnnotation)((Object)listNonTrivialNE.get(i));
                FSArray concepts = ne.getOntologyConceptArr();
                for (int j = 0; j < concepts.size(); ++j) {
                    OntologyConcept yoc = (OntologyConcept)concepts.get(j);
                    String conceptId = this.getConceptId((FeatureStructure)yoc);
                    if (concept == null || concept.equals(conceptId)) {
                        yoc.setDisambiguated(true);
                    }
                    if (!scores.containsKey(conceptId)) continue;
                    yoc.setScore((Double)scores.get(conceptId));
                }
                continue;
            }
            if (conceptSenses.size() != 1) continue;
            IdentifiedAnnotation ne = (IdentifiedAnnotation)((Object)listNonTrivialNE.get(i));
            FSArray concepts = ne.getOntologyConceptArr();
            OntologyConcept oc = (OntologyConcept)concepts.get(0);
            oc.setDisambiguated(true);
        }
    }
}

