/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.uima.resource;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import org.apache.ctakes.core.resource.JdbcConnectionResource;
import org.apache.ctakes.ytex.uima.ApplicationContextHolder;
import org.apache.log4j.Logger;
import org.apache.uima.resource.DataResource;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.SharedResourceObject;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;

public class InitableJdbcConnectionResourceImpl
implements JdbcConnectionResource,
SharedResourceObject {
    private Logger iv_logger = Logger.getLogger((String)this.getClass().getName());
    public static final String PARAM_DRIVER_CLASS = "DriverClassName";
    public static final String PARAM_URL = "URL";
    public static final String PARAM_USERNAME = "Username";
    public static final String PARAM_PASSWORD = "Password";
    public static final String PARAM_KEEP_ALIVE = "KeepConnectionAlive";
    public static final String PARAM_ISOLATION = "TransactionIsolation";
    private Connection iv_conn;

    public void load(DataResource dr) throws ResourceInitializationException {
        String password;
        String username;
        String urlStr;
        ConfigurationParameterSettings cps = dr.getMetaData().getConfigurationParameterSettings();
        Properties ytexProperties = ApplicationContextHolder.getYtexProperties();
        String driverClassName = (String)cps.getParameterValue(PARAM_DRIVER_CLASS);
        if (driverClassName == null) {
            driverClassName = ytexProperties.getProperty("db.driver");
        }
        if ((urlStr = (String)cps.getParameterValue(PARAM_URL)) == null) {
            urlStr = ytexProperties.getProperty("db.url");
        }
        if ((username = (String)cps.getParameterValue(PARAM_USERNAME)) == null) {
            username = ytexProperties.getProperty("db.username");
        }
        if ((password = (String)cps.getParameterValue(PARAM_PASSWORD)) == null) {
            password = ytexProperties.getProperty("db.password");
        }
        String isolationStr = (String)cps.getParameterValue(PARAM_ISOLATION);
        try {
            Class.forName(driverClassName);
            this.iv_conn = DriverManager.getConnection(urlStr, username, password);
            this.iv_logger.info((Object)("Connection established to: " + urlStr));
            if (isolationStr != null) {
                Class<?> connClass = Class.forName("java.sql.Connection");
                Field f = connClass.getField(isolationStr);
                int level = f.getInt(null);
                this.iv_logger.info((Object)("Connection transaction isolation level set: " + isolationStr + "(" + level + ")"));
                this.iv_conn.setTransactionIsolation(level);
            }
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public Connection getConnection() {
        return this.iv_conn;
    }
}

