/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.application;

import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.ViewExpiredException;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.PhaseId;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpSession;
import org.icefaces.application.SessionExpiredException;
import org.icefaces.util.EnvUtils;

public class ExtendedExceptionHandler
extends ExceptionHandlerWrapper {
    private ExceptionHandler wrapped;

    public ExtendedExceptionHandler(ExceptionHandler wrapped) {
        this.wrapped = wrapped;
    }

    public ExceptionHandler getWrapped() {
        return this.wrapped;
    }

    public boolean isListenerForSource(Object o) {
        return super.isListenerForSource(o);
    }

    public void handle() throws FacesException {
        boolean sessionExpired = false;
        Iterator iter = this.getUnhandledExceptionQueuedEvents().iterator();
        while (iter.hasNext()) {
            ExceptionQueuedEvent event = (ExceptionQueuedEvent)iter.next();
            ExceptionQueuedEventContext queueContext = (ExceptionQueuedEventContext)event.getSource();
            Throwable ex = queueContext.getException();
            if (!(ex instanceof ViewExpiredException) || !PhaseId.RESTORE_VIEW.equals(queueContext.getPhaseId())) continue;
            FacesContext fc = FacesContext.getCurrentInstance();
            if (this.isValidSession(fc)) {
                // empty if block
            }
            iter.remove();
            sessionExpired = true;
            break;
        }
        if (sessionExpired) {
            FacesContext fc = FacesContext.getCurrentInstance();
            Application app = fc.getApplication();
            if (app == null) {
                ApplicationFactory factory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
                app = factory.getApplication();
            }
            ExceptionQueuedEventContext ctxt = new ExceptionQueuedEventContext(fc, (Throwable)new SessionExpiredException("Session has expired"));
            app.publishEvent(fc, ExceptionQueuedEvent.class, (Object)ctxt);
        }
        this.getWrapped().handle();
    }

    private boolean isValidSession(FacesContext facesContext) {
        ExternalContext ec = facesContext.getExternalContext();
        Object sessObj = ec.getSession(false);
        if (sessObj == null) {
            return false;
        }
        boolean validSession = false;
        try {
            boolean newSession = false;
            long lastAccessed = 0L;
            long maxInactive = 0L;
            if (EnvUtils.instanceofPortletSession(sessObj)) {
                newSession = ((PortletSession)sessObj).isNew();
                lastAccessed = ((PortletSession)sessObj).getLastAccessedTime();
                maxInactive = ((PortletSession)sessObj).getMaxInactiveInterval();
            } else {
                newSession = ((HttpSession)sessObj).isNew();
                lastAccessed = ((HttpSession)sessObj).getLastAccessedTime();
                maxInactive = ((HttpSession)sessObj).getMaxInactiveInterval();
            }
            long now = System.currentTimeMillis();
            if (!newSession && System.currentTimeMillis() - lastAccessed <= maxInactive * 1000L) {
                validSession = true;
            }
        }
        catch (IllegalStateException ignored) {
            // empty catch block
        }
        return validSession;
    }
}

