/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.application;

import java.util.Map;
import java.util.logging.Logger;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpSession;
import org.icefaces.util.EnvUtils;

public class SessionTimeoutMonitor
extends ResourceHandlerWrapper {
    private static final Logger Log = Logger.getLogger(SessionTimeoutMonitor.class.getName());
    private ResourceHandler handler;

    public SessionTimeoutMonitor(ResourceHandler handler) {
        this.handler = handler;
    }

    public ResourceHandler getWrapped() {
        return this.handler;
    }

    public boolean isResourceRequest(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        Object session = externalContext.getSession(!context.getPartialViewContext().isAjaxRequest());
        if (session == null) {
            return false;
        }
        if (!EnvUtils.isStrictSessionTimeout(context)) {
            return this.handler.isResourceRequest(context);
        }
        Map sessionMap = externalContext.getSessionMap();
        Long lastAccessTime = (Long)sessionMap.get(SessionTimeoutMonitor.class.getName());
        boolean isPushRelatedRequest = EnvUtils.isPushRequest(context);
        if (lastAccessTime == null || !isPushRelatedRequest) {
            lastAccessTime = System.currentTimeMillis();
            sessionMap.put(SessionTimeoutMonitor.class.getName(), System.currentTimeMillis());
        }
        int maxInactiveInterval = EnvUtils.instanceofPortletSession(session) ? ((PortletSession)session).getMaxInactiveInterval() : ((HttpSession)session).getMaxInactiveInterval();
        if (System.currentTimeMillis() - lastAccessTime > (long)(maxInactiveInterval * 1000)) {
            sessionMap.remove(SessionTimeoutMonitor.class.getName());
            externalContext.invalidateSession();
        }
        return super.isResourceRequest(context);
    }
}

