/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.context;

import java.io.IOException;
import java.io.Writer;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;
import org.icefaces.impl.util.DOMUtils;

public class BasicResponseWriter
extends ResponseWriterWrapper {
    private Writer writer;
    boolean closeStart = false;
    private ResponseWriter wrapped;
    private String encoding;
    private String contentType;

    public BasicResponseWriter(Writer writer, String encoding, String contentType) {
        this.writer = writer;
        if (writer instanceof ResponseWriter) {
            this.wrapped = (ResponseWriter)writer;
        }
        this.encoding = encoding != null ? encoding : "UTF-8";
        this.contentType = contentType != null ? contentType : "text/html";
    }

    public ResponseWriter getWrapped() {
        return this.wrapped;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public void flush() throws IOException {
        this.closeStartIfNecessary();
        this.writer.flush();
    }

    public void startDocument() throws IOException {
    }

    public void endDocument() throws IOException {
    }

    public void startElement(String name, UIComponent component) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(60);
        this.writer.write(name);
        this.closeStart = true;
    }

    public void endElement(String name) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write("</");
        this.writer.write(name);
        this.writer.write(62);
    }

    public void startCDATA() throws IOException {
        this.closeStartIfNecessary();
        this.writer.write("<![CDATA[");
    }

    public void endCDATA() throws IOException {
        this.writer.write("]]>");
    }

    public void writeAttribute(String name, Object value, String componentPropertyName) throws IOException {
        this.writer.write(32);
        this.writer.write(name);
        this.writer.write("=\"");
        this.writer.write(DOMUtils.escapeAttribute(String.valueOf(value)));
        this.writer.write("\"");
    }

    public void writeURIAttribute(String name, Object value, String componentPropertyName) throws IOException {
        throw new UnsupportedOperationException("Implement writeURIAttribute");
    }

    public void writeComment(Object comment) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write("<!--");
        this.writer.write(comment.toString());
        this.writer.write("-->");
    }

    public void writeText(Object text, UIComponent component, String componentPropertyName) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(text.toString());
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        return new BasicResponseWriter(writer, this.getCharacterEncoding(), this.getContentType());
    }

    public void close() throws IOException {
        this.closeStartIfNecessary();
        this.writer.close();
    }

    public void write(char[] chars, int offset, int length) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(chars, offset, length);
    }

    public void write(String chars) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(chars);
    }

    private void closeStartIfNecessary() throws IOException {
        if (this.closeStart) {
            this.writer.write(62);
            this.closeStart = false;
        }
    }
}

