/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.sideeffect.cc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.sideeffect.type.SESentence;
import org.apache.ctakes.sideeffect.util.SEUtil;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.ProcessTrace;

public class SideEffectSentenceCasConsumer
extends CasConsumer_ImplBase {
    public static final String PARAM_OUTPUT_FILE = "OutputFile";
    public static final String PARAM_DELIMITER = "Delimiter";
    private BufferedWriter iv_bw = null;
    private String iv_delimiter;

    public void initialize() throws ResourceInitializationException {
        try {
            String filename = (String)this.getConfigParameterValue(PARAM_OUTPUT_FILE);
            File outFile = new File(filename);
            if (!outFile.exists()) {
                outFile.createNewFile();
            }
            this.iv_bw = new BufferedWriter(new FileWriter(outFile));
            this.iv_delimiter = (String)this.getConfigParameterValue(PARAM_DELIMITER);
        }
        catch (Exception ioe) {
            throw new ResourceInitializationException((Throwable)ioe);
        }
    }

    public void processCas(CAS cas) throws ResourceProcessException {
        try {
            JCas jcas = SEUtil.getJCasViewWithDefault(cas, "plaintext");
            JFSIndexRepository indexes = jcas.getJFSIndexRepository();
            String docName = DocumentIDAnnotationUtil.getDocumentID((JCas)jcas);
            for (SESentence ss : indexes.getAnnotationIndex(SESentence.type)) {
                String ssText = ss.getCoveredText().trim();
                String ssSpan = Integer.toString(ss.getBegin()) + ":" + Integer.toString(ss.getEnd());
                String output = docName + this.iv_delimiter + ssText + this.iv_delimiter + ssSpan;
                this.iv_bw.write(output + "\n");
            }
        }
        catch (Exception e) {
            throw new ResourceProcessException((Throwable)e);
        }
    }

    public void collectionProcessComplete(ProcessTrace arg0) throws ResourceProcessException, IOException {
        super.collectionProcessComplete(arg0);
        try {
            this.iv_bw.flush();
            this.iv_bw.close();
        }
        catch (Exception e) {
            throw new ResourceProcessException((Throwable)e);
        }
    }
}

