/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.preprocessor;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.ctakes.preprocessor.Annotation;
import org.apache.ctakes.preprocessor.DTDloader;
import org.apache.ctakes.preprocessor.DocumentMetaData;
import org.apache.ctakes.preprocessor.IntegerRange;
import org.apache.ctakes.preprocessor.PreProcessor;
import org.apache.ctakes.preprocessor.SegmentMetaData;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ClinicalNotePreProcessor
extends DefaultHandler
implements PreProcessor {
    private Logger iv_logger = Logger.getLogger((String)this.getClass().getName());
    public static final String MD_KEY_PATIENT_STREET_ADDR = "PATIENT_ADDR";
    public static final String MD_KEY_PATIENT_CITY = "PATIENT_CITY";
    public static final String MD_KEY_PATIENT_STATE = "PATIENT_STATE";
    public static final String MD_KEY_PATIENT_ZIP = "PATIENT_ZIP";
    public static final String MD_KEY_PATIENT_CNT = "PATIENT_CNT";
    public static final String MD_KEY_DOC_ID = "DOC_ID";
    public static final String MD_KEY_DOC_LINK_ID = "DOC_LINK_ID";
    public static final String MD_KEY_DOC_REVISION_ID = "DOC_REVISION_ID";
    public static final String MD_KEY_NOTE_DATE = "NOTE_DATE";
    public static final String MD_KEY_REV_DATE = "REV_DATE";
    public static final String MD_KEY_ADMIT_DATE = "ADMIT_DATE";
    public static final String MD_KEY_DISCHARGE_DATE = "DISCHARGE_DATE";
    public static final String MD_KEY_SERVICE_CODE = "SERVICE_CODE";
    public static final String MD_KEY_SITE_CODE = "SITE_CODE";
    public static final String MD_KEY_FACILITY_CODE = "FACILITY_CODE";
    public static final String MD_KEY_PT_BIRTH_DATE = "PT_BIRTH_DATE";
    public static final String MD_KEY_PT_HEIGHT = "PT_HEIGHT";
    public static final String MD_KEY_PT_WEIGHT = "PT_WEIGHT";
    public static final String MD_KEY_PT_HEAD_CIRCUMFERENCE = "PT_HEAD_CIRCUMFERENCE";
    public static final String MD_KEY_PT_GENDER = "PT_GENDER";
    public static final String MD_KEY_PT_BMI = "PT_BMI";
    public static final String MD_KEY_PT_BSA = "PT_BSA";
    public static final String MD_KEY_PT_TEMPERATURE = "PT_TEMPERATURE";
    public static final String MD_KEY_PT_BILLING_CODE = "PT_BILLING_CODE";
    public static final String MD_KEY_PT_RESPIRATORY_RATE = "PT_RESPIRATORY_RATE";
    public static final String MD_KEY_EVENT_TYPE_CODE = "EVENT_TYPE_CODE";
    public static final String MD_KEY_DOC_CONFIDENTIAL_IND = "DOC_CONFIDENTIAL_IND";
    public static final String MD_KEY_DOC_STATUS_CODE = "DOC_STATUS_CODE";
    public static final String MD_KEY_HISTORY_SECTION = "HISTORY_SECTION";
    public static final String MD_KEY_LOCATION = "LOCATION";
    public static final String MD_KEY_MINUTES_COUNSELING = "MINUTES_COUNSELING";
    public static final String MD_KEY_TOTAL_TIME = "TOTAL_TIME";
    public static final String MD_KEY_PROVIDER_ID = "PROVIDER_ID";
    public static final String MD_KEY_PROVIDER2_ID = "PROVIDER2_ID";
    public static final String MD_KEY_SIGNATURE_ID = "SIGNATURE_ID";
    public static final String MD_KEY_SIGNATURE_DATE = "SIGNATURE_DATE";
    public static final String MD_KEY_TRANSCRIBER_ID = "TRANSCRIBER_ID";
    public static final String MD_KEY_TRANSCRIPTION_DATE = "TRANSCRIPTION_DATE";
    public static final String MD_KEY_CUSTOMER_ID = "CLINICAL_NUMBER";
    private DocumentMetaData iv_docMetaData;
    private boolean iv_insideHeader = false;
    private boolean iv_insideAdminData = false;
    private boolean iv_insideTranscriptionist = false;
    private boolean iv_insidePatient = false;
    private boolean iv_insideKnownBy = false;
    private boolean iv_insidePatientEncounter = false;
    private boolean iv_insideLegalAuth = false;
    private boolean iv_insideProvider = false;
    private boolean iv_foundProvider1 = false;
    private boolean iv_insideServiceLoc = false;
    private boolean iv_isHospitalSummary = false;
    private int iv_sectionStartOffset;
    private String iv_sectionIdentifier;
    private int iv_sectionNestingLevel = 0;
    private boolean iv_insideSection = false;
    private boolean iv_insideCaption = false;
    public static final int UNKNOWN_TABLE_TYPE = 0;
    private boolean iv_insideTable = false;
    private boolean iv_insideTableRow = false;
    private boolean iv_insideTableHeader = false;
    private boolean iv_insideTableData = false;
    private String iv_tableHeaderKeyID = null;
    private int iv_tdStartOffset;
    private int iv_tdCounter = 0;
    private boolean iv_insideExamComponent = false;
    private int iv_examComponentTableDataCnt = 0;
    private StringBuffer iv_examComponentText = null;
    private List iv_headerList = new ArrayList();
    private XMLReader iv_xmlParser;
    private StringBuffer iv_sectionText = new StringBuffer();
    private StringBuffer iv_text = new StringBuffer();
    private boolean iv_includeSectionMarkers;
    private String iv_previousElement = null;
    private StringBuffer iv_contiguousTextBuffer = new StringBuffer();

    public ClinicalNotePreProcessor(InputStream dtdFile, boolean includeSectionMarkers) throws SAXException, FileNotFoundException {
        this.iv_includeSectionMarkers = includeSectionMarkers;
        this.iv_xmlParser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        this.iv_xmlParser.setContentHandler(this);
        DTDloader eResolver = new DTDloader(dtdFile);
        this.iv_xmlParser.setEntityResolver(eResolver);
    }

    @Override
    public DocumentMetaData process(String xml) throws Exception {
        this.iv_docMetaData = new DocumentMetaData();
        InputSource input = new InputSource(new StringReader(xml));
        this.iv_xmlParser.parse(input);
        return this.iv_docMetaData;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.iv_contiguousTextBuffer.length() > 0) {
            this.newTextNode();
        }
        if (!this.iv_insideHeader && localName.equals("clinical_document_header")) {
            this.iv_insideHeader = true;
        } else if (localName.equals("is_known_by")) {
            this.iv_insideKnownBy = true;
        } else if (this.iv_insideHeader && localName.equals("origination_dttm")) {
            revDate = attributes.getValue("V");
            if (revDate.length() > 0) {
                try {
                    timeInMillis = this.convertTime(revDate);
                    this.iv_docMetaData.addMetaData("REV_DATE", String.valueOf(timeInMillis));
                }
                catch (Exception e) {
                    this.iv_logger.warn((Object)("REV_DATE invalid:" + revDate));
                }
            }
        } else if (localName.equals("section")) {
            ++this.iv_sectionNestingLevel;
            if (!this.iv_insideSection) {
                this.iv_insideSection = true;
                this.iv_sectionText = new StringBuffer();
                this.iv_sectionStartOffset = this.iv_text.length();
            }
        } else if (this.iv_insideSection && localName.equals("caption")) {
            this.iv_insideCaption = true;
        } else if (this.iv_insideSection && localName.equals("caption_cd")) {
            if (!this.iv_insideTable || this.iv_previousElement.equals("caption")) {
                // empty if block
            }
            if (this.iv_sectionIdentifier == null) {
                this.iv_sectionIdentifier = attributes.getValue("V");
            }
            if (this.iv_insideTableHeader) {
                this.iv_tableHeaderKeyID = attributes.getValue("V");
            }
        } else if (this.iv_insideSection && localName.equals("table")) {
            this.iv_insideTable = true;
        } else if (this.iv_insideTable && localName.equals("tr")) {
            this.iv_insideTableRow = true;
            this.iv_tdCounter = 0;
        } else if (this.iv_insideTableRow && localName.equals("th")) {
            this.iv_insideTableHeader = true;
        } else if (this.iv_insideTableRow && localName.equals("td")) {
            this.iv_insideTableData = true;
            this.compress(this.iv_sectionText);
            this.iv_tdStartOffset = this.iv_text.length() + this.iv_sectionText.length();
        } else if (!(this.iv_insideTableHeader && localName.equals("activity_tmr") || this.iv_insideTableData && localName.equals("coded_entry.value"))) {
            if (this.iv_insideTableData && localName.equals("value")) {
                if (this.iv_tableHeaderKeyID != null) {
                    value = attributes.getValue("V");
                    if (this.iv_sectionIdentifier.equals("20114")) {
                        if (this.iv_tableHeaderKeyID.equals("30004")) {
                            this.iv_docMetaData.addMetaData("PT_BILLING_CODE", value);
                        } else if (this.iv_tableHeaderKeyID.equals("30005")) {
                            this.iv_docMetaData.addMetaData("TOTAL_TIME", value);
                        } else if (this.iv_tableHeaderKeyID.equals("30006")) {
                            this.iv_docMetaData.addMetaData("MINUTES_COUNSELING", value);
                        }
                    }
                }
            } else if (this.iv_insideHeader) {
                if (localName.equals("cn1_admin_data")) {
                    this.iv_insideAdminData = true;
                } else if (localName.equals("transcriptionist")) {
                    this.iv_insideTranscriptionist = true;
                } else if (localName.equals("patient")) {
                    this.iv_insidePatient = true;
                } else if (localName.equals("patient_encounter")) {
                    this.iv_insidePatientEncounter = true;
                } else if (localName.equals("legal_authenticator")) {
                    this.iv_insideLegalAuth = true;
                } else if (localName.equals("provider")) {
                    this.iv_insideProvider = true;
                } else if (localName.equals("service_location")) {
                    this.iv_insideServiceLoc = true;
                } else if (localName.equals("document_type_cd")) {
                    if (attributes.getValue("V").equals("2025539")) {
                        this.iv_isHospitalSummary = true;
                    }
                } else if (this.iv_previousElement != null && this.iv_previousElement.equals("clinical_document_header") && localName.equals("id")) {
                    docID = attributes.getValue("EX");
                    if (docID != null && docID.length() > 0 && docID.indexOf(35) == -1) {
                        this.iv_docMetaData.addMetaData("DOC_ID", docID);
                    }
                } else if (localName.equals("set_id")) {
                    docLinkID = attributes.getValue("EX");
                    if (docLinkID != null && docLinkID.length() > 0 && docLinkID.indexOf(35) == -1) {
                        this.iv_docMetaData.addMetaData("DOC_LINK_ID", docLinkID);
                    }
                } else if (localName.equals("version_nbr")) {
                    revisionID = attributes.getValue("V");
                    if (revisionID != null && revisionID.length() > 0 && revisionID.indexOf(35) == -1) {
                        this.iv_docMetaData.addMetaData("DOC_REVISION_ID", revisionID);
                    }
                } else if (this.iv_insideAdminData && localName.equals("cn1_discharge_date")) {
                    dischargeDate = attributes.getValue("V");
                    if (dischargeDate != null && (dischargeDate.length() == 8 || dischargeDate.length() == 15)) {
                        try {
                            admitTimeInMillis = this.convertTime(dischargeDate);
                            this.iv_docMetaData.addMetaData("DISCHARGE_DATE", String.valueOf(admitTimeInMillis));
                        }
                        catch (Exception e) {
                            this.iv_logger.warn((Object)("DISCHARGE_DATE invalid:" + dischargeDate));
                        }
                    }
                } else if (this.iv_insideAdminData && localName.equals("cn1_status_cd")) {
                    statusCode = attributes.getValue("V");
                    this.iv_docMetaData.addMetaData("DOC_STATUS_CODE", statusCode);
                } else if (this.iv_insideAdminData && localName.equals("cn1_service_cd")) {
                    serviceCode = attributes.getValue("V");
                    this.iv_docMetaData.addMetaData("SERVICE_CODE", serviceCode);
                } else if (this.iv_insideAdminData && localName.equals("cn1_event_cd")) {
                    eventCode = attributes.getValue("V");
                    this.iv_docMetaData.addMetaData("EVENT_TYPE_CODE", eventCode);
                } else if (this.iv_insideAdminData && localName.equals("cn1_document_id")) {
                    docID = attributes.getValue("EX");
                    this.iv_docMetaData.addMetaData("DOC_ID", docID);
                    this.iv_docMetaData.addMetaData("DOC_LINK_ID", docID);
                } else if (this.iv_insideAdminData && localName.equals("cn1_revision_nbr")) {
                    revisionID = attributes.getValue("V");
                    this.iv_docMetaData.addMetaData("DOC_REVISION_ID", revisionID);
                } else if (this.iv_insideAdminData && localName.equals("cn1_site_cd")) {
                    siteCode = attributes.getValue("V");
                    this.iv_docMetaData.addMetaData("SITE_CODE", siteCode);
                } else if (this.iv_insideTranscriptionist) {
                    if (localName.equals("id")) {
                        transcriberID = attributes.getValue("EX");
                        this.iv_docMetaData.addMetaData("TRANSCRIBER_ID", transcriberID);
                    } else if (localName.equals("participation_tmr") && (transcriptionDate = attributes.getValue("V")).length() > 0) {
                        try {
                            timeInMillis = this.convertTime(transcriptionDate);
                            this.iv_docMetaData.addMetaData("TRANSCRIPTION_DATE", String.valueOf(timeInMillis));
                        }
                        catch (Exception e) {
                            this.iv_logger.warn((Object)("TRANSCRIPTION_DATE invalid:" + transcriptionDate));
                        }
                    }
                } else if (this.iv_insidePatient) {
                    if (localName.equals("LIT")) {
                        streetAddr = attributes.getValue("V");
                        this.iv_docMetaData.addMetaData("PATIENT_ADDR", streetAddr);
                    } else if (localName.equals("CTY")) {
                        city = attributes.getValue("V");
                        this.iv_docMetaData.addMetaData("PATIENT_CITY", city);
                    } else if (localName.equals("STA")) {
                        state = attributes.getValue("V");
                        this.iv_docMetaData.addMetaData("PATIENT_STATE", state);
                    } else if (localName.equals("ZIP")) {
                        zip = attributes.getValue("V");
                        this.iv_docMetaData.addMetaData("PATIENT_ZIP", zip);
                    } else if (localName.equals("CNT")) {
                        cnt = attributes.getValue("V");
                        this.iv_docMetaData.addMetaData("PATIENT_CNT", cnt);
                    } else if (localName.equals("administrative_gender_cd")) {
                        ptGender = attributes.getValue("V");
                        this.iv_docMetaData.addMetaData("PT_GENDER", ptGender);
                    } else if (localName.equals("birth_dttm")) {
                        birthDttm = attributes.getValue("V");
                        try {
                            birthTimeInMillis = this.convertTime(birthDttm);
                            this.iv_docMetaData.addMetaData("PT_BIRTH_DATE", String.valueOf(birthTimeInMillis));
                        }
                        catch (Exception e) {
                            this.iv_logger.warn((Object)("PT_BIRTH_DATE invalid:" + birthDttm));
                        }
                    } else if (this.iv_insideKnownBy && localName.equals("id") && this.iv_previousElement.compareTo("is_known_by") == 0) {
                        clinicalNumber = attributes.getValue("EX");
                        this.iv_docMetaData.addMetaData("CLINICAL_NUMBER", clinicalNumber.replaceAll("-", ""));
                    }
                } else if (this.iv_insideLegalAuth) {
                    if (localName.equals("id")) {
                        signatureID = attributes.getValue("EX");
                        this.iv_docMetaData.addMetaData("SIGNATURE_ID", signatureID);
                    } else if (localName.equals("participation_tmr") && (signatureDate = attributes.getValue("V")).length() > 0) {
                        try {
                            timeInMillis = this.convertTime(signatureDate);
                            this.iv_docMetaData.addMetaData("SIGNATURE_DATE", String.valueOf(timeInMillis));
                        }
                        catch (Exception e) {
                            this.iv_logger.warn((Object)("SIGNATURE_DATE invalid:" + signatureDate));
                        }
                    }
                } else if (this.iv_insideProvider) {
                    if (localName.equals("id")) {
                        if (!this.iv_foundProvider1) {
                            providerID = attributes.getValue("EX");
                            this.iv_docMetaData.addMetaData("PROVIDER_ID", providerID);
                            this.iv_foundProvider1 = true;
                        } else {
                            provider2ID = attributes.getValue("EX");
                            this.iv_docMetaData.addMetaData("PROVIDER2_ID", provider2ID);
                        }
                    }
                } else if (this.iv_insidePatientEncounter) {
                    if (localName.equals("organization.nm")) {
                        facilityCode = attributes.getValue("V");
                        this.iv_docMetaData.addMetaData("FACILITY_CODE", facilityCode);
                    } else if (localName.equals("encounter_tmr") && (noteDate = attributes.getValue("V")).length() > 0) {
                        try {
                            if (this.iv_isHospitalSummary) {
                                if (noteDate.length() == 8 || noteDate.length() == 15) {
                                    admitTimeInMillis = this.convertTime(noteDate);
                                    this.iv_docMetaData.addMetaData("ADMIT_DATE", String.valueOf(admitTimeInMillis));
                                    this.iv_docMetaData.addMetaData("NOTE_DATE", String.valueOf(admitTimeInMillis));
                                }
                                if (noteDate.length() != 17) ** GOTO lbl266
                                admitDate = noteDate.substring(0, 8);
                                dischargeDate = noteDate.substring(9, 17);
                                admitTimeInMillis = this.convertTime(admitDate);
                                dischargeTimeInMillis = this.convertTime(dischargeDate);
                                this.iv_docMetaData.addMetaData("ADMIT_DATE", String.valueOf(admitTimeInMillis));
                                this.iv_docMetaData.addMetaData("DISCHARGE_DATE", String.valueOf(dischargeTimeInMillis));
                                this.iv_docMetaData.addMetaData("NOTE_DATE", String.valueOf(admitTimeInMillis));
                            }
                            timeInMillis = this.convertTime(noteDate);
                            this.iv_docMetaData.addMetaData("NOTE_DATE", String.valueOf(timeInMillis));
                        }
                        catch (Exception e) {
                            throw new SAXException(e);
                        }
                    }
                } else if (this.iv_insideServiceLoc && localName.equals("id")) {
                    location = attributes.getValue("EX");
                    this.iv_docMetaData.addMetaData("LOCATION", location);
                } else if (localName.equals("confidentiality_cd")) {
                    confidentialCode = attributes.getValue("V");
                    this.iv_docMetaData.addMetaData("DOC_CONFIDENTIAL_IND", confidentialCode);
                } else if (localName.equals("administrative_gender_cd")) {
                    ptGender = attributes.getValue("V");
                    this.iv_docMetaData.addMetaData("PT_GENDER", ptGender);
                } else if (localName.equals("birth_dttm")) {
                    birthDttm = attributes.getValue("V");
                    try {
                        birthTimeInMillis = this.convertTime(birthDttm);
                        this.iv_docMetaData.addMetaData("PT_BIRTH_DATE", String.valueOf(birthTimeInMillis));
                    }
                    catch (Exception e) {
                        this.iv_logger.warn((Object)("PT_BIRTH_DATE invalid:" + birthDttm));
                    }
                }
            }
        }
lbl266:
        // 68 sources

        this.iv_previousElement = localName;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (length > 0 && !this.iv_insideTableHeader) {
            this.iv_contiguousTextBuffer.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.iv_contiguousTextBuffer.length() > 0) {
            this.newTextNode();
        }
        if (this.iv_insideHeader) {
            if (localName.equals("clinical_document_header")) {
                this.iv_insideHeader = false;
            } else if (this.iv_insideAdminData && localName.equals("cn1_admin_data")) {
                this.iv_insideAdminData = false;
            } else if (this.iv_insideTranscriptionist && localName.equals("transcriptionist")) {
                this.iv_insideTranscriptionist = false;
            } else if (this.iv_insidePatientEncounter && localName.equals("patient_encounter")) {
                this.iv_insidePatientEncounter = false;
            } else if (this.iv_insideLegalAuth && localName.equals("legal_authenticator")) {
                this.iv_insideLegalAuth = false;
            } else if (localName.equals("provider")) {
                this.iv_insideProvider = false;
            } else if (localName.equals("service_location")) {
                this.iv_insideServiceLoc = false;
            }
        } else if (localName.equals("paragraph")) {
            this.iv_sectionText.append('\n');
        } else if (this.iv_insideSection && localName.equals("section")) {
            --this.iv_sectionNestingLevel;
            if (this.iv_sectionNestingLevel == 0) {
                if (this.iv_sectionText.toString().trim().length() > 0) {
                    String sectionStartMarker = this.getSectionStartMarker(this.iv_sectionIdentifier);
                    this.iv_text.append(sectionStartMarker);
                    this.iv_text.append('\n');
                    this.iv_text.append('\n');
                    if (!this.iv_includeSectionMarkers) {
                        this.iv_sectionStartOffset = this.iv_text.length();
                    }
                    this.iv_text.append(this.compress(this.iv_sectionText));
                    SegmentMetaData smd = new SegmentMetaData();
                    IntegerRange span = new IntegerRange();
                    span.start = this.iv_sectionStartOffset;
                    span.end = this.iv_text.length();
                    smd.span = span;
                    smd.id = this.iv_sectionIdentifier;
                    this.iv_docMetaData.addSegment(smd);
                    String sectionEndMarker = this.getSectionEndMarker(this.iv_sectionIdentifier);
                    this.iv_text.append('\n');
                    this.iv_text.append(sectionEndMarker);
                    this.iv_text.append('\n');
                    this.iv_text.append('\n');
                }
                this.iv_insideSection = false;
                this.iv_sectionIdentifier = null;
                this.iv_sectionText = null;
            }
        } else if (this.iv_insideCaption && localName.equals("caption")) {
            this.iv_insideCaption = false;
        } else if (this.iv_insideTable && localName.equals("table")) {
            this.iv_tdCounter = 0;
            this.iv_headerList.clear();
            this.iv_insideTable = false;
        } else if (this.iv_insideTableRow && localName.equals("tr")) {
            this.iv_examComponentText = null;
            this.iv_insideExamComponent = false;
            this.iv_examComponentTableDataCnt = 0;
            this.iv_insideTableRow = false;
            this.iv_tableHeaderKeyID = null;
            this.iv_sectionText.append('\n');
        } else if (this.iv_insideTableRow && localName.equals("th")) {
            this.iv_insideTableHeader = false;
        } else if (this.iv_insideTableRow && localName.equals("td")) {
            if (this.iv_tdCounter < this.iv_headerList.size()) {
                String thText = (String)this.iv_headerList.get(this.iv_tdCounter);
                Annotation a = new Annotation();
                a.iv_type = thText;
                a.startOffset = this.iv_tdStartOffset;
                this.compress(this.iv_sectionText);
                a.endOffset = this.iv_text.length() + this.iv_sectionText.length();
                this.iv_docMetaData.addAnnotation(a);
            }
            this.iv_insideTableData = false;
            this.iv_sectionText.append(' ');
            ++this.iv_tdCounter;
        } else if (this.iv_insideTableRow && localName.equals("br")) {
            this.iv_sectionText.append('\n');
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.iv_insideTable = false;
        this.iv_insideTableRow = false;
        this.iv_insideTableHeader = false;
        this.iv_insideTableData = false;
        this.iv_tdCounter = 0;
        this.iv_headerList.clear();
        this.iv_insideHeader = false;
        this.iv_insideAdminData = false;
        this.iv_insideTranscriptionist = false;
        this.iv_insidePatientEncounter = false;
        this.iv_insideLegalAuth = false;
        this.iv_insideProvider = false;
        this.iv_insideServiceLoc = false;
        this.iv_tableHeaderKeyID = null;
        this.iv_examComponentText = null;
        this.iv_insideExamComponent = false;
        this.iv_isHospitalSummary = false;
        this.iv_previousElement = null;
    }

    @Override
    public void endDocument() throws SAXException {
        this.replaceNonAsciiChars(this.iv_text, ' ');
        this.iv_docMetaData.setText(this.iv_text.toString());
        if (this.iv_logger.isDebugEnabled()) {
            String docID = (String)this.iv_docMetaData.getMetaData().get(MD_KEY_DOC_ID);
            this.iv_logger.debug((Object)("Finished processing document id=" + docID));
        }
    }

    private void newTextNode() {
        String text = this.iv_contiguousTextBuffer.toString().trim();
        if (this.iv_insideTableHeader) {
            this.iv_headerList.add(text);
            this.iv_sectionText.append(text);
        } else if (this.iv_insideExamComponent) {
            if (this.iv_examComponentTableDataCnt == 1) {
                this.iv_examComponentText.append(text);
            }
            ++this.iv_examComponentTableDataCnt;
        } else if (this.iv_insideSection && !this.iv_insideCaption) {
            this.iv_sectionText.append(text);
        }
        if (!this.iv_insideTableData || this.iv_tableHeaderKeyID != null) {
            // empty if block
        }
        this.iv_contiguousTextBuffer.setLength(0);
    }

    private String getSectionStartMarker(String id) {
        StringBuffer sb = new StringBuffer();
        sb.append("[start section id=\"");
        sb.append(id);
        sb.append("\"]");
        return sb.toString();
    }

    private String getSectionEndMarker(String id) {
        StringBuffer sb = new StringBuffer();
        sb.append("[end section id=\"");
        sb.append(id);
        sb.append("\"]");
        return sb.toString();
    }

    private String compress(StringBuffer sb) {
        StringBuffer compressedSB = new StringBuffer();
        if (sb == null) {
            return compressedSB.toString();
        }
        int indexOfLastNewline = 0;
        for (int i = 0; i < sb.length(); ++i) {
            String lineText;
            String compressedText;
            char currentChar = sb.charAt(i);
            if (currentChar != '\n') continue;
            if (i - indexOfLastNewline > 1 && (compressedText = (lineText = sb.substring(indexOfLastNewline, i)).trim()).length() > 0) {
                compressedSB.append(compressedText);
                compressedSB.append('\n');
            }
            indexOfLastNewline = i;
        }
        if (indexOfLastNewline < sb.length()) {
            String lineText = sb.substring(indexOfLastNewline, sb.length());
            String compressedText = lineText.trim();
            compressedSB.append(compressedText);
        }
        return compressedSB.toString();
    }

    private long convertTime(String drmStr) throws Exception {
        int tIndex = drmStr.indexOf(84);
        String dateStr = null;
        String timeStr = null;
        if (tIndex != -1) {
            dateStr = drmStr.substring(0, tIndex);
            timeStr = drmStr.substring(tIndex + 1, drmStr.length());
        } else {
            dateStr = drmStr;
        }
        try {
            if (dateStr.length() == 8) {
                int year = Integer.parseInt(dateStr.substring(0, 4));
                int month = Integer.parseInt(dateStr.substring(4, 6));
                int day = Integer.parseInt(dateStr.substring(6, 8));
                GregorianCalendar c = new GregorianCalendar();
                c.clear();
                int hours = 0;
                int minutes = 0;
                int seconds = 0;
                if (timeStr != null) {
                    if (timeStr.length() >= 4) {
                        hours = Integer.parseInt(timeStr.substring(0, 2));
                        minutes = Integer.parseInt(timeStr.substring(2, 4));
                    }
                    if (timeStr.length() == 6) {
                        seconds = Integer.parseInt(timeStr.substring(4, 6));
                    }
                }
                c.set(year, month - 1, day, hours, minutes, seconds);
                return c.getTime().getTime();
            }
            throw new Exception();
        }
        catch (Exception e) {
            throw new Exception("Invalid DRM. date=" + dateStr + " time=" + timeStr);
        }
    }

    private void replaceNonAsciiChars(StringBuffer sb, char replacementChar) {
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (c <= '\u007f') continue;
            sb.setCharAt(i, replacementChar);
        }
    }
}

