/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.corpus.penntreebank;

import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.StringArrayFS;
import org.apache.uima.fit.util.FSCollectionFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.StringArray;
import org.cleartk.syntax.constituent.type.TerminalTreebankNode;
import org.cleartk.syntax.constituent.type.TopTreebankNode;
import org.cleartk.syntax.constituent.type.TreebankNode;

@Beta
public class TreebankNodeConverter {
    public static TopTreebankNode convert(org.cleartk.util.treebank.TopTreebankNode pojoNode, JCas jCas, boolean addToIndexes) {
        TopTreebankNode uimaNode = new TopTreebankNode(jCas, pojoNode.getTextBegin(), pojoNode.getTextEnd());
        TreebankNodeConverter.convert((org.cleartk.util.treebank.TreebankNode)pojoNode, jCas, (TreebankNode)uimaNode, null, addToIndexes);
        uimaNode.setTreebankParse(pojoNode.getTreebankParse());
        TreebankNodeConverter.initTerminalNodes(uimaNode, jCas);
        if (addToIndexes) {
            uimaNode.addToIndexes();
        }
        return uimaNode;
    }

    public static void initTerminalNodes(TopTreebankNode uimaNode, JCas jCas) {
        ArrayList<TerminalTreebankNode> terminals = new ArrayList<TerminalTreebankNode>();
        TreebankNodeConverter._initTerminalNodes((TreebankNode)uimaNode, terminals);
        for (int i = 0; i < terminals.size(); ++i) {
            TerminalTreebankNode terminal = (TerminalTreebankNode)terminals.get(i);
            terminal.setIndex(i);
        }
        FSArray terminalsFSArray = new FSArray(jCas, terminals.size());
        terminalsFSArray.copyFromArray(terminals.toArray(new FeatureStructure[terminals.size()]), 0, 0, terminals.size());
        uimaNode.setTerminals(terminalsFSArray);
    }

    private static void _initTerminalNodes(TreebankNode node, List<TerminalTreebankNode> terminals) {
        FSArray children = node.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            TreebankNode child = (TreebankNode)children.get(i);
            if (child instanceof TerminalTreebankNode) {
                terminals.add((TerminalTreebankNode)child);
                continue;
            }
            TreebankNodeConverter._initTerminalNodes(child, terminals);
        }
    }

    public static TreebankNode convert(org.cleartk.util.treebank.TreebankNode pojoNode, JCas jCas, TreebankNode uimaNode, TreebankNode parentNode, boolean addToIndexes) {
        uimaNode.setNodeType(pojoNode.getType());
        StringArray nodeTags = (StringArray)FSCollectionFactory.fillArrayFS((StringArrayFS)new StringArray(jCas, pojoNode.getTags().length), (String[])pojoNode.getTags());
        uimaNode.setNodeTags(nodeTags);
        uimaNode.setNodeValue(pojoNode.getValue());
        uimaNode.setLeaf(pojoNode.isLeaf());
        uimaNode.setParent(parentNode);
        ArrayList<TreebankNode> uimaChildren = new ArrayList<TreebankNode>();
        for (org.cleartk.util.treebank.TreebankNode child : pojoNode.getChildren()) {
            Object childNode = child.isLeaf() ? new TerminalTreebankNode(jCas, child.getTextBegin(), child.getTextEnd()) : new TreebankNode(jCas, child.getTextBegin(), child.getTextEnd());
            uimaChildren.add(TreebankNodeConverter.convert(child, jCas, (TreebankNode)childNode, uimaNode, addToIndexes));
            if (!addToIndexes) continue;
            childNode.addToIndexes();
        }
        FSArray uimaChildrenFSArray = new FSArray(jCas, uimaChildren.size());
        uimaChildrenFSArray.copyFromArray(uimaChildren.toArray(new FeatureStructure[uimaChildren.size()]), 0, 0, uimaChildren.size());
        uimaNode.setChildren(uimaChildrenFSArray);
        return uimaNode;
    }
}

