/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.corpus.propbank;

import java.io.File;
import java.util.Collection;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.srl.type.Argument;
import org.cleartk.srl.type.Predicate;
import org.cleartk.srl.type.SemanticArgument;
import org.cleartk.token.type.Sentence;
import org.cleartk.util.ViewUriUtil;
import org.cleartk.util.ae.linewriter.AnnotationWriter;

public class PropbankFormatWriter
implements AnnotationWriter<Predicate> {
    public void initialize(UimaContext context) throws ResourceInitializationException {
    }

    public String writeAnnotation(JCas jCas, Predicate predicate) throws AnalysisEngineProcessException {
        StringBuilder sb = new StringBuilder();
        String uri = new File(ViewUriUtil.getURI((JCas)jCas)).getPath();
        sb.append(uri + "\t");
        int sentenceId = -1;
        int i = 0;
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            if (JCasUtil.selectCovered((JCas)jCas, Predicate.class, (AnnotationFS)sentence).contains(predicate)) {
                sentenceId = i;
            }
            ++i;
        }
        String treeId = Integer.toString(sentenceId);
        sb.append(treeId + "\t");
        String frameSetId = predicate.getBaseForm() + "." + predicate.getFrameSet();
        sb.append(frameSetId + "\t");
        Collection arguments = JCasUtil.select((FSArray)predicate.getArguments(), Argument.class);
        for (Argument argument : arguments) {
            if (!(argument instanceof SemanticArgument)) continue;
            sb.append(((SemanticArgument)argument).getPropTxt() + "\t");
        }
        return sb.toString();
    }
}

