/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.corpus.propbank;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.component.JCasCollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.SofaCapability;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;
import org.cleartk.corpus.penntreebank.ListSpecification;
import org.cleartk.corpus.penntreebank.PennTreebankReader;
import org.cleartk.corpus.propbank.util.Propbank;
import org.cleartk.util.CleartkInitializationException;
import org.cleartk.util.ViewUriUtil;

@SofaCapability(outputSofas={"PROPBANK_VIEW", "TREEBANK_VIEW", "UriView"})
public class PropbankGoldReader
extends JCasCollectionReader_ImplBase {
    public static final String PARAM_PROPBANK_FILE_NAME = "propbankFileName";
    @ConfigurationParameter(name="propbankFileName", description="points to propbank data file", mandatory=true)
    private String propbankFileName;
    public static final String PARAM_PENNTREEBANK_DIRECTORY_NAME = "penntreebankDirectoryName";
    private static final String PENN_TREEBANK_DIRECTORY_DESCRIPTION = "points to the PennTreebank corpus. The directory should contain subdirectories corresponding to the sections (e.g. \"00\", \"01\", etc.)  That is, if a local copy of PennTreebank sits at C:/Data/PTB/wsj/mrg, then the subdirectory C:/Data/PTB/wsj/mrg/00 should exist. There are 24 sections in PTB corresponding to the directories 00, 01, 02, ... 24.";
    @ConfigurationParameter(name="penntreebankDirectoryName", description="points to the PennTreebank corpus. The directory should contain subdirectories corresponding to the sections (e.g. \"00\", \"01\", etc.)  That is, if a local copy of PennTreebank sits at C:/Data/PTB/wsj/mrg, then the subdirectory C:/Data/PTB/wsj/mrg/00 should exist. There are 24 sections in PTB corresponding to the directories 00, 01, 02, ... 24.", mandatory=true)
    private String penntreebankDirectoryName;
    public static final String PARAM_WSJ_SECTIONS = "wsjSections";
    @ConfigurationParameter(name="wsjSections", description="Determines which sections of WSJ will be used.  The format allows for comma-separated section numbers and section ranges, for example \"02,07-12,16\".", mandatory=true)
    private String wsjSections;
    protected LinkedList<String> propbankData;
    protected File treebankDirectory;
    protected LinkedList<File> treebankFiles;
    protected int totalTreebankFiles = 0;
    protected ListSpecification wsjSpecification;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(UimaContext context) throws ResourceInitializationException {
        try {
            this.wsjSpecification = new ListSpecification(this.wsjSections);
            File propbankFile = new File(this.propbankFileName);
            if (!propbankFile.exists()) {
                throw CleartkInitializationException.fileNotFound((File)propbankFile);
            }
            try (BufferedReader reader = new BufferedReader(new FileReader(propbankFile));){
                String line;
                this.propbankData = new LinkedList();
                while ((line = reader.readLine()) != null) {
                    this.propbankData.add(line);
                }
            }
            Collections.sort(this.propbankData);
            this.treebankFiles = new LinkedList();
            this.treebankDirectory = new File(this.penntreebankDirectoryName);
            File wsjDirectory = new File(this.treebankDirectory, "wsj");
            if (!wsjDirectory.exists()) {
                throw CleartkInitializationException.fileNotFound((File)wsjDirectory);
            }
            PennTreebankReader.collectSections(wsjDirectory, this.treebankFiles, this.wsjSpecification);
            Collections.sort(this.treebankFiles);
            this.totalTreebankFiles = this.treebankFiles.size();
        }
        catch (FileNotFoundException fnfe) {
            throw new ResourceInitializationException((Throwable)fnfe);
        }
        catch (IOException ioe) {
            throw new ResourceInitializationException((Throwable)ioe);
        }
    }

    public void getNext(JCas jCas) throws IOException, CollectionException {
        JCas pbView;
        JCas tbView;
        try {
            tbView = jCas.createView("TREEBANK_VIEW");
            pbView = jCas.createView("PROPBANK_VIEW");
        }
        catch (CASException ce) {
            throw new CollectionException((Throwable)ce);
        }
        File treebankFile = this.treebankFiles.removeFirst();
        ViewUriUtil.setURI((JCas)jCas, (URI)treebankFile.toURI());
        StringBuffer propbankText = new StringBuffer();
        while (this.propbankData.size() > 0) {
            File nextPbFile = new File(this.treebankDirectory.getPath() + File.separator + Propbank.filenameFromString(this.propbankData.getFirst())).getCanonicalFile();
            int c = treebankFile.getCanonicalFile().compareTo(nextPbFile);
            if (c < 0) break;
            if (c > 0) {
                this.propbankData.removeFirst();
                continue;
            }
            propbankText.append(this.propbankData.removeFirst() + "\n");
        }
        tbView.setSofaDataString(FileUtils.file2String((File)treebankFile), "text/plain");
        pbView.setSofaDataString(propbankText.toString(), "text/plain");
    }

    public void close() throws IOException {
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.totalTreebankFiles - this.treebankFiles.size(), this.totalTreebankFiles, "entities")};
    }

    public boolean hasNext() throws IOException, CollectionException {
        return this.treebankFiles.size() > 0;
    }

    public void setPropbankFileName(String propbankFileName) {
        this.propbankFileName = propbankFileName;
    }

    public void setPenntreebankDirectoryName(String treebankDirectoryName) {
        this.penntreebankDirectoryName = treebankDirectoryName;
    }

    public void setWsjSections(String wsjSections) {
        this.wsjSections = wsjSections;
    }
}

