/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.corpus.timeml;

import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasCollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;
import org.cleartk.util.ViewUriUtil;

public class TempEval2010CollectionReader
extends JCasCollectionReader_ImplBase {
    public static final String BASE_SEGMENTATION_VIEW_NAME = "base-segmentation.tab";
    public static final String DCT_VIEW_NAME = "dct.txt";
    public static final String EVENT_EXTENTS_VIEW_NAME = "event-extents.tab";
    public static final String EVENT_ATTRIBUTES_VIEW_NAME = "event-attributes.tab";
    public static final String TIMEX_EXTENTS_VIEW_NAME = "timex-extents.tab";
    public static final String TIMEX_ATTRIBUTES_VIEW_NAME = "timex-attributes.tab";
    public static final String TLINK_DCT_EVENT_VIEW_NAME = "tlinks-dct-event.tab";
    public static final String TLINK_MAIN_EVENTS_VIEW_NAME = "tlinks-main-events.tab";
    public static final String TLINK_SUBORDINATED_EVENTS_VIEW_NAME = "tlinks-subordinated-events.tab";
    public static final String TLINK_TIMEX_EVENT_VIEW_NAME = "tlinks-timex-event.tab";
    @ConfigurationParameter(name="dataDirectories", mandatory=true, description="The directories containing the TempEval 2010 data, e.g. \"tempeval-training-2/english\" and \"tempeval2-test/english\"")
    protected List<File> dataDirectories;
    public static final String PARAM_DATA_DIRECTORIES = "dataDirectories";
    @ConfigurationParameter(name="selectedFileNames", mandatory=false, description="The names of files that should be included when reading, e.g \"ABC19980108.1830.0711\". If null, then all files in the dataset will be included.")
    protected Set<String> selectedFileNames;
    public static final String PARAM_SELECTED_FILE_NAMES = "selectedFileNames";
    protected List<URI> uris;
    protected int uriIndex;
    private Map<String, Map<String, String>> viewFileTexts;

    public static CollectionReader getCollectionReader(String ... dataPaths) throws ResourceInitializationException {
        ArrayList<File> dirs = new ArrayList<File>();
        for (String path : dataPaths) {
            dirs.add(new File(path));
        }
        return TempEval2010CollectionReader.getCollectionReader(dirs);
    }

    public static CollectionReader getCollectionReader(List<File> dataDirectories) throws ResourceInitializationException {
        return TempEval2010CollectionReader.getCollectionReader(dataDirectories, null);
    }

    public static CollectionReader getCollectionReader(List<File> dataDirectories, Set<String> selectedFileNames) throws ResourceInitializationException {
        ArrayList<String> dirsList = new ArrayList<String>();
        for (File dir : dataDirectories) {
            dirsList.add(dir.getPath());
        }
        String[] dirs = dirsList.toArray(new String[dirsList.size()]);
        String[] names = selectedFileNames == null ? null : selectedFileNames.toArray(new String[selectedFileNames.size()]);
        return CollectionReaderFactory.createReader(TempEval2010CollectionReader.class, null, (Object[])new Object[]{PARAM_DATA_DIRECTORIES, dirs, PARAM_SELECTED_FILE_NAMES, names});
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            this.uriIndex = 0;
            this.uris = new ArrayList<URI>();
            for (File dataDirectory : this.dataDirectories) {
                URI dataURI = dataDirectory.toURI();
                for (String fileName : TempEval2010CollectionReader.getAnnotatedFileNames(dataDirectory)) {
                    if (this.selectedFileNames != null && !this.selectedFileNames.contains(fileName)) continue;
                    URI uri = new URI(dataURI.getScheme(), dataURI.getHost(), dataURI.getPath(), fileName);
                    this.uris.add(uri);
                }
            }
            this.viewFileTexts = new HashMap<String, Map<String, String>>();
            for (String viewName : Arrays.asList(BASE_SEGMENTATION_VIEW_NAME, DCT_VIEW_NAME, EVENT_EXTENTS_VIEW_NAME, EVENT_ATTRIBUTES_VIEW_NAME, TIMEX_EXTENTS_VIEW_NAME, TIMEX_ATTRIBUTES_VIEW_NAME, TLINK_DCT_EVENT_VIEW_NAME, TLINK_MAIN_EVENTS_VIEW_NAME, TLINK_SUBORDINATED_EVENTS_VIEW_NAME, TLINK_TIMEX_EVENT_VIEW_NAME)) {
                this.viewFileTexts.put(viewName, this.textByFileName(viewName));
            }
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public boolean hasNext() throws IOException, CollectionException {
        return this.uriIndex < this.uris.size();
    }

    public void getNext(JCas jCas) throws IOException, CollectionException {
        URI uri = this.uris.get(this.uriIndex);
        ++this.uriIndex;
        ViewUriUtil.setURI((JCas)jCas, (URI)uri);
        String fileName = uri.getFragment();
        for (String viewName : this.viewFileTexts.keySet()) {
            JCas view;
            try {
                view = jCas.createView(viewName);
            }
            catch (CASException e) {
                throw new CollectionException((Throwable)e);
            }
            String text = this.viewFileTexts.get(viewName).get(fileName);
            view.setDocumentText(text == null ? "" : text);
        }
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.uriIndex, this.uris.size(), "entities")};
    }

    private Map<String, String> textByFileName(String tabFileName) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        for (File dir : this.dataDirectories) {
            files.addAll(TempEval2010CollectionReader.getTempEvalFiles(dir, tabFileName));
        }
        ArrayListMultimap fileLines = ArrayListMultimap.create();
        for (File file : files) {
            for (String line : Files.readLines((File)file, (Charset)Charsets.US_ASCII)) {
                String fileName = TempEval2010CollectionReader.getAnnotatedFileName(line);
                fileLines.put((Object)fileName, (Object)line);
            }
        }
        HashMap<String, String> fileTexts = new HashMap<String, String>();
        for (String fileName : fileLines.keySet()) {
            StringBuilder builder = new StringBuilder();
            for (String line : fileLines.get((Object)fileName)) {
                builder.append(line).append('\n');
            }
            fileTexts.put(fileName, builder.toString());
        }
        return fileTexts;
    }

    private static List<File> getTempEvalFiles(File dataDirectory, String tabFileName) throws FileNotFoundException {
        ArrayList<File> files = new ArrayList<File>();
        for (String subDir : Arrays.asList("data", "key")) {
            files.add(new File(new File(dataDirectory, subDir), tabFileName));
        }
        files.add(new File(dataDirectory, tabFileName.replaceAll("\\.txt", "-en.txt")));
        ArrayList<File> existingFiles = new ArrayList<File>();
        for (File file : files) {
            if (!file.exists()) continue;
            existingFiles.add(file);
        }
        if (existingFiles.size() == 0) {
            throw new FileNotFoundException("Could not find any of " + files);
        }
        return existingFiles;
    }

    protected static String getAnnotatedFileName(String line) {
        String[] parts = line.split("\t", 2);
        if (parts.length != 2) {
            throw new IllegalArgumentException("Expected <filename>\t..., found " + line);
        }
        return parts[0];
    }

    public static List<String> getAnnotatedFileNames(File dataDirectory) throws IOException {
        ArrayList<String> fileNames = new ArrayList<String>();
        HashSet<String> seenFileNames = new HashSet<String>();
        for (File tabFile : TempEval2010CollectionReader.getTempEvalFiles(dataDirectory, BASE_SEGMENTATION_VIEW_NAME)) {
            for (String line : Files.readLines((File)tabFile, (Charset)Charsets.US_ASCII)) {
                String fileName = TempEval2010CollectionReader.getAnnotatedFileName(line);
                if (seenFileNames.contains(fileName)) continue;
                seenFileNames.add(fileName);
                fileNames.add(fileName);
            }
        }
        return fileNames;
    }
}

