/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.corpus.timeml;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.timeml.type.Anchor;
import org.cleartk.timeml.type.DocumentCreationTime;
import org.cleartk.timeml.type.Event;
import org.cleartk.timeml.type.TemporalLink;
import org.cleartk.timeml.type.Time;
import org.cleartk.token.type.Sentence;
import org.cleartk.token.type.Token;

public class TempEval2010GoldAnnotator
extends JCasAnnotator_ImplBase {
    @ConfigurationParameter(name="textViews", mandatory=false, defaultValue={"_InitialView"}, description="Views where document text should be placed")
    private String[] textViews;
    @ConfigurationParameter(name="documentCreationTimeViews", mandatory=false, defaultValue={"_InitialView"}, description="Views where DocumentCreationTime annotations should be placed")
    private String[] documentCreationTimeViews;
    @ConfigurationParameter(name="timeExtentViews", mandatory=false, defaultValue={"_InitialView"}, description="Views where Time annotations should be placed")
    private String[] timeExtentViews;
    @ConfigurationParameter(name="timeAttributeViews", mandatory=false, defaultValue={"_InitialView"}, description="Views where Time annotation attributes should be placed")
    private String[] timeAttributeViews;
    @ConfigurationParameter(name="eventExtentViews", mandatory=false, defaultValue={"_InitialView"}, description="Views where Event annotations should be placed")
    private String[] eventExtentViews;
    @ConfigurationParameter(name="eventAttributeViews", mandatory=false, defaultValue={"_InitialView"}, description="Views where Event annotation attributes should be placed")
    private String[] eventAttributeViews;
    @ConfigurationParameter(name="temporalLinkEventToDocumentCreationTimeViews", mandatory=false, defaultValue={"_InitialView"}, description="Views where TemporalLink annotations between events and the document creation time should be placed")
    private String[] temporalLinkEventToDocumentCreationTimeViews;
    @ConfigurationParameter(name="temporalLinkEventToSameSentenceTimeViews", mandatory=false, defaultValue={"_InitialView"}, description="Views where TemporalLink annotations between events and times within the same sentence should be placed")
    private String[] temporalLinkEventToSameSentenceTimeViews;
    @ConfigurationParameter(name="temporalLinkEventToSubordinatedEventViews", mandatory=false, defaultValue={"_InitialView"}, description="Views where TemporalLink annotations between events and syntactically dominated events should be placed")
    private String[] temporalLinkEventToSubordinatedEventViews;
    @ConfigurationParameter(name="temporalLinkMainEventToNextSentenceMainEventViews", mandatory=false, defaultValue={"_InitialView"}, description="Views where TemporalLink annotations between main events in adjacent sentences should be placed")
    private String[] temporalLinkMainEventToNextSentenceMainEventViews;
    public static final String PARAM_TEXT_VIEWS = "textViews";
    public static final String PARAM_DOCUMENT_CREATION_TIME_VIEWS = "documentCreationTimeViews";
    public static final String PARAM_TIME_EXTENT_VIEWS = "timeExtentViews";
    public static final String PARAM_TIME_ATTRIBUTE_VIEWS = "timeAttributeViews";
    public static final String PARAM_EVENT_EXTENT_VIEWS = "eventExtentViews";
    public static final String PARAM_EVENT_ATTRIBUTE_VIEWS = "eventAttributeViews";
    public static final String PARAM_TEMPORAL_LINK_EVENT_TO_DOCUMENT_CREATION_TIME_VIEWS = "temporalLinkEventToDocumentCreationTimeViews";
    public static final String PARAM_TEMPORAL_LINK_EVENT_TO_SAME_SENTENCE_TIME_VIEWS = "temporalLinkEventToSameSentenceTimeViews";
    public static final String PARAM_TEMPORAL_LINK_EVENT_TO_SUBORDINATED_EVENT_VIEWS = "temporalLinkEventToSubordinatedEventViews";
    public static final String PARAM_TEMPORAL_LINK_MAIN_EVENT_TO_NEXT_SENTENCE_MAIN_EVENT_VIEWS = "temporalLinkMainEventToNextSentenceMainEventViews";

    public static AnalysisEngineDescription getDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(TempEval2010GoldAnnotator.class, (Object[])new Object[0]);
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        ArrayListMultimap sentTokens = ArrayListMultimap.create();
        for (String line : TempEval2010GoldAnnotator.lines(jCas, "base-segmentation.tab")) {
            String[] columns = TempEval2010GoldAnnotator.split(line, "<filename>", "<sent_no>", "<token_no>", "<text>");
            int sentIndex = new Integer(columns[1]);
            String text = columns[3];
            sentTokens.put((Object)sentIndex, (Object)text);
        }
        HashMap<String, StringBuilder> textBuilders = new HashMap<String, StringBuilder>();
        for (String viewName : this.textViews) {
            StringBuilder textBuilder = new StringBuilder("\n\n");
            JCas view = JCasUtil.getView((JCas)jCas, (String)viewName, (boolean)true);
            for (int i = 0; i < sentTokens.keySet().size(); ++i) {
                int sentBegin = textBuilder.length();
                ArrayList<Token> tokens = new ArrayList<Token>();
                for (String tokenText : sentTokens.get((Object)i)) {
                    int tokenBegin = textBuilder.length();
                    textBuilder.append(tokenText);
                    int tokenEnd = textBuilder.length();
                    textBuilder.append(' ');
                    Token token = new Token(view, tokenBegin, tokenEnd);
                    token.addToIndexes();
                    tokens.add(token);
                }
                int sentEnd = textBuilder.length() - 1;
                textBuilder.setCharAt(sentEnd, '\n');
                Sentence sentence = new Sentence(view, sentBegin, sentEnd);
                sentence.addToIndexes();
            }
            textBuilders.put(viewName, textBuilder);
        }
        for (String line : TempEval2010GoldAnnotator.lines(jCas, "dct.txt")) {
            String[] dctColumns = TempEval2010GoldAnnotator.split(line, "<filename>", "<dct>");
            String dctValue = dctColumns[1].replaceAll("(\\d{4})(\\d{2})(\\d{2})", "$1-$2-$3");
            for (String viewName : this.documentCreationTimeViews) {
                JCas view = JCasUtil.getView((JCas)jCas, (String)viewName, (boolean)true);
                DocumentCreationTime docTime = new DocumentCreationTime(view, 1, 1);
                docTime.setId("t0");
                docTime.setTimeType("DATE");
                docTime.setValue(dctValue);
                docTime.setFunctionInDocument("CREATION_TIME");
                docTime.addToIndexes();
            }
        }
        TempEval2010GoldAnnotator.addSpans(jCas, "timex-extents.tab", "timex3", this.timeExtentViews, new AnnotationConstructor<Time>(){

            @Override
            public Time apply(JCas aJCas, int begin, int end) {
                return new Time(aJCas, begin, end);
            }
        });
        TempEval2010GoldAnnotator.addAttributes(jCas, "timex-attributes.tab", Time.class, this.timeAttributeViews, new AttributeSetter<Time>(){

            @Override
            public void apply(Time time, String attrName, String attrValue) {
                if (attrName.equals("type")) {
                    time.setTimeType(attrValue);
                } else if (attrName.equals("value")) {
                    time.setValue(attrValue);
                } else {
                    String message = "Unexpected TIMEX attribute %s=%s";
                    throw new IllegalArgumentException(String.format(message, attrName, attrValue));
                }
            }
        });
        TempEval2010GoldAnnotator.addSpans(jCas, "event-extents.tab", "event", this.eventExtentViews, new AnnotationConstructor<Event>(){

            @Override
            public Event apply(JCas aJCas, int begin, int end) {
                return new Event(aJCas, begin, end);
            }
        });
        TempEval2010GoldAnnotator.addAttributes(jCas, "event-attributes.tab", Event.class, this.eventAttributeViews, new AttributeSetter<Event>(){

            @Override
            public void apply(Event event, String attrName, String attrValue) {
                if (attrName.equals("pos")) {
                    event.setPos(attrValue);
                } else if (attrName.equals("tense")) {
                    event.setTense(attrValue);
                } else if (attrName.equals("aspect")) {
                    event.setAspect(attrValue);
                } else if (attrName.equals("class")) {
                    event.setEventClass(attrValue);
                } else if (attrName.equals("polarity")) {
                    event.setPolarity(attrValue);
                } else if (attrName.equals("modality")) {
                    event.setModality(attrValue);
                } else {
                    String message = "Unexpected EVENT attribute %s=%s";
                    throw new IllegalArgumentException(String.format(message, attrName, attrValue));
                }
            }
        });
        TempEval2010GoldAnnotator.addTemporalLinks(jCas, "tlinks-dct-event.tab", textBuilders, this.temporalLinkEventToDocumentCreationTimeViews);
        TempEval2010GoldAnnotator.addTemporalLinks(jCas, "tlinks-timex-event.tab", textBuilders, this.temporalLinkEventToSameSentenceTimeViews);
        TempEval2010GoldAnnotator.addTemporalLinks(jCas, "tlinks-subordinated-events.tab", textBuilders, this.temporalLinkEventToSubordinatedEventViews);
        TempEval2010GoldAnnotator.addTemporalLinks(jCas, "tlinks-main-events.tab", textBuilders, this.temporalLinkMainEventToNextSentenceMainEventViews);
        for (String viewName : this.textViews) {
            JCas view = JCasUtil.getView((JCas)jCas, (String)viewName, (boolean)true);
            view.setDocumentText(((StringBuilder)textBuilders.get(viewName)).toString());
        }
    }

    private static String[] split(String line, String ... expected) {
        String[] columns = line.split("\t");
        if (columns.length != expected.length) {
            throw new IllegalArgumentException(String.format("Expected % d items, %s, found %d items, %s", expected.length, Joiner.on((char)'\t').join((Object[])expected), columns.length, line));
        }
        return columns;
    }

    private static String[] lines(JCas jCas, String viewName) throws AnalysisEngineProcessException {
        JCas view;
        try {
            view = jCas.getView(viewName);
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        String text = view.getDocumentText();
        if (text == null) {
            throw new IllegalArgumentException("no text in view " + viewName);
        }
        return text.length() > 0 ? text.split("\n") : new String[]{};
    }

    private static <T extends Anchor> void addSpans(JCas jCas, String tabViewName, String elementName, String[] annotationViewNames, AnnotationConstructor<T> constructor) throws AnalysisEngineProcessException {
        String[] lines = TempEval2010GoldAnnotator.lines(jCas, tabViewName);
        for (String annotationViewName : annotationViewNames) {
            JCas view = JCasUtil.getView((JCas)jCas, (String)annotationViewName, (boolean)true);
            HashMap<String, Anchor> idMap = new HashMap<String, Anchor>();
            ArrayList<List> sentenceTokens = new ArrayList<List>();
            for (Sentence sentence : JCasUtil.select((JCas)view, Sentence.class)) {
                sentenceTokens.add(JCasUtil.selectCovered((JCas)view, Token.class, (AnnotationFS)sentence));
            }
            for (String line : lines) {
                Anchor ann;
                String[] columns = TempEval2010GoldAnnotator.split(line, "<filename>", "<sent_no>", "<token_no>", elementName, "<id>", "1");
                int sentIndex = Integer.parseInt(columns[1]);
                int tokenIndex = Integer.parseInt(columns[2]);
                String id = columns[4];
                Token token = (Token)((List)sentenceTokens.get(sentIndex)).get(tokenIndex);
                if (!idMap.containsKey(id)) {
                    ann = (Anchor)constructor.apply(view, token.getBegin(), token.getEnd());
                    ann.setId(id);
                    ann.addToIndexes();
                    idMap.put(id, ann);
                    continue;
                }
                ann = (Anchor)idMap.get(id);
                if (token.getBegin() < ann.getBegin()) {
                    ann.setBegin(token.getBegin());
                }
                if (token.getEnd() <= ann.getEnd()) continue;
                ann.setEnd(token.getEnd());
            }
        }
    }

    private static <T extends Anchor> void addAttributes(JCas jCas, String tabViewName, Class<T> cls, String[] annotationViewNames, AttributeSetter<T> setter) throws AnalysisEngineProcessException {
        String[] lines = TempEval2010GoldAnnotator.lines(jCas, tabViewName);
        for (String annotationViewName : annotationViewNames) {
            JCas view = JCasUtil.getView((JCas)jCas, (String)annotationViewName, (boolean)false);
            HashMap<String, Anchor> idMap = new HashMap<String, Anchor>();
            for (Anchor anchor : JCasUtil.select((JCas)view, cls)) {
                idMap.put(anchor.getId(), anchor);
            }
            for (String line : lines) {
                String[] columns = TempEval2010GoldAnnotator.split(line, "<filename>", "<sent_no>", "<token_no>", "timex3", "<id>", "1", "<attribute>", "<value>");
                String id = columns[4];
                String attrName = columns[6];
                String attrValue = columns[7];
                setter.apply((Annotation)idMap.get(id), attrName, attrValue);
            }
        }
    }

    private static void addTemporalLinks(JCas jCas, String tabViewName, Map<String, StringBuilder> textBuilders, String[] annotationViewNames) throws AnalysisEngineProcessException {
        String[] lines = TempEval2010GoldAnnotator.lines(jCas, tabViewName);
        for (String annotationViewName : annotationViewNames) {
            JCas view = JCasUtil.getView((JCas)jCas, (String)annotationViewName, (boolean)true);
            HashMap<String, Anchor> idAnchors = new HashMap<String, Anchor>();
            for (Anchor anchor : JCasUtil.select((JCas)view, Anchor.class)) {
                idAnchors.put(anchor.getId(), anchor);
            }
            StringBuilder textBuilder = textBuilders.get(annotationViewName);
            for (String line : lines) {
                String[] columns = TempEval2010GoldAnnotator.split(line, "<filename>", "<eid>", "<tid>", "<relation>");
                String sourceID = columns[1];
                String targetID = columns[2];
                String relation = columns[3];
                int offset = textBuilder.length();
                TemporalLink tlink = new TemporalLink(view, offset, offset);
                tlink.setSource((Anchor)idAnchors.get(sourceID));
                tlink.setTarget((Anchor)idAnchors.get(targetID));
                tlink.setRelationType(relation);
                tlink.addToIndexes();
                textBuilder.append('\n');
            }
        }
    }

    private static interface AttributeSetter<T extends Annotation> {
        public void apply(T var1, String var2, String var3);
    }

    private static interface AnnotationConstructor<T extends Annotation> {
        public T apply(JCas var1, int var2, int var3);
    }
}

