/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.feature.token;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.CoveredTextExtractor;
import org.cleartk.ml.feature.extractor.NamedFeatureExtractor1;
import org.cleartk.token.type.Token;

public class TokenTextForSelectedPosExtractor
implements NamedFeatureExtractor1<Token> {
    private Set<String> acceptablePOSTags;
    private CoveredTextExtractor<Token> extractor;

    public TokenTextForSelectedPosExtractor(Collection<String> acceptablePOSTags) {
        this.acceptablePOSTags = new HashSet<String>(acceptablePOSTags);
        this.extractor = new CoveredTextExtractor();
    }

    public TokenTextForSelectedPosExtractor(String ... acceptablePOSTags) {
        this(Arrays.asList(acceptablePOSTags));
    }

    public String getFeatureName() {
        return this.extractor.getFeatureName();
    }

    public List<Feature> extract(JCas view, Token token) throws CleartkExtractorException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        String pos = token.getPos();
        if (pos != null) {
            if (pos.length() > 2) {
                pos = pos.substring(0, 2);
            }
            if (this.acceptablePOSTags.contains(pos)) {
                features.addAll(this.extractor.extract(view, (Annotation)token));
            }
        }
        return features;
    }
}

