/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.ws;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.jws.WebService;
import org.apache.ctakes.ytex.kernel.metric.ConceptPair;
import org.apache.ctakes.ytex.kernel.metric.ConceptPairSimilarity;
import org.apache.ctakes.ytex.kernel.metric.ConceptSimilarityService;
import org.apache.ctakes.ytex.web.search.SemanticSimRegistryBean;
import org.apache.ctakes.ytex.web.search.SemanticSimServiceBean;
import org.apache.ctakes.ytex.ws.ConceptSimilarityRestService;
import org.apache.ctakes.ytex.ws.ConceptSimilarityWebService;
import org.apache.ctakes.ytex.ws.SimServiceInfo;

@WebService(endpointInterface="org.apache.ctakes.ytex.ws.ConceptSimilarityWebService")
public class ConceptSimilarityWebServiceImpl
implements ConceptSimilarityWebService,
ConceptSimilarityRestService {
    SemanticSimRegistryBean semanticSimRegistryBean;

    public SemanticSimRegistryBean getSemanticSimRegistryBean() {
        return this.semanticSimRegistryBean;
    }

    public void setSemanticSimRegistryBean(SemanticSimRegistryBean semanticSimRegistryBean) {
        this.semanticSimRegistryBean = semanticSimRegistryBean;
    }

    @Override
    public ConceptPairSimilarity similarity(String conceptGraph, String concept1, String concept2, String metrics, String lcs) {
        ConceptSimilarityService s = this.getConceptSimilarityService(conceptGraph);
        if (s == null) {
            return null;
        }
        List<ConceptSimilarityService.SimilarityMetricEnum> metricList = this.metricArrayToList(metrics.split(","));
        if (metricList.size() == 0) {
            return null;
        }
        return s.similarity(metricList, concept1, concept2, null, "true".equalsIgnoreCase(lcs));
    }

    private ConceptSimilarityService getConceptSimilarityService(String conceptGraph) {
        String conceptGraphName = conceptGraph;
        if (conceptGraphName == null || conceptGraphName.length() == 0) {
            conceptGraphName = this.semanticSimRegistryBean.getDefaultConceptGraphName();
        }
        ConceptSimilarityService s = ((SemanticSimServiceBean)this.semanticSimRegistryBean.getSemanticSimServiceMap().get(conceptGraphName)).getConceptSimilarityService();
        return s;
    }

    @Override
    public List<ConceptPairSimilarity> similarities(String conceptGraph, ConceptPair[] conceptPairs, String[] metrics, boolean lcs) {
        ConceptSimilarityService s = this.getConceptSimilarityService(conceptGraph);
        List<ConceptSimilarityService.SimilarityMetricEnum> metricList = this.metricArrayToList(metrics);
        List<ConceptPair> conceptPairList = Arrays.asList(conceptPairs);
        return s.similarity(conceptPairList, metricList, null, lcs);
    }

    private List<ConceptSimilarityService.SimilarityMetricEnum> metricArrayToList(String[] metrics) {
        ArrayList<ConceptSimilarityService.SimilarityMetricEnum> metricIndexMap = new ArrayList<ConceptSimilarityService.SimilarityMetricEnum>();
        for (String metric : metrics) {
            ConceptSimilarityService.SimilarityMetricEnum m = ConceptSimilarityService.SimilarityMetricEnum.valueOf((String)metric);
            if (m == null) continue;
            metricIndexMap.add(m);
        }
        return metricIndexMap;
    }

    @Override
    public SimServiceInfo getDefaultConceptGraph() {
        String conceptGraph = this.semanticSimRegistryBean.getDefaultConceptGraphName();
        if (conceptGraph != null) {
            return new SimServiceInfo(conceptGraph, ((SemanticSimServiceBean)this.semanticSimRegistryBean.getSemanticSimServiceMap().get(conceptGraph)).getDescription());
        }
        return null;
    }

    @Override
    public List<SimServiceInfo> getConceptGraphs() {
        ArrayList<SimServiceInfo> cgs = new ArrayList<SimServiceInfo>(this.semanticSimRegistryBean.getSemanticSimDescriptionMap().size());
        for (Map.Entry<String, String> entry : this.semanticSimRegistryBean.getSemanticSimDescriptionMap().entrySet()) {
            cgs.add(new SimServiceInfo(entry.getValue(), entry.getKey()));
        }
        return cgs;
    }
}

