/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.drugner.cc;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.FSUtil;
import org.apache.ctakes.drugner.type.ChunkAnnotation;
import org.apache.ctakes.drugner.type.SubSectionAnnotation;
import org.apache.ctakes.typesystem.type.refsem.Date;
import org.apache.ctakes.typesystem.type.refsem.MedicationDosage;
import org.apache.ctakes.typesystem.type.refsem.MedicationDuration;
import org.apache.ctakes.typesystem.type.refsem.MedicationForm;
import org.apache.ctakes.typesystem.type.refsem.MedicationFrequency;
import org.apache.ctakes.typesystem.type.refsem.MedicationRoute;
import org.apache.ctakes.typesystem.type.refsem.MedicationStatusChange;
import org.apache.ctakes.typesystem.type.refsem.MedicationStrength;
import org.apache.ctakes.typesystem.type.refsem.OntologyConcept;
import org.apache.ctakes.typesystem.type.syntax.WordToken;
import org.apache.ctakes.typesystem.type.textsem.MedicationDosageModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationDurationModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationFormModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationFrequencyModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationMention;
import org.apache.ctakes.typesystem.type.textsem.MedicationRouteModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationStatusChangeModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationStrengthModifier;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.ctakes.typesystem.type.util.Pair;
import org.apache.ctakes.typesystem.type.util.Pairs;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;

@PipeBitInfo(name="Database File Writer", description="Writes to a file that is compatible with Database import.", role=PipeBitInfo.Role.WRITER, dependencies={PipeBitInfo.TypeProduct.SECTION, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public class ConsumeNamedEntityRecordModel
extends CasConsumer_ImplBase {
    private String iv_annotVerPropKey;
    protected ArrayList al = new ArrayList();
    File iv_outputDirectory;
    int keepTrackOfDupBegin = 0;
    int keepTrackOfDupEnd = 0;
    int milliWeek = 604800000;
    int milliDay = 86400000;
    private int iv_annotVer;
    private boolean gotValidDate = false;
    private boolean gotDup = false;
    private String vRevDate = null;
    private String vNoteDate = null;
    private String vClinicalNumber = null;
    private String clinicNumber = null;
    private String docLinkId = "";
    private String docRevision = "";
    private String iv_fileForInput = null;
    private String pathToDrugInclusions;
    private Set<String> iv_medicalSections = new HashSet<String>();
    private String drugHeaders = "clinicNumber,drug_mention_text,rxnorm_cui,local_date,note_date,dosage,strength,frequency,frequency_unit,duration,route,form,status,change_status,certainty,section|subsection|status,documentId_revision\n";
    private Boolean iv_useCurrentMedsSectionOnly = new Boolean("true");
    public static final String PARAM_OUTPUTDIR = "OutputDirectory";
    private String fileForIO = new String("R:\\Dept\\projects\\Text\\DrugProfile\\data\\psychiatry\\goldStandard\\work.csv");

    public void initialize() throws ResourceInitializationException {
        this.fileForIO = (String)this.getConfigParameterValue(PARAM_OUTPUTDIR);
        this.iv_outputDirectory = new File(this.fileForIO);
        this.iv_useCurrentMedsSectionOnly = (Boolean)this.getConfigParameterValue("useMedicationSectionOnly");
        this.pathToDrugInclusions = (String)this.getConfigParameterValue("filterGroupDrugs");
        this.iv_fileForInput = (String)this.getConfigParameterValue("locationForClinicRcdInput");
        String holdListMedSections = (String)this.getConfigParameterValue("listMedicationSection");
        StringTokenizer nextMedSection = new StringTokenizer(holdListMedSections, "|");
        while (nextMedSection.hasMoreTokens()) {
            this.iv_medicalSections.add(nextMedSection.nextToken());
        }
        if (!this.iv_outputDirectory.exists() || !this.iv_outputDirectory.isDirectory()) {
            if (!this.iv_outputDirectory.exists()) {
                new File(this.fileForIO).mkdir();
            } else {
                throw new ResourceInitializationException((Throwable)new Exception("Parameter setting 'OutputDirectory' does not point to an existing directory."));
            }
        }
    }

    private void storeAnnotationVersion(JCas jcas) {
        FSIterator itr = jcas.getJFSIndexRepository().getAllIndexedFS(Pairs.type);
        if (itr == null || !itr.hasNext()) {
            return;
        }
        Pairs props = (Pairs)itr.next();
        FSArray propArr = props.getPairs();
        FSArray newPropArr = new FSArray(jcas, propArr.size() + 1);
        for (int i = 0; i < propArr.size(); ++i) {
            newPropArr.set(i, propArr.get(i));
        }
        Pair annotVerProp = new Pair(jcas);
        annotVerProp.setAttribute(this.iv_annotVerPropKey);
        annotVerProp.setValue(String.valueOf(this.iv_annotVer));
        newPropArr.set(newPropArr.size() - 1, (FeatureStructure)annotVerProp);
        props.setPairs(newPropArr);
    }

    public void processCas(CAS cas) throws ResourceProcessException {
        this.vRevDate = "";
        this.vNoteDate = "";
        this.vClinicalNumber = "";
        this.gotValidDate = false;
        this.gotDup = false;
        this.clinicNumber = "";
        this.assignNamedEntityFeats(cas);
    }

    private void assignNamedEntityFeats(CAS cas) throws ResourceProcessException {
        try {
            JCas jcas = cas.getCurrentView().getJCas();
            boolean gotMeds = false;
            int trackMedOccur = 0;
            String medInfo = "";
            JFSIndexRepository indexes = jcas.getJFSIndexRepository();
            HashSet<Segment> segmentSet = new HashSet<Segment>();
            for (Segment s : indexes.getAnnotationIndex(Segment.type)) {
                segmentSet.add(s);
            }
            for (MedicationMention neAnnot : indexes.getAnnotationIndex(MedicationMention.type)) {
                this.gotDup = false;
                for (Segment seg : segmentSet) {
                    MedicationStatusChange sc;
                    MedicationForm f;
                    MedicationRoute r;
                    MedicationDuration d;
                    MedicationFrequency f2;
                    MedicationDosage d2;
                    String segmentID;
                    if (this.keepTrackOfDupBegin == neAnnot.getBegin() && this.keepTrackOfDupEnd == neAnnot.getEnd()) {
                        this.gotDup = true;
                    }
                    if (neAnnot.getBegin() < seg.getBegin() || neAnnot.getEnd() > seg.getEnd() || this.gotDup || !this.iv_medicalSections.contains(segmentID = seg.getId()) && this.iv_useCurrentMedsSectionOnly.booleanValue() || this.gotDup) continue;
                    this.keepTrackOfDupBegin = neAnnot.getBegin();
                    this.keepTrackOfDupEnd = neAnnot.getEnd();
                    TimeMention startTimeMention = neAnnot.getStartDate();
                    Date localDate = null;
                    if (startTimeMention != null) {
                        localDate = startTimeMention.getDate();
                    }
                    String chunk = null;
                    boolean foundChunk = false;
                    FSIterator findChunk = indexes.getAnnotationIndex(ChunkAnnotation.type).iterator();
                    try {
                        while (findChunk.hasNext() && !foundChunk) {
                            ChunkAnnotation ca = (ChunkAnnotation)((Object)findChunk.next());
                            if (neAnnot.getBegin() < ca.getBegin() || neAnnot.getEnd() > ca.getEnd()) continue;
                            chunk = ca.getCoveredText().replace('\n', ' ').replace(',', ';');
                            foundChunk = true;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    String containedInSubSection = segmentID;
                    for (SubSectionAnnotation ssAnnot : indexes.getAnnotationIndex(SubSectionAnnotation.type)) {
                        if (ssAnnot.getSubSectionBodyBegin() > neAnnot.getBegin() || ssAnnot.getSubSectionBodyEnd() < neAnnot.getEnd()) continue;
                        FSIterator textSpanInSs = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)WordToken.type, (int)ssAnnot.getSubSectionHeaderBegin(), (int)ssAnnot.getSubSectionHeaderEnd());
                        String subSectionHeaderName = "";
                        while (textSpanInSs.hasNext()) {
                            WordToken wta = (WordToken)textSpanInSs.next();
                            subSectionHeaderName = subSectionHeaderName + " " + wta.getCoveredText();
                        }
                        containedInSubSection = containedInSubSection + "|" + subSectionHeaderName + "|" + ssAnnot.getStatus();
                    }
                    gotMeds = true;
                    ++trackMedOccur;
                    Calendar calendar = Calendar.getInstance();
                    SimpleDateFormat format = new SimpleDateFormat("MM'/'dd'/'yyyy");
                    if (this.vRevDate != null && this.vRevDate.length() > 0) {
                        calendar.setTimeInMillis(new Long(this.vRevDate));
                    } else if (this.vNoteDate != null && this.vNoteDate.length() > 0) {
                        calendar.setTimeInMillis(new Long(this.vNoteDate));
                    }
                    String globalDate = format.format(calendar.getTime());
                    String neCui = "n/a";
                    String status = "n/a";
                    String rxNormCui = "n/a";
                    FSArray ocArr = neAnnot.getOntologyConceptArr();
                    if (ocArr != null) {
                        for (int i = 0; i < ocArr.size(); ++i) {
                            OntologyConcept oc = (OntologyConcept)ocArr.get(i);
                            neCui = oc.getCode();
                            rxNormCui = oc.getOui();
                        }
                    }
                    MedicationStrengthModifier strength = neAnnot.getMedicationStrength();
                    MedicationStrength strengthTerm = (MedicationStrength)strength.getNormalizedForm();
                    String strengthTermString = "null";
                    if (strengthTerm != null) {
                        strengthTermString = strengthTerm.getNumber() + " " + strengthTerm.getUnit();
                    }
                    String medicationDosageString = "null";
                    MedicationDosageModifier dosageModifier = neAnnot.getMedicationDosage();
                    if (dosageModifier != null && (d2 = (MedicationDosage)dosageModifier.getNormalizedForm()) != null) {
                        medicationDosageString = d2.getValue();
                    }
                    String medicationFrequencyNumber = "null";
                    MedicationFrequencyModifier freqModifier = neAnnot.getMedicationFrequency();
                    if (freqModifier != null && (f2 = (MedicationFrequency)freqModifier.getNormalizedForm()) != null) {
                        medicationFrequencyNumber = f2.getNumber() + " " + f2.getUnit();
                    }
                    String duration = "null";
                    MedicationDurationModifier durationModifier = neAnnot.getMedicationDuration();
                    if (durationModifier != null && (d = (MedicationDuration)durationModifier.getNormalizedForm()) != null) {
                        duration = d.getValue();
                    }
                    String route = "null";
                    MedicationRouteModifier routeModifier = neAnnot.getMedicationRoute();
                    if (routeModifier != null && (r = (MedicationRoute)routeModifier.getNormalizedForm()) != null) {
                        route = r.getValue();
                    }
                    String form = "null";
                    MedicationFormModifier formModifier = neAnnot.getMedicationForm();
                    if (formModifier != null && (f = (MedicationForm)formModifier.getNormalizedForm()) != null) {
                        form = f.getValue();
                    }
                    String changeStatus = "null";
                    MedicationStatusChangeModifier scModifier = neAnnot.getMedicationStatusChange();
                    if (scModifier != null && (sc = (MedicationStatusChange)scModifier.getNormalizedForm()) != null) {
                        changeStatus = sc.getValue();
                    }
                    medInfo = this.clinicNumber + "," + neAnnot.getCoveredText() + "," + rxNormCui + ",\"" + neAnnot.getStartDate() + "\"," + globalDate + "," + medicationDosageString + "," + strengthTermString + "," + medicationFrequencyNumber + "," + duration + "," + route + "," + form + "," + status + "," + changeStatus + "," + neAnnot.getConfidence() + "," + containedInSubSection + "," + this.docLinkId + "_" + this.docRevision + "," + chunk;
                    this.store(this.fileForIO, medInfo);
                }
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            throw new ResourceProcessException((Throwable)e);
        }
    }

    public static List load(String filename) throws FileNotFoundException, IOException {
        String[][] idDate = null;
        ArrayList<String[][]> listIDandDates = new ArrayList<String[][]>();
        File f = new File(filename);
        BufferedReader br = new BufferedReader(new FileReader(f));
        br.readLine();
        br.readLine();
        String line = br.readLine();
        int index = 0;
        while (line != null && line != "" && line.length() > 0) {
            int firstComma = line.indexOf(44);
            int lastComma = line.lastIndexOf(44);
            String id = line.substring(0, firstComma);
            String date = line.substring(lastComma + 1, line.indexOf("0:00"));
            idDate = new String[][]{{id}, {date}};
            listIDandDates.add(index, idDate);
            ++index;
            line = br.readLine();
        }
        br.close();
        return listIDandDates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String filename, String lineToStore) throws FileNotFoundException, IOException {
        int howMany = 132;
        boolean skipDate = false;
        boolean preExists = true;
        File f = new File(filename = filename.endsWith(System.getProperty("file.separator")) ? filename + lineToStore.substring(0, lineToStore.indexOf(44)) + ".csv" : filename + "/" + lineToStore.substring(0, lineToStore.indexOf(44)) + ".csv");
        if (!f.exists()) {
            f.createNewFile();
            preExists = false;
        }
        BufferedReader br = new BufferedReader(new FileReader(f));
        br.readLine();
        br.close();
        ByteArrayOutputStream bout = new ByteArrayOutputStream(howMany * 4);
        DataOutputStream dout = new DataOutputStream(bout);
        FileOutputStream fos = new FileOutputStream(filename, true);
        if (!preExists) {
            dout.writeBytes(this.drugHeaders);
        }
        if (!skipDate) {
            dout.writeBytes(lineToStore + '\n');
        }
        try {
            if (!skipDate) {
                bout.writeTo(fos);
                fos.flush();
            }
        }
        finally {
            fos.close();
        }
    }

    protected String parseStengthValue(Object strength) {
        String text = (String)strength;
        String strengthText = "";
        boolean containsNums = false;
        boolean doneHere = false;
        int textSize = text.length();
        int pos = 0;
        Object posInt = null;
        String strengthString = "";
        while (!doneHere && textSize > pos && textSize > 1) {
            try {
                strengthString = text.substring(pos, pos + 1);
                Integer posNum = Integer.decode(strengthString);
                int checkInt = posNum;
                if (checkInt >= 0 && checkInt <= 9) {
                    containsNums = true;
                } else {
                    strengthText = strengthText + strengthString;
                }
                ++pos;
            }
            catch (NullPointerException npe) {
                return null;
            }
            catch (NumberFormatException nfe) {
                if (!containsNums) {
                    doneHere = true;
                    continue;
                }
                ++pos;
                strengthText = strengthText + strengthString;
            }
        }
        return strengthText;
    }

    protected int parseIntValue(Object strength) {
        String text = (String)strength;
        String strengthNumText = "";
        String subText = "";
        boolean containsNums = false;
        boolean doneHere = false;
        int textSize = text.length();
        int pos = 0;
        Object posInt = null;
        while (!doneHere && textSize > pos && textSize > 1) {
            try {
                String numString = text.substring(pos, pos + 1);
                Integer posNum = Integer.decode(numString);
                int checkInt = posNum;
                if (checkInt >= 0 && checkInt <= 9) {
                    containsNums = true;
                    subText = text.substring(pos + 1, textSize);
                    ++pos;
                    strengthNumText = strengthNumText + numString;
                    continue;
                }
                return 0;
            }
            catch (NullPointerException npe) {
                return 0;
            }
            catch (NumberFormatException nfe) {
                if (!containsNums) {
                    return 0;
                }
                doneHere = true;
            }
        }
        if (strengthNumText != "") {
            return new Integer(strengthNumText);
        }
        return 0;
    }
}

