/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.drugner.fsm.machines.elements;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.openai.util.fsm.AnyCondition;
import net.openai.util.fsm.Condition;
import net.openai.util.fsm.Machine;
import net.openai.util.fsm.State;
import org.apache.ctakes.core.fsm.condition.DecimalCondition;
import org.apache.ctakes.core.fsm.condition.NumberCondition;
import org.apache.ctakes.core.fsm.condition.PunctuationValueCondition;
import org.apache.ctakes.core.fsm.condition.WordSetCondition;
import org.apache.ctakes.core.fsm.state.NamedState;
import org.apache.ctakes.core.fsm.token.BaseToken;
import org.apache.ctakes.drugner.fsm.elements.conditions.ContainsSetTextValueCondition;
import org.apache.ctakes.drugner.fsm.output.util.FractionStrengthToken;

public class FractionStrengthFSM {
    Set<String> iv_textNumeratorSet = new HashSet<String>();
    Set<String> iv_textDenominatorSet = new HashSet<String>();
    private Set<Machine> iv_machineSet = new HashSet<Machine>();

    public FractionStrengthFSM() {
        this.iv_textNumeratorSet.add("one");
        this.iv_textNumeratorSet.add("two");
        this.iv_textNumeratorSet.add("three");
        this.iv_textNumeratorSet.add("four");
        this.iv_textNumeratorSet.add("five");
        this.iv_textNumeratorSet.add("six");
        this.iv_textNumeratorSet.add("seven");
        this.iv_textNumeratorSet.add("eight");
        this.iv_textNumeratorSet.add("nine");
        this.iv_textNumeratorSet.add("ten");
        this.iv_textDenominatorSet.add("half");
        this.iv_textDenominatorSet.add("halfs");
        this.iv_textDenominatorSet.add("third");
        this.iv_textDenominatorSet.add("thirds");
        this.iv_textDenominatorSet.add("fourth");
        this.iv_textDenominatorSet.add("fourths");
        this.iv_textDenominatorSet.add("fifth");
        this.iv_textDenominatorSet.add("fifths");
        this.iv_textDenominatorSet.add("sixth");
        this.iv_textDenominatorSet.add("sixths");
        this.iv_textDenominatorSet.add("seventh");
        this.iv_textDenominatorSet.add("sevenths");
        this.iv_textDenominatorSet.add("eighth");
        this.iv_textDenominatorSet.add("eighths");
        this.iv_textDenominatorSet.add("nineths");
        this.iv_textDenominatorSet.add("nineth");
        this.iv_textDenominatorSet.add("tenth");
        this.iv_textDenominatorSet.add("tenths");
        this.iv_machineSet.add(this.getStrengthSlashMachine());
        this.iv_machineSet.add(this.getStandardMachine());
    }

    private Machine getStrengthSlashMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine((State)startState);
        NamedState numeratorLeftState = new NamedState("NUMERATOR_LEFT");
        NamedState remainderRightState = new NamedState("REMAINDER_RIGHT");
        NamedState numeratorRightState = new NamedState("NUMERATOR_RIGHT");
        NamedState decPartNumState = new NamedState("DECIMAL_NUM");
        NamedState fslashState = new NamedState("FORWARD-SLASH");
        NamedState hypenState = new NamedState("HYPHEN");
        NamedState dotLeftState = new NamedState("DOT_LEFT");
        NamedState dotRightState = new NamedState("DOT_RIGHT");
        NumberCondition intNumeratorCondition = new NumberCondition();
        NumberCondition decPartInt = new NumberCondition();
        PunctuationValueCondition fslashCondition = new PunctuationValueCondition('/');
        NumberCondition intDenominatorCondition = new NumberCondition();
        DecimalCondition decDenominatorCondition = new DecimalCondition();
        DecimalCondition decimalCondition = new DecimalCondition();
        PunctuationValueCondition containsdotCondition = new PunctuationValueCondition('.');
        ContainsSetTextValueCondition leftContainsShortDose = new ContainsSetTextValueCondition(this.iv_textNumeratorSet, false);
        startState.addTransition((Condition)intNumeratorCondition, (State)numeratorLeftState);
        startState.addTransition((Condition)leftContainsShortDose, (State)numeratorLeftState);
        startState.addTransition((Condition)new DecimalCondition(), (State)numeratorLeftState);
        startState.addTransition((Condition)new AnyCondition(), (State)startState);
        numeratorLeftState.addTransition((Condition)containsdotCondition, (State)dotLeftState);
        numeratorLeftState.addTransition((Condition)fslashCondition, (State)fslashState);
        numeratorLeftState.addTransition((Condition)new PunctuationValueCondition('-'), (State)numeratorRightState);
        numeratorLeftState.addTransition((Condition)new AnyCondition(), (State)startState);
        dotLeftState.addTransition((Condition)decPartInt, (State)hypenState);
        dotLeftState.addTransition((Condition)decDenominatorCondition, (State)hypenState);
        dotLeftState.addTransition((Condition)new AnyCondition(), (State)startState);
        hypenState.addTransition((Condition)new PunctuationValueCondition('-'), (State)numeratorRightState);
        hypenState.addTransition((Condition)new AnyCondition(), (State)startState);
        numeratorRightState.addTransition((Condition)new NumberCondition(), (State)endState);
        numeratorRightState.addTransition((Condition)new DecimalCondition(), (State)endState);
        numeratorRightState.addTransition((Condition)new AnyCondition(), (State)startState);
        dotRightState.addTransition((Condition)new PunctuationValueCondition('.'), (State)fslashState);
        dotRightState.addTransition((Condition)new AnyCondition(), (State)startState);
        decPartNumState.addTransition((Condition)fslashCondition, (State)fslashState);
        decPartNumState.addTransition((Condition)new AnyCondition(), (State)startState);
        fslashState.addTransition((Condition)intDenominatorCondition, (State)endState);
        fslashState.addTransition((Condition)decimalCondition, (State)endState);
        fslashState.addTransition((Condition)new AnyCondition(), (State)startState);
        endState.addTransition((Condition)new AnyCondition(), (State)startState);
        return m;
    }

    private Machine getStandardMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine((State)startState);
        NamedState numeratorNumState = new NamedState("NUMERATOR_NUM");
        NamedState fslashState = new NamedState("FORWARD_SLASH");
        NamedState numeratorTextState = new NamedState("NUMERATOR_TEXT");
        NumberCondition intNumeratorCondition = new NumberCondition();
        PunctuationValueCondition fslashCondition = new PunctuationValueCondition('/');
        NumberCondition intDenominatorCondition = new NumberCondition();
        DecimalCondition decimalCondition = new DecimalCondition();
        WordSetCondition textNumeratorCondition = new WordSetCondition(this.iv_textNumeratorSet, false);
        WordSetCondition textDenominatorCondition = new WordSetCondition(this.iv_textDenominatorSet, false);
        startState.addTransition((Condition)intNumeratorCondition, (State)numeratorNumState);
        startState.addTransition((Condition)decimalCondition, (State)numeratorNumState);
        startState.addTransition((Condition)textNumeratorCondition, (State)numeratorTextState);
        startState.addTransition((Condition)textDenominatorCondition, (State)endState);
        startState.addTransition((Condition)new AnyCondition(), (State)startState);
        numeratorNumState.addTransition((Condition)fslashCondition, (State)fslashState);
        numeratorNumState.addTransition((Condition)textDenominatorCondition, (State)endState);
        numeratorNumState.addTransition((Condition)new AnyCondition(), (State)startState);
        fslashState.addTransition((Condition)intDenominatorCondition, (State)endState);
        fslashState.addTransition((Condition)new AnyCondition(), (State)startState);
        numeratorTextState.addTransition((Condition)textDenominatorCondition, (State)endState);
        numeratorTextState.addTransition((Condition)new AnyCondition(), (State)startState);
        endState.addTransition((Condition)new AnyCondition(), (State)startState);
        return m;
    }

    public Set execute(List tokens) throws Exception {
        HashSet<FractionStrengthToken> fractionSet = new HashSet<FractionStrengthToken>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        for (int i = 0; i < tokens.size(); ++i) {
            BaseToken token = (BaseToken)tokens.get(i);
            for (Machine fsm : this.iv_machineSet) {
                int tokenStartIndex;
                fsm.input((Object)token);
                State currentState = fsm.getCurrentState();
                if (currentState.getStartStateFlag()) {
                    tokenStartMap.put(fsm, i);
                }
                if (!currentState.getEndStateFlag()) continue;
                Object o = tokenStartMap.get(fsm);
                if (o == null) {
                    tokenStartIndex = 0;
                } else {
                    tokenStartIndex = (Integer)o;
                    ++tokenStartIndex;
                }
                BaseToken startToken = (BaseToken)tokens.get(tokenStartIndex);
                BaseToken endToken = token;
                FractionStrengthToken fractionToken = new FractionStrengthToken(startToken.getStartOffset(), endToken.getEndOffset());
                fractionSet.add(fractionToken);
                fsm.reset();
            }
        }
        tokenStartMap.clear();
        for (Machine fsm : this.iv_machineSet) {
            fsm.reset();
        }
        return fractionSet;
    }
}

