/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.drugner.fsm.machines.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.openai.util.fsm.AnyCondition;
import net.openai.util.fsm.Condition;
import net.openai.util.fsm.Machine;
import net.openai.util.fsm.State;
import org.apache.ctakes.core.fsm.condition.TextSetCondition;
import org.apache.ctakes.core.fsm.state.NamedState;
import org.apache.ctakes.core.fsm.state.NonTerminalEndState;
import org.apache.ctakes.core.fsm.token.BaseToken;
import org.apache.ctakes.drugner.fsm.output.util.NonIndicator;

public class NonIndicatorFSM {
    private Set iv_negDeterminersSet = new HashSet();
    private Set iv_machineSet = new HashSet();
    private Set iv_negInitialDeterminersSet = new HashSet();
    private Machine iv_negInitialDetermineMachine = new Machine();

    public NonIndicatorFSM() {
        this.iv_negDeterminersSet.add("non");
        this.iv_negInitialDeterminersSet.add("No");
        this.iv_negInitialDetermineMachine = this.getInitialNegIndicatorMachine();
        this.iv_machineSet.add(this.getAdjNegIndicatorMachine());
        this.iv_machineSet.add(this.iv_negInitialDetermineMachine);
    }

    private Machine getInitialNegIndicatorMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        NonTerminalEndState ntEndState = new NonTerminalEndState("NON TERMINAL END");
        endState.setEndStateFlag(true);
        ntEndState.setEndStateFlag(true);
        Machine m = new Machine((State)startState);
        NamedState negDetState = new NamedState("NEG_DET");
        TextSetCondition negInitDetC = new TextSetCondition(this.iv_negInitialDeterminersSet, true);
        startState.addTransition((Condition)negInitDetC, (State)negDetState);
        startState.addTransition((Condition)new AnyCondition(), (State)startState);
        negDetState.addTransition((Condition)new AnyCondition(), (State)startState);
        endState.addTransition((Condition)new AnyCondition(), (State)startState);
        return m;
    }

    private Machine getAdjNegIndicatorMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine((State)startState);
        NamedState negAdjState = new NamedState("NEG_ADJ");
        TextSetCondition negDetC = new TextSetCondition(this.iv_negDeterminersSet, false);
        startState.addTransition((Condition)negDetC, (State)negAdjState);
        startState.addTransition((Condition)new AnyCondition(), (State)startState);
        negAdjState.addTransition((Condition)new AnyCondition(), (State)startState);
        return m;
    }

    public Set execute(List tokens) throws Exception {
        HashSet<NonIndicator> outSet = new HashSet<NonIndicator>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        for (int i = 0; i < tokens.size(); ++i) {
            BaseToken token = (BaseToken)tokens.get(i);
            for (Machine fsm : this.iv_machineSet) {
                int tokenStartIndex;
                fsm.input((Object)token);
                State currentState = fsm.getCurrentState();
                if (currentState.getStartStateFlag()) {
                    tokenStartMap.put(fsm, new Integer(i));
                }
                if (!currentState.getEndStateFlag()) continue;
                Object o = tokenStartMap.get(fsm);
                if (o == null) {
                    tokenStartIndex = 0;
                } else {
                    tokenStartIndex = (Integer)o;
                    ++tokenStartIndex;
                }
                BaseToken endToken = null;
                endToken = currentState instanceof NonTerminalEndState ? (BaseToken)tokens.get(i - 1) : token;
                BaseToken startToken = (BaseToken)tokens.get(tokenStartIndex);
                NonIndicator neg = null;
                neg = fsm.equals(this.iv_negInitialDetermineMachine) ? new NonIndicator(startToken.getStartOffset(), endToken.getEndOffset()) : new NonIndicator(startToken.getStartOffset(), endToken.getEndOffset());
                outSet.add(neg);
                fsm.reset();
            }
        }
        tokenStartMap.clear();
        for (Machine fsm : this.iv_machineSet) {
            fsm.reset();
        }
        return outSet;
    }
}

