/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.drugner.fsm.machines.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.openai.util.fsm.AnyCondition;
import net.openai.util.fsm.Condition;
import net.openai.util.fsm.Machine;
import net.openai.util.fsm.State;
import org.apache.ctakes.core.fsm.condition.TextSetCondition;
import org.apache.ctakes.core.fsm.condition.TextValueCondition;
import org.apache.ctakes.core.fsm.output.StatusIndicator;
import org.apache.ctakes.core.fsm.state.NamedState;
import org.apache.ctakes.core.fsm.state.NonTerminalEndState;
import org.apache.ctakes.core.fsm.token.BaseToken;

public class StatusIndicatorFSM {
    private Set iv_probableSet = new HashSet();
    private Set iv_historySet = new HashSet();
    private Set iv_histColPartSet = new HashSet();
    private Set iv_histCollocSet = new HashSet();
    private Set iv_probableColPartSet = new HashSet();
    private Set iv_probableCollocSet = new HashSet();
    private Set iv_familyHistorySet = new HashSet();
    private Machine iv_probableMachine;
    private Machine iv_probableMachineNoTerm;
    private Machine iv_historyMachine;
    private Machine iv_familyHistoryMachine;
    private Set iv_machineSet = new HashSet();

    private Machine getProbableMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        NamedState dualState = new NamedState("DUALSTATE");
        endState.setEndStateFlag(true);
        Machine m = new Machine((State)startState);
        TextSetCondition probableC = new TextSetCondition(this.iv_probableSet, false);
        startState.addTransition((Condition)probableC, (State)endState);
        startState.addTransition((Condition)new AnyCondition(), (State)startState);
        dualState.addTransition((Condition)new AnyCondition(), (State)startState);
        endState.addTransition((Condition)new AnyCondition(), (State)startState);
        return m;
    }

    public StatusIndicatorFSM() {
        this.iv_probableSet.add("possible");
        this.iv_probableSet.add("possibly");
        this.iv_probableSet.add("possibility");
        this.iv_probableSet.add("probable");
        this.iv_probableSet.add("likely");
        this.iv_probableSet.add("questionable");
        this.iv_probableSet.add("question");
        this.iv_probableSet.add("probability");
        this.iv_probableSet.add("differential");
        this.iv_probableSet.add("may");
        this.iv_probableSet.add("consider");
        this.iv_probableSet.add("evaluate");
        this.iv_probableSet.add("evaluation");
        this.iv_probableSet.add("might");
        this.iv_probableSet.add("?");
        this.iv_probableSet.add("vs");
        this.iv_probableSet.add("considered");
        this.iv_probableCollocSet.add("questionable");
        this.iv_probableColPartSet.add("history");
        this.iv_probableColPartSet.add("hx");
        this.iv_histColPartSet.add("status");
        this.iv_histCollocSet.add("post");
        this.iv_historySet.add("hx");
        this.iv_historySet.add("h/o");
        this.iv_historySet.add("s/p");
        this.iv_historySet.add("history");
        this.iv_familyHistorySet.add("fx");
        this.iv_familyHistorySet.add("fh");
        this.iv_familyHistorySet.add("mother");
        this.iv_familyHistorySet.add("father");
        this.iv_familyHistorySet.add("sister");
        this.iv_familyHistorySet.add("brother");
        this.iv_familyHistorySet.add("son");
        this.iv_familyHistorySet.add("daugher");
        this.iv_familyHistorySet.add("grandfather");
        this.iv_familyHistorySet.add("grandmother");
        this.iv_historyMachine = this.getHistoryMachine();
        this.iv_probableMachine = this.getProbableMachine();
        this.iv_probableMachineNoTerm = this.getProbableMachineNonTerm();
        this.iv_familyHistoryMachine = this.getFamilyHistoryMachine();
        this.iv_machineSet.add(this.iv_historyMachine);
        this.iv_machineSet.add(this.iv_probableMachineNoTerm);
        this.iv_machineSet.add(this.iv_probableMachine);
        this.iv_machineSet.add(this.iv_familyHistoryMachine);
    }

    private Machine getProbableMachineNonTerm() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        NamedState anyState = new NamedState("ANY");
        NonTerminalEndState ntEndState = new NonTerminalEndState("NON TERMINAL END");
        endState.setEndStateFlag(true);
        ntEndState.setEndStateFlag(true);
        NamedState hAbbrState = new NamedState("HISTORY_ABBR");
        NamedState oAbbrState = new NamedState("OF_ABBR");
        Machine m = new Machine((State)startState);
        NamedState fslashState = new NamedState("FORWARD_SLASH");
        NamedState probCollocState = new NamedState("PROB_COLLOC");
        NamedState probFamilyPartState = new NamedState("PROB_FAMC");
        NamedState probColPartState = new NamedState("PROB_COLPART");
        TextSetCondition probCollecC = new TextSetCondition(this.iv_probableCollocSet, false);
        TextSetCondition probColPartC = new TextSetCondition(this.iv_probableColPartSet, false);
        startState.addTransition((Condition)probCollecC, (State)probCollocState);
        startState.addTransition((Condition)new AnyCondition(), (State)startState);
        probCollocState.addTransition((Condition)probColPartC, (State)probColPartState);
        probCollocState.addTransition((Condition)new TextValueCondition("h", false), (State)hAbbrState);
        probCollocState.addTransition((Condition)new AnyCondition(), (State)anyState);
        hAbbrState.addTransition((Condition)new TextValueCondition("/", false), (State)fslashState);
        hAbbrState.addTransition((Condition)new AnyCondition(), (State)startState);
        probFamilyPartState.addTransition((Condition)new AnyCondition(), (State)ntEndState);
        anyState.addTransition((Condition)new TextValueCondition("h", false), (State)hAbbrState);
        anyState.addTransition((Condition)new AnyCondition(), (State)anyState);
        fslashState.addTransition((Condition)new TextValueCondition("o", false), (State)oAbbrState);
        fslashState.addTransition((Condition)new AnyCondition(), (State)startState);
        oAbbrState.addTransition((Condition)new AnyCondition(), (State)ntEndState);
        oAbbrState.addTransition((Condition)new AnyCondition(), (State)startState);
        probColPartState.addTransition((Condition)new AnyCondition(), (State)ntEndState);
        ntEndState.addTransition((Condition)new AnyCondition(), (State)startState);
        return m;
    }

    private Machine getHistoryMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        NamedState hAbbrState = new NamedState("HISTORY_ABBR");
        NamedState sAbbrState = new NamedState("STATUS_ABBR");
        NamedState fslashState = new NamedState("FORWARD_SLASH");
        endState.setEndStateFlag(true);
        Machine m = new Machine((State)startState);
        TextSetCondition historyC = new TextSetCondition(this.iv_historySet, false);
        startState.addTransition((Condition)historyC, (State)endState);
        startState.addTransition((Condition)new TextValueCondition("h", false), (State)hAbbrState);
        startState.addTransition((Condition)new TextValueCondition("s", false), (State)hAbbrState);
        startState.addTransition((Condition)new AnyCondition(), (State)startState);
        hAbbrState.addTransition((Condition)new TextValueCondition("/", false), (State)fslashState);
        hAbbrState.addTransition((Condition)new AnyCondition(), (State)startState);
        sAbbrState.addTransition((Condition)new TextValueCondition("/", false), (State)fslashState);
        sAbbrState.addTransition((Condition)new AnyCondition(), (State)startState);
        fslashState.addTransition((Condition)new TextValueCondition("o", false), (State)endState);
        fslashState.addTransition((Condition)new TextValueCondition("p", false), (State)endState);
        fslashState.addTransition((Condition)new AnyCondition(), (State)startState);
        endState.addTransition((Condition)new AnyCondition(), (State)startState);
        return m;
    }

    private Machine getFamilyHistoryMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        NamedState familyState = new NamedState("FAMILY");
        endState.setEndStateFlag(true);
        Machine m = new Machine((State)startState);
        TextSetCondition familyHistoryC = new TextSetCondition(this.iv_familyHistorySet, false);
        startState.addTransition((Condition)familyHistoryC, (State)endState);
        startState.addTransition((Condition)new TextValueCondition("family", false), (State)familyState);
        startState.addTransition((Condition)new AnyCondition(), (State)startState);
        familyState.addTransition((Condition)new TextValueCondition("history", false), (State)endState);
        familyState.addTransition((Condition)new AnyCondition(), (State)startState);
        endState.addTransition((Condition)new AnyCondition(), (State)startState);
        return m;
    }

    public Set execute(List tokens) throws Exception {
        HashSet<StatusIndicator> outSet = new HashSet<StatusIndicator>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        for (int i = 0; i < tokens.size(); ++i) {
            BaseToken token = (BaseToken)tokens.get(i);
            for (Machine m : this.iv_machineSet) {
                int tokenStartIndex;
                m.input((Object)token);
                State currentState = m.getCurrentState();
                if (currentState.getStartStateFlag()) {
                    tokenStartMap.put(m, new Integer(i));
                }
                if (!currentState.getEndStateFlag()) continue;
                Object o = tokenStartMap.get(m);
                if (o == null) {
                    tokenStartIndex = 0;
                } else {
                    tokenStartIndex = (Integer)o;
                    ++tokenStartIndex;
                }
                BaseToken endToken = null;
                endToken = currentState instanceof NonTerminalEndState ? (BaseToken)tokens.get(i - 1) : token;
                BaseToken startToken = (BaseToken)tokens.get(tokenStartIndex);
                StatusIndicator si = null;
                if (m.equals(this.iv_historyMachine)) {
                    si = new StatusIndicator(startToken.getStartOffset(), endToken.getEndOffset(), 1);
                } else if (m.equals(this.iv_probableMachine) || m.equals(this.iv_probableMachineNoTerm)) {
                    si = new StatusIndicator(startToken.getStartOffset(), endToken.getEndOffset(), 3);
                } else if (m.equals(this.iv_familyHistoryMachine)) {
                    si = new StatusIndicator(startToken.getStartOffset(), endToken.getEndOffset(), 2);
                }
                outSet.add(si);
                m.reset();
            }
        }
        tokenStartMap.clear();
        for (Machine m : this.iv_machineSet) {
            m.reset();
        }
        return outSet;
    }
}

