/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.jar;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.encoder.outcome.OutcomeEncoder;
import org.cleartk.ml.jar.JarClassifierBuilder;
import org.cleartk.ml.jar.JarStreams;
import org.cleartk.util.ReflectionUtil;

public abstract class EncodingJarClassifierBuilder<CLASSIFIER_TYPE, ENCODED_FEATURES_TYPE, OUTCOME_TYPE, ENCODED_OUTCOME_TYPE>
extends JarClassifierBuilder<CLASSIFIER_TYPE> {
    private static final String ENCODERS_FILE_NAME = "encoders.ser";
    protected FeaturesEncoder<ENCODED_FEATURES_TYPE> featuresEncoder;
    protected OutcomeEncoder<OUTCOME_TYPE, ENCODED_OUTCOME_TYPE> outcomeEncoder;

    public static File getEncodersFile(File dir) {
        return new File(dir, ENCODERS_FILE_NAME);
    }

    public FeaturesEncoder<ENCODED_FEATURES_TYPE> getFeaturesEncoder() {
        return this.featuresEncoder;
    }

    public void setFeaturesEncoder(FeaturesEncoder<ENCODED_FEATURES_TYPE> featuresEncoder) {
        this.featuresEncoder = featuresEncoder;
    }

    public OutcomeEncoder<OUTCOME_TYPE, ENCODED_OUTCOME_TYPE> getOutcomeEncoder() {
        return this.outcomeEncoder;
    }

    public void setOutcomeEncoder(OutcomeEncoder<OUTCOME_TYPE, ENCODED_OUTCOME_TYPE> outcomeEncoder) {
        this.outcomeEncoder = outcomeEncoder;
    }

    public abstract File getTrainingDataFile(File var1);

    @Override
    public void saveToTrainingDirectory(File dir) throws IOException {
        super.saveToTrainingDirectory(dir);
        this.featuresEncoder.finalizeFeatureSet(dir);
        this.outcomeEncoder.finalizeOutcomeSet(dir);
        File encodersFile = EncodingJarClassifierBuilder.getEncodersFile(dir);
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(encodersFile));
        ObjectOutputStream os = new ObjectOutputStream(outputStream);
        os.writeObject(this.featuresEncoder);
        os.writeObject(this.outcomeEncoder);
        os.close();
        ((OutputStream)outputStream).close();
    }

    @Override
    protected void packageClassifier(File dir, JarOutputStream modelStream) throws IOException {
        super.packageClassifier(dir, modelStream);
        JarStreams.putNextJarEntry(modelStream, ENCODERS_FILE_NAME, EncodingJarClassifierBuilder.getEncodersFile(dir));
    }

    @Override
    protected void unpackageClassifier(JarInputStream modelStream) throws IOException {
        super.unpackageClassifier(modelStream);
        JarStreams.getNextJarEntry(modelStream, ENCODERS_FILE_NAME);
        ObjectInputStream is = new ObjectInputStream(modelStream);
        try {
            this.featuresEncoder = this.featuresEncoderCast(is.readObject());
            this.outcomeEncoder = this.outcomeEncoderCast(is.readObject());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Classes not found for serialized encoder objects", e);
        }
    }

    private FeaturesEncoder<ENCODED_FEATURES_TYPE> featuresEncoderCast(Object object) {
        FeaturesEncoder encoder = (FeaturesEncoder)object;
        ReflectionUtil.checkTypeParametersAreEqual(EncodingJarClassifierBuilder.class, (String)"ENCODED_FEATURES_TYPE", (Object)this, FeaturesEncoder.class, (String)"ENCODED_FEATURES_TYPE", (Object)encoder, ClassCastException.class);
        return encoder;
    }

    private OutcomeEncoder<OUTCOME_TYPE, ENCODED_OUTCOME_TYPE> outcomeEncoderCast(Object object) {
        OutcomeEncoder encoder = (OutcomeEncoder)object;
        ReflectionUtil.checkTypeParametersAreEqual(EncodingJarClassifierBuilder.class, (String)"OUTCOME_TYPE", (Object)this, OutcomeEncoder.class, (String)"OUTCOME_TYPE", (Object)encoder, ClassCastException.class);
        ReflectionUtil.checkTypeParametersAreEqual(EncodingJarClassifierBuilder.class, (String)"ENCODED_OUTCOME_TYPE", (Object)this, OutcomeEncoder.class, (String)"ENCODED_OUTCOME_TYPE", (Object)encoder, ClassCastException.class);
        return encoder;
    }
}

