/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.svmlight;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.encoder.outcome.OutcomeEncoder;
import org.cleartk.ml.jar.JarStreams;
import org.cleartk.ml.sigmoid.Sigmoid;
import org.cleartk.ml.svmlight.FitSigmoid;
import org.cleartk.ml.svmlight.SvmLightBooleanOutcomeClassifier;
import org.cleartk.ml.svmlight.SvmLightClassifierBuilder_ImplBase;
import org.cleartk.ml.util.featurevector.FeatureVector;

public class SvmLightBooleanOutcomeClassifierBuilder
extends SvmLightClassifierBuilder_ImplBase<SvmLightBooleanOutcomeClassifier, Boolean, Boolean> {
    protected Sigmoid sigmoid;

    private File getSigmoidFile(File dir) {
        return new File(dir, "training-data.svmlight.sigmoid");
    }

    @Override
    public void trainClassifier(File dir, String ... args) throws Exception {
        super.trainClassifier(dir, args);
        Sigmoid s = FitSigmoid.fit(this.getModelFile(dir), this.getTrainingDataFile(dir));
        System.out.println("Computed output mapping function: " + s.toString());
        ObjectOutputStream o = new ObjectOutputStream(new FileOutputStream(this.getSigmoidFile(dir)));
        o.writeObject(s);
        o.close();
    }

    @Override
    protected void packageClassifier(File dir, JarOutputStream modelStream) throws IOException {
        super.packageClassifier(dir, modelStream);
        JarStreams.putNextJarEntry((JarOutputStream)modelStream, (String)"model.sigmoid", (File)this.getSigmoidFile(dir));
    }

    @Override
    protected void unpackageClassifier(JarInputStream modelStream) throws IOException {
        super.unpackageClassifier(modelStream);
        JarStreams.getNextJarEntry((JarInputStream)modelStream, (String)"model.sigmoid");
        ObjectInputStream in = new ObjectInputStream(modelStream);
        try {
            this.sigmoid = (Sigmoid)in.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        in.close();
    }

    protected SvmLightBooleanOutcomeClassifier newClassifier() {
        return new SvmLightBooleanOutcomeClassifier((FeaturesEncoder<FeatureVector>)this.featuresEncoder, (OutcomeEncoder<Boolean, Boolean>)this.outcomeEncoder, this.model, this.sigmoid);
    }
}

