/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.svmlight;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.cleartk.ml.CleartkProcessingException;
import org.cleartk.ml.encoder.features.BooleanEncoder;
import org.cleartk.ml.encoder.features.FeatureEncoder;
import org.cleartk.ml.encoder.features.FeatureVectorFeaturesEncoder;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.encoder.features.NumberEncoder;
import org.cleartk.ml.encoder.features.StringEncoder;
import org.cleartk.ml.encoder.outcome.OutcomeEncoder;
import org.cleartk.ml.encoder.outcome.StringToIntegerOutcomeEncoder;
import org.cleartk.ml.jar.DataWriter_ImplBase;
import org.cleartk.ml.svmlight.SvmLightStringOutcomeClassifierBuilder;
import org.cleartk.ml.util.featurevector.FeatureVector;

public class SvmLightStringOutcomeDataWriter
extends DataWriter_ImplBase<SvmLightStringOutcomeClassifierBuilder, FeatureVector, String, Integer> {
    private File allFalseFile;
    private PrintWriter allFalseWriter;
    private Map<Integer, PrintWriter> trainingDataWriters;

    public SvmLightStringOutcomeDataWriter(File outputDirectory) throws IOException {
        super(outputDirectory);
        FeatureVectorFeaturesEncoder myFeaturesEncoder = new FeatureVectorFeaturesEncoder();
        myFeaturesEncoder.addEncoder((FeatureEncoder)new NumberEncoder());
        myFeaturesEncoder.addEncoder((FeatureEncoder)new BooleanEncoder());
        myFeaturesEncoder.addEncoder((FeatureEncoder)new StringEncoder());
        this.setFeaturesEncoder((FeaturesEncoder)myFeaturesEncoder);
        this.setOutcomeEncoder((OutcomeEncoder)new StringToIntegerOutcomeEncoder());
        this.allFalseFile = this.trainingDataFile;
        this.allFalseWriter = this.trainingDataWriter;
        this.trainingDataWriters = new TreeMap<Integer, PrintWriter>();
    }

    public void writeEncoded(FeatureVector features, Integer outcome) throws CleartkProcessingException {
        if (outcome != null && !this.trainingDataWriters.containsKey(outcome)) {
            try {
                this.addClass(outcome);
            }
            catch (IOException e) {
                throw new CleartkProcessingException((Throwable)e);
            }
        }
        StringBuffer featureString = new StringBuffer();
        for (FeatureVector.Entry entry : features) {
            featureString.append(String.format(Locale.US, " %d:%.7f", entry.index, entry.value));
        }
        StringBuffer output = new StringBuffer();
        if (outcome == null) {
            output.append("0");
        } else {
            output.append("-1");
        }
        output.append(featureString);
        this.allFalseWriter.println(output);
        for (int i : this.trainingDataWriters.keySet()) {
            output = new StringBuffer();
            if (outcome == null) {
                output.append("0");
            } else if (outcome == i) {
                output.append("+1");
            } else {
                output.append("-1");
            }
            output.append(featureString);
            this.trainingDataWriters.get(i).println(output);
        }
    }

    public void finish() throws CleartkProcessingException {
        this.allFalseWriter.close();
        this.allFalseFile.delete();
        for (PrintWriter pw : this.trainingDataWriters.values()) {
            pw.flush();
            pw.close();
        }
        super.finish();
    }

    protected SvmLightStringOutcomeClassifierBuilder newClassifierBuilder() {
        return new SvmLightStringOutcomeClassifierBuilder();
    }

    private void addClass(int label) throws IOException {
        File newTDFile = ((SvmLightStringOutcomeClassifierBuilder)this.classifierBuilder).getTrainingDataFile(this.outputDirectory, label);
        newTDFile.delete();
        this.allFalseWriter.flush();
        this.copyFile(this.allFalseFile, newTDFile);
        this.trainingDataWriters.put(label, new PrintWriter(new BufferedWriter(new FileWriter(newTDFile, true))));
    }

    private void copyFile(File source, File target) throws IOException {
        FileInputStream srcStream = new FileInputStream(source);
        FileChannel srcChannel = srcStream.getChannel();
        FileOutputStream dstStream = new FileOutputStream(target);
        FileChannel dstChannel = dstStream.getChannel();
        dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
        srcStream.close();
        srcChannel.close();
        dstStream.close();
        dstChannel.close();
    }
}

