/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.dkpro.core.api.metadata;

import de.tudarmstadt.ukp.dkpro.core.api.metadata.TagsetBase;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SingletonTagset
extends TagsetBase {
    private String layer;
    private String tagset;
    private Set<String> tags;

    public SingletonTagset(Class<?> aLayer, String aTagsetName) {
        this.layer = aLayer.getName();
        this.tagset = aTagsetName;
        this.tags = new TreeSet<String>();
    }

    @Override
    public Map<String, String> getLayers() {
        return Collections.singletonMap(this.layer, this.tagset);
    }

    @Override
    public Set<String> listTags(String aLayer, String aTagsetName) {
        return this.tags;
    }

    public void add(String aTag) {
        this.tags.add(aTag);
    }

    public void addAll(Collection<String> aTags) {
        this.tags.addAll(aTags);
    }

    public void removeAll(SingletonTagset aOther) {
        Map.Entry<String, String> entry = aOther.getLayers().entrySet().iterator().next();
        this.tags.removeAll(aOther.listTags(entry.getKey(), entry.getValue()));
    }
}

