/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.tksvmlight;

import com.google.common.annotations.Beta;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.TreeMap;
import org.cleartk.ml.CleartkProcessingException;
import org.cleartk.ml.encoder.features.BooleanEncoder;
import org.cleartk.ml.encoder.features.FeatureEncoder;
import org.cleartk.ml.encoder.features.NameNumber;
import org.cleartk.ml.encoder.features.NumberEncoder;
import org.cleartk.ml.encoder.features.StringEncoder;
import org.cleartk.ml.encoder.outcome.OutcomeEncoder;
import org.cleartk.ml.encoder.outcome.StringToIntegerOutcomeEncoder;
import org.cleartk.ml.jar.DataWriter_ImplBase;
import org.cleartk.ml.tksvmlight.TreeFeatureVector;
import org.cleartk.ml.tksvmlight.TreeFeatureVectorFeaturesEncoder;
import org.cleartk.ml.tksvmlight.TreeKernelSvmBooleanOutcomeDataWriter;
import org.cleartk.ml.tksvmlight.TreeKernelSvmStringOutcomeClassifierBuilder;

@Beta
public abstract class TreeKernelSvmStringOutcomeDataWriter<CLASSIFIER_BUILDER_TYPE extends TreeKernelSvmStringOutcomeClassifierBuilder>
extends DataWriter_ImplBase<CLASSIFIER_BUILDER_TYPE, TreeFeatureVector, String, Integer> {
    protected File allFalseFile;
    protected PrintWriter allFalseWriter;
    protected Map<Integer, PrintWriter> trainingDataWriters;

    public TreeKernelSvmStringOutcomeDataWriter(File outputDirectory) throws FileNotFoundException {
        super(outputDirectory);
        TreeFeatureVectorFeaturesEncoder myFeaturesEncoder = new TreeFeatureVectorFeaturesEncoder();
        myFeaturesEncoder.addEncoder((FeatureEncoder<NameNumber>)new NumberEncoder());
        myFeaturesEncoder.addEncoder((FeatureEncoder<NameNumber>)new BooleanEncoder());
        myFeaturesEncoder.addEncoder((FeatureEncoder<NameNumber>)new StringEncoder());
        this.setFeaturesEncoder(myFeaturesEncoder);
        this.setOutcomeEncoder((OutcomeEncoder)new StringToIntegerOutcomeEncoder());
        this.allFalseFile = this.trainingDataFile;
        this.allFalseWriter = this.trainingDataWriter;
        this.trainingDataWriters = new TreeMap<Integer, PrintWriter>();
    }

    protected void writeEncoded(TreeFeatureVector features, Integer outcome) throws CleartkProcessingException {
        if (outcome != null && !this.trainingDataWriters.containsKey(outcome)) {
            try {
                this.addClass(outcome);
            }
            catch (IOException e) {
                throw new CleartkProcessingException((Throwable)e);
            }
        }
        StringBuffer featureString = new StringBuffer();
        featureString.append(TreeKernelSvmBooleanOutcomeDataWriter.createString(features));
        StringBuffer output = new StringBuffer();
        if (outcome == null) {
            output.append("0");
        } else {
            output.append("-1");
        }
        output.append(featureString);
        this.allFalseWriter.println(output);
        for (int i : this.trainingDataWriters.keySet()) {
            output = new StringBuffer();
            if (outcome == null) {
                output.append("0");
            } else if (outcome == i) {
                output.append("+1");
            } else {
                output.append("-1");
            }
            output.append(featureString);
            this.trainingDataWriters.get(i).println(output);
        }
    }

    public void finish() throws CleartkProcessingException {
        this.allFalseWriter.close();
        this.allFalseFile.delete();
        for (PrintWriter pw : this.trainingDataWriters.values()) {
            pw.flush();
            pw.close();
        }
        super.finish();
    }

    private void addClass(int label) throws IOException {
        File newTDFile = ((TreeKernelSvmStringOutcomeClassifierBuilder)this.classifierBuilder).getTrainingDataFile(this.outputDirectory, label);
        newTDFile.delete();
        this.allFalseWriter.flush();
        this.copyFile(this.allFalseFile, newTDFile);
        this.trainingDataWriters.put(label, new PrintWriter(new BufferedWriter(new FileWriter(newTDFile, true))));
    }

    private void copyFile(File source, File target) throws IOException {
        FileInputStream srcStream = new FileInputStream(source);
        FileChannel srcChannel = srcStream.getChannel();
        FileOutputStream dstStream = new FileOutputStream(target);
        FileChannel dstChannel = dstStream.getChannel();
        dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
        srcStream.close();
        srcChannel.close();
        dstStream.close();
        dstChannel.close();
    }
}

