/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.ae;

import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Single Sectionizer", description="Annotates Document as a single Section.", products={PipeBitInfo.TypeProduct.SECTION})
public class SimpleSegmentAnnotator
extends JCasAnnotator_ImplBase {
    public static final String PARAM_SEGMENT_ID = "SegmentID";
    @ConfigurationParameter(name="SegmentID", mandatory=false, defaultValue={"SIMPLE_SEGMENT"}, description="Name to give to all segments")
    private String segmentId;

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        Segment segment = new Segment(jCas);
        segment.setBegin(0);
        String text = jCas.getDocumentText();
        if (text == null) {
            String docId = DocumentIDAnnotationUtil.getDocumentID(jCas);
            throw new AnalysisEngineProcessException("text is null for docId=" + docId, null);
        }
        segment.setEnd(jCas.getDocumentText().length());
        segment.setId(this.segmentId);
        segment.addToIndexes();
    }

    public static AnalysisEngineDescription createAnnotatorDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(SimpleSegmentAnnotator.class, (Object[])new Object[0]);
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String segmentID) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(SimpleSegmentAnnotator.class, (Object[])new Object[]{PARAM_SEGMENT_ID, segmentID});
    }
}

